/*
 * Decompiled with CFR 0.152.
 */
package dasniko.testcontainers.keycloak;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.MountableFile;

public class KeycloakContainer
extends GenericContainer<KeycloakContainer> {
    private static final String KEYCLOAK_IMAGE = "quay.io/keycloak/keycloak";
    private static final String KEYCLOAK_VERSION = "16.0.0";
    private static final int KEYCLOAK_PORT_HTTP = 8080;
    private static final int KEYCLOAK_PORT_HTTPS = 8443;
    private static final Duration DEFAULT_STARTUP_TIMEOUT = Duration.ofMinutes(2L);
    private static final String KEYCLOAK_ADMIN_USER = "admin";
    private static final String KEYCLOAK_ADMIN_PASSWORD = "admin";
    private static final String KEYCLOAK_AUTH_PATH = "/auth";
    private static final String DB_VENDOR = "h2";
    private static final String DEFAULT_EXTENSION_NAME = "extensions.jar";
    private static final String DEFAULT_PROVIDERS_NAME = "providers.jar";
    private static final String DEFAULT_KEYCLOAK_DEPLOYMENTS_LOCATION = "/opt/jboss/keycloak/standalone/deployments";
    private static final String DEFAULT_KEYCLOAK_PROVIDERS_LOCATION = "/opt/jboss/keycloak/providers";
    private String adminUsername = "admin";
    private String adminPassword = "admin";
    private String dbVendor = "h2";
    private final Set<String> importFiles;
    private final Set<String> startupScripts;
    private String tlsCertFilename;
    private String tlsKeyFilename;
    private boolean useTls = false;
    private Duration startupTimeout = DEFAULT_STARTUP_TIMEOUT;
    private String extensionClassLocation;
    private String providerClassLocation;
    private static final Transferable WILDFLY_DEPLOYMENT_TRIGGER_FILE_CONTENT = Transferable.of((byte[])"true".getBytes(StandardCharsets.UTF_8));
    private final Set<String> wildflyDeploymentTriggerFiles = new HashSet<String>();

    public KeycloakContainer() {
        this("quay.io/keycloak/keycloak:16.0.0");
    }

    public KeycloakContainer(String dockerImageName) {
        super(dockerImageName);
        this.withExposedPorts(new Integer[]{8080, 8443});
        this.importFiles = new HashSet<String>();
        this.startupScripts = new HashSet<String>();
        this.withLogConsumer((Consumer)new Slf4jLogConsumer(this.logger()));
    }

    protected void configure() {
        this.setCommand(new String[]{"-c standalone.xml", "-b 0.0.0.0", "-Dkeycloak.profile.feature.upload_scripts=enabled"});
        this.setWaitStrategy(Wait.forHttp((String)KEYCLOAK_AUTH_PATH).forPort(8080).withStartupTimeout(this.startupTimeout));
        this.withEnv("KEYCLOAK_USER", this.adminUsername);
        this.withEnv("KEYCLOAK_PASSWORD", this.adminPassword);
        this.withEnv("DB_VENDOR", this.dbVendor);
        if (this.useTls && this.isNotBlank(this.tlsCertFilename) && this.isNotBlank(this.tlsKeyFilename)) {
            String certFileInContainer = "/etc/x509/https/tls.crt";
            String keyFileInContainer = "/etc/x509/https/tls.key";
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.tlsCertFilename), certFileInContainer);
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.tlsKeyFilename), keyFileInContainer);
        }
        ArrayList<String> importFilesInContainer = new ArrayList<String>();
        for (String importFile : this.importFiles) {
            String importFileInContainer = "/tmp/" + importFile;
            importFilesInContainer.add(importFileInContainer);
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)importFile), importFileInContainer);
        }
        if (!this.importFiles.isEmpty()) {
            this.withEnv("KEYCLOAK_IMPORT", String.join((CharSequence)",", importFilesInContainer));
        }
        for (String startupScript : this.startupScripts) {
            String startupScriptInContainer = "/opt/jboss/startup-scripts/" + startupScript;
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)startupScript), startupScriptInContainer);
        }
        if (this.extensionClassLocation != null) {
            this.createKeycloakExtensionDeployment(this.extensionClassLocation);
        }
        if (this.providerClassLocation != null) {
            this.createKeycloakExtensionProvider(this.providerClassLocation);
        }
    }

    public KeycloakContainer withCommand(String cmd) {
        this.logger().warn("You are trying to set custom container commands, which are currently not supported by this Testcontainer.");
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer withCommand(String ... commandParts) {
        this.logger().warn("You are trying to set custom container commands, which are currently not supported by this Testcontainer.");
        return (KeycloakContainer)this.self();
    }

    public void createKeycloakExtensionDeployment(String extensionClassFolder) {
        this.createKeycloakExtensionDeployment(DEFAULT_KEYCLOAK_DEPLOYMENTS_LOCATION, DEFAULT_EXTENSION_NAME, extensionClassFolder);
    }

    public void createKeycloakExtensionProvider(String extensionClassFolder) {
        this.createKeycloakExtensionDeployment(DEFAULT_KEYCLOAK_PROVIDERS_LOCATION, DEFAULT_PROVIDERS_NAME, extensionClassFolder);
    }

    protected void createKeycloakExtensionDeployment(String deploymentLocation, String extensionName, String extensionClassFolder) {
        Objects.requireNonNull(deploymentLocation, "deploymentLocation");
        Objects.requireNonNull(extensionName, "extensionName");
        Objects.requireNonNull(extensionClassFolder, "extensionClassFolder");
        String classesLocation = this.resolveExtensionClassLocation(extensionClassFolder);
        if (!new File(classesLocation).exists()) {
            return;
        }
        String explodedFolderName = extensionClassFolder.hashCode() + "-" + extensionName;
        String explodedFolderExtensionsJar = deploymentLocation + "/" + explodedFolderName;
        try (Stream<Path> extensionPathStream = Files.walk(Paths.get(extensionClassFolder, new String[0]), new FileVisitOption[0]);){
            extensionPathStream.forEach(extPath -> {
                if (!Files.isDirectory(extPath, new LinkOption[0])) {
                    this.withCopyFileToContainer(MountableFile.forClasspathResource((String)extPath.toString().replace(extensionClassFolder, "")), explodedFolderExtensionsJar + extPath.toString().replace(extensionClassFolder, ""));
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        boolean wildflyDeployment = deploymentLocation.contains("/standalone/deployments");
        if (wildflyDeployment) {
            this.registerWildflyDeploymentTriggerFile(deploymentLocation, explodedFolderName);
            this.setWaitStrategy((WaitStrategy)this.createCombinedWaitAllStrategy((WaitStrategy)Wait.forLogMessage((String)(".* Deployed \"" + explodedFolderName + "\" .*"), (int)1)));
        }
    }

    private WaitAllStrategy createCombinedWaitAllStrategy(WaitStrategy waitStrategy) {
        WaitAllStrategy waitAll = new WaitAllStrategy();
        waitAll.withStartupTimeout(this.startupTimeout);
        WaitStrategy currentWaitStrategy = this.getWaitStrategy();
        if (currentWaitStrategy != null) {
            waitAll.withStrategy(currentWaitStrategy);
        }
        waitAll.withStrategy(waitStrategy);
        return waitAll;
    }

    private void registerWildflyDeploymentTriggerFile(String deploymentLocation, String extensionArtifact) {
        String triggerFileName = extensionArtifact + ".dodeploy";
        this.wildflyDeploymentTriggerFiles.add(deploymentLocation + "/" + triggerFileName);
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo) {
        this.createWildflyDeploymentTriggerFiles();
    }

    protected void containerIsStopping(InspectContainerResponse containerInfo) {
        this.wildflyDeploymentTriggerFiles.clear();
    }

    private void createWildflyDeploymentTriggerFiles() {
        this.wildflyDeploymentTriggerFiles.forEach(deploymentTriggerFile -> this.copyFileToContainer(WILDFLY_DEPLOYMENT_TRIGGER_FILE_CONTENT, (String)deploymentTriggerFile));
    }

    protected String resolveExtensionClassLocation(String extensionClassFolder) {
        String moduleFolder = MountableFile.forClasspathResource((String)".").getResolvedPath() + "/../../";
        return moduleFolder + extensionClassFolder;
    }

    public KeycloakContainer withRealmImportFile(String importFile) {
        this.importFiles.add(importFile);
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer withRealmImportFiles(String ... files) {
        Arrays.stream(files).forEach(this::withRealmImportFile);
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer withStartupScripts(String ... startupScripts) {
        this.startupScripts.addAll(Arrays.asList(startupScripts));
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer withAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer withAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
        return (KeycloakContainer)this.self();
    }

    @Deprecated
    public KeycloakContainer withDbVendor(String dbVendor) {
        this.dbVendor = dbVendor;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer withExtensionClassesFrom(String classesLocation) {
        this.extensionClassLocation = classesLocation;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer withProviderClassesFrom(String classesLocation) {
        this.providerClassLocation = classesLocation;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer useTls() {
        return this.useTls("tls.crt", "tls.key");
    }

    public KeycloakContainer withStartupTimeout(Duration startupTimeout) {
        this.startupTimeout = startupTimeout;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer useTls(String tlsCertFilename, String tlsKeyFilename) {
        this.tlsCertFilename = tlsCertFilename;
        this.tlsKeyFilename = tlsKeyFilename;
        this.useTls = true;
        return (KeycloakContainer)this.self();
    }

    public String getAuthServerUrl() {
        return String.format("http%s://%s:%s%s", this.useTls ? "s" : "", this.getContainerIpAddress(), this.useTls ? this.getMappedPort(8443) : this.getMappedPort(8080), KEYCLOAK_AUTH_PATH);
    }

    public String getAdminUsername() {
        return this.adminUsername;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public int getHttpPort() {
        return this.getMappedPort(8080);
    }

    public int getHttpsPort() {
        return this.getMappedPort(8443);
    }

    public Duration getStartupTimeout() {
        return this.startupTimeout;
    }

    protected String getKeycloakVersion() {
        return KEYCLOAK_VERSION;
    }

    private boolean isNotBlank(String s) {
        return s != null && !s.trim().isEmpty();
    }
}

