/*
 * Decompiled with CFR 0.152.
 */
package dasniko.testcontainers.keycloak;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.representations.idm.RealmRepresentation;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.utility.MountableFile;

public class KeycloakContainer
extends GenericContainer<KeycloakContainer> {
    public static final String MASTER_REALM = "master";
    public static final String ADMIN_CLI_CLIENT = "admin-cli";
    private static final String KEYCLOAK_IMAGE = "quay.io/keycloak/keycloak";
    private static final String KEYCLOAK_VERSION = "17.0.1";
    private static final int KEYCLOAK_PORT_HTTP = 8080;
    private static final int KEYCLOAK_PORT_HTTPS = 8443;
    private static final Duration DEFAULT_STARTUP_TIMEOUT = Duration.ofMinutes(2L);
    private static final String KEYCLOAK_ADMIN_USER = "admin";
    private static final String KEYCLOAK_ADMIN_PASSWORD = "admin";
    private static final String KEYCLOAK_CONTEXT_PATH = "/";
    private static final String DEFAULT_KEYCLOAK_PROVIDERS_NAME = "providers.jar";
    private static final String DEFAULT_KEYCLOAK_PROVIDERS_LOCATION = "/opt/keycloak/providers";
    private static final String KEYSTORE_FILE_IN_CONTAINER = "/opt/keycloak/conf/server.keystore";
    private String adminUsername = "admin";
    private String adminPassword = "admin";
    private String contextPath = "/";
    private final Set<String> importFiles;
    private String tlsCertificateFilename;
    private String tlsCertificateKeyFilename;
    private String tlsKeystoreFilename;
    private String tlsKeystorePassword;
    private boolean useTls = false;
    private String[] featuresEnabled = null;
    private String[] featuresDisabled = null;
    private Duration startupTimeout = DEFAULT_STARTUP_TIMEOUT;
    private String providerClassLocation;
    private List<File> providerLibsLocations;

    public KeycloakContainer() {
        this("quay.io/keycloak/keycloak:17.0.1");
    }

    public KeycloakContainer(String dockerImageName) {
        super(dockerImageName);
        this.withExposedPorts(new Integer[]{8080, 8443});
        this.importFiles = new HashSet<String>();
        this.withLogConsumer((Consumer)new Slf4jLogConsumer(this.logger()));
    }

    protected void configure() {
        ArrayList<Object> commandParts = new ArrayList<Object>();
        commandParts.add("start");
        commandParts.add("--auto-build");
        commandParts.add("--cache=local");
        commandParts.add("--http-enabled=true");
        commandParts.add("--hostname-strict=false");
        commandParts.add("--hostname-strict-https=false");
        if (!this.contextPath.equals(KEYCLOAK_CONTEXT_PATH)) {
            commandParts.add("--http-relative-path=" + this.contextPath);
        }
        if (this.featuresEnabled != null) {
            commandParts.add("--features=" + String.join((CharSequence)",", this.featuresEnabled));
        }
        if (this.featuresDisabled != null) {
            commandParts.add("--features-disabled=" + String.join((CharSequence)",", this.featuresDisabled));
        }
        this.setWaitStrategy(Wait.forHttp((String)this.contextPath).forPort(8080).withStartupTimeout(this.startupTimeout));
        this.withEnv("KEYCLOAK_ADMIN", this.adminUsername);
        this.withEnv("KEYCLOAK_ADMIN_PASSWORD", this.adminPassword);
        if (this.useTls && this.isNotBlank(this.tlsCertificateFilename)) {
            String tlsCertFilePath = "/opt/keycloak/conf/tls.crt";
            String tlsCertKeyFilePath = "/opt/keycloak/conf/tls.key";
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.tlsCertificateFilename), tlsCertFilePath);
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.tlsCertificateKeyFilename), tlsCertKeyFilePath);
            commandParts.add("--https-certificate-file=" + tlsCertFilePath);
            commandParts.add("--https-certificate-key-file=" + tlsCertKeyFilePath);
        } else if (this.useTls && this.isNotBlank(this.tlsKeystoreFilename)) {
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.tlsKeystoreFilename), KEYSTORE_FILE_IN_CONTAINER);
            commandParts.add("--https-key-store-file=/opt/keycloak/conf/server.keystore");
            commandParts.add("--https-key-store-password=" + this.tlsKeystorePassword);
        }
        if (this.providerClassLocation != null) {
            this.createKeycloakExtensionProvider(this.providerClassLocation);
        }
        if (this.providerLibsLocations != null) {
            this.providerLibsLocations.forEach(file -> {
                String containerPath = "/opt/keycloak/providers/" + file.getName();
                this.withCopyFileToContainer(MountableFile.forHostPath((String)file.getAbsolutePath()), containerPath);
            });
        }
        this.setCommand(commandParts.toArray(new String[0]));
    }

    public KeycloakContainer withCommand(String cmd) {
        throw new IllegalStateException("You are trying to set custom container commands, which is currently not supported by this Testcontainer.");
    }

    public KeycloakContainer withCommand(String ... commandParts) {
        throw new IllegalStateException("You are trying to set custom container commands, which is currently not supported by this Testcontainer.");
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo, boolean reused) {
        if (reused) {
            this.logger().info("This container is being reused, so we're skipping the realm import.");
            return;
        }
        if (!this.importFiles.isEmpty()) {
            this.logger().info("Connect to Keycloak container to import given realm files.");
            Keycloak kcAdmin = this.getKeycloakAdminClient();
            try {
                for (String importFile : this.importFiles) {
                    this.logger().info("Importing realm from file {}", (Object)importFile);
                    InputStream resourceStream = ((Object)((Object)this)).getClass().getResourceAsStream(importFile);
                    if (resourceStream == null) {
                        resourceStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(importFile);
                    }
                    kcAdmin.realms().create((RealmRepresentation)new ObjectMapper().readValue(resourceStream, RealmRepresentation.class));
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public void createKeycloakExtensionProvider(String extensionClassFolder) {
        this.createKeycloakExtensionDeployment(DEFAULT_KEYCLOAK_PROVIDERS_LOCATION, DEFAULT_KEYCLOAK_PROVIDERS_NAME, extensionClassFolder);
    }

    protected void createKeycloakExtensionDeployment(String deploymentLocation, String extensionName, String extensionClassFolder) {
        Objects.requireNonNull(deploymentLocation, "deploymentLocation must not be null");
        Objects.requireNonNull(extensionName, "extensionName must not be null");
        Objects.requireNonNull(extensionClassFolder, "extensionClassFolder must not be null");
        String classesLocation = this.resolveExtensionClassLocation(extensionClassFolder);
        if (new File(classesLocation).exists()) {
            try {
                File file = Files.createTempFile("keycloak", ".jar", new FileAttribute[0]).toFile();
                file.setReadable(true, false);
                file.deleteOnExit();
                ((ZipExporter)((ExplodedImporter)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)extensionName)).as(ExplodedImporter.class)).importDirectory(classesLocation).as(ZipExporter.class)).exportTo(file, true);
                this.withCopyFileToContainer(MountableFile.forHostPath((String)file.getAbsolutePath()), deploymentLocation + KEYCLOAK_CONTEXT_PATH + extensionName);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    protected String resolveExtensionClassLocation(String extensionClassFolder) {
        return Paths.get(MountableFile.forClasspathResource((String)".").getResolvedPath(), new String[0]).getParent().getParent().resolve(extensionClassFolder).toString();
    }

    public KeycloakContainer withRealmImportFile(String importFile) {
        this.importFiles.add(importFile);
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer withRealmImportFiles(String ... files) {
        Arrays.stream(files).forEach(this::withRealmImportFile);
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer withAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer withAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer withContextPath(String contextPath) {
        this.contextPath = contextPath;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer withProviderClassesFrom(String classesLocation) {
        this.providerClassLocation = classesLocation;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer withProviderLibsFrom(List<File> libs) {
        this.providerLibsLocations = libs;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer withStartupTimeout(Duration startupTimeout) {
        this.startupTimeout = startupTimeout;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer useTls() {
        return this.useTlsKeystore("tls.jks", "changeit");
    }

    public KeycloakContainer useTls(String tlsCertificateFilename, String tlsCertificateKeyFilename) {
        Objects.requireNonNull(tlsCertificateFilename, "tlsCertificateFilename must not be null");
        Objects.requireNonNull(tlsCertificateKeyFilename, "tlsCertificateKeyFilename must not be null");
        this.tlsCertificateFilename = tlsCertificateFilename;
        this.tlsCertificateKeyFilename = tlsCertificateKeyFilename;
        this.useTls = true;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer useTlsKeystore(String tlsKeystoreFilename, String tlsKeystorePassword) {
        Objects.requireNonNull(tlsKeystoreFilename, "tlsKeystoreFilename must not be null");
        Objects.requireNonNull(tlsKeystorePassword, "tlsKeystorePassword must not be null");
        this.tlsKeystoreFilename = tlsKeystoreFilename;
        this.tlsKeystorePassword = tlsKeystorePassword;
        this.useTls = true;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer withFeaturesEnabled(String ... features) {
        this.featuresEnabled = features;
        return (KeycloakContainer)this.self();
    }

    public KeycloakContainer withFeaturesDisabled(String ... features) {
        this.featuresDisabled = features;
        return (KeycloakContainer)this.self();
    }

    public Keycloak getKeycloakAdminClient() {
        return Keycloak.getInstance((String)this.getAuthServerUrl(), (String)MASTER_REALM, (String)this.getAdminUsername(), (String)this.getAdminPassword(), (String)ADMIN_CLI_CLIENT);
    }

    public String getAuthServerUrl() {
        return String.format("http%s://%s:%s%s", this.useTls ? "s" : "", this.getContainerIpAddress(), this.useTls ? this.getHttpsPort() : this.getHttpPort(), this.getContextPath());
    }

    public String getAdminUsername() {
        return this.adminUsername;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public int getHttpPort() {
        return this.getMappedPort(8080);
    }

    public int getHttpsPort() {
        return this.getMappedPort(8443);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Duration getStartupTimeout() {
        return this.startupTimeout;
    }

    protected String getKeycloakVersion() {
        return KEYCLOAK_VERSION;
    }

    private boolean isNotBlank(String s) {
        return s != null && !s.trim().isEmpty();
    }
}

