/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.junit5;

import com.github.database.rider.core.AbstractRiderTestContext;
import com.github.database.rider.core.api.dataset.DataSetExecutor;
import com.github.database.rider.junit5.util.EntityManagerProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public class JUnit5RiderTestContext
extends AbstractRiderTestContext {
    private final ExtensionContext extensionContext;

    public JUnit5RiderTestContext(DataSetExecutor executor, ExtensionContext extensionContext) {
        super(executor);
        this.extensionContext = extensionContext;
    }

    public String getMethodName() {
        return this.extensionContext.getTestMethod().map(Method::getName).orElse(null);
    }

    public <T extends Annotation> T getMethodAnnotation(Class<T> clazz) {
        return (T)((Annotation)AnnotationUtils.findAnnotation((Optional)this.extensionContext.getTestMethod(), clazz).orElse(null));
    }

    public <T extends Annotation> T getClassAnnotation(Class<T> clazz) {
        return this.getClassAnnotation(this.extensionContext.getTestClass(), clazz);
    }

    private <T extends Annotation> T getClassAnnotation(Optional<Class<?>> testClass, Class<T> clazz) {
        return (T)AnnotationUtils.findAnnotation(testClass, clazz).orElseGet(() -> AnnotationUtils.findAnnotation(testClass.filter(Class::isMemberClass), Nested.class).map(nested -> this.getClassAnnotation(testClass.map(Class::getEnclosingClass), clazz)).orElse(null));
    }

    public void commit() throws SQLException {
        if (EntityManagerProvider.isEntityManagerActive() && EntityManagerProvider.em().getTransaction().isActive()) {
            EntityManagerProvider.em().getTransaction().commit();
        } else {
            Connection connection = this.executor.getRiderDataSource().getConnection();
            connection.commit();
            connection.setAutoCommit(false);
        }
    }

    public void beginTransaction() throws SQLException {
        if (EntityManagerProvider.isEntityManagerActive()) {
            EntityManagerProvider.em().getTransaction().begin();
        } else {
            Connection connection = this.executor.getRiderDataSource().getConnection();
            connection.setAutoCommit(false);
        }
    }

    public void rollback() throws SQLException {
        if (EntityManagerProvider.isEntityManagerActive() && EntityManagerProvider.em().getTransaction().isActive()) {
            EntityManagerProvider.em().getTransaction().rollback();
        } else {
            Connection connection = this.executor.getRiderDataSource().getConnection();
            connection.rollback();
        }
    }

    public void clearEntityManager() {
        if (EntityManagerProvider.isEntityManagerActive()) {
            EntityManagerProvider.em().clear();
        }
    }
}

