/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.junit5.jdbc;

import com.github.database.rider.core.api.connection.ConnectionHolder;
import com.github.database.rider.core.api.dataset.DataSetExecutor;
import com.github.database.rider.core.connection.ConnectionHolderImpl;
import com.github.database.rider.core.dataset.DataSetExecutorImpl;
import com.github.database.rider.junit5.api.DBRider;
import com.github.database.rider.junit5.integration.Micronaut;
import com.github.database.rider.junit5.integration.Spring;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Optional;
import javax.sql.DataSource;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public final class ConnectionManager {
    public static ConnectionHolder getTestConnection(ExtensionContext extensionContext, String executorId) {
        if (Spring.isEnabled(extensionContext)) {
            return Spring.getConnectionFromSpringContext(extensionContext, executorId);
        }
        if (Micronaut.isEnabled(extensionContext)) {
            return Micronaut.getConnectionFromMicronautContext(extensionContext, executorId);
        }
        return ConnectionManager.getConnectionFromTestClass(extensionContext, executorId);
    }

    public static String getConfiguredDataSourceBeanName(ExtensionContext extensionContext) {
        Optional testMethod = extensionContext.getTestMethod();
        if (testMethod.isPresent()) {
            Optional annotation = AnnotationUtils.findAnnotation((AnnotatedElement)((AnnotatedElement)testMethod.get()), DBRider.class);
            if (!annotation.isPresent()) {
                annotation = AnnotationUtils.findAnnotation((AnnotatedElement)extensionContext.getRequiredTestClass(), DBRider.class);
            }
            return annotation.map(DBRider::dataSourceBeanName).orElse("");
        }
        return "";
    }

    public static ConnectionHolder getConnectionHolder(String executorId, DataSource dataSource) {
        try {
            DataSetExecutorImpl dataSetExecutor = DataSetExecutorImpl.getExecutorById((String)executorId);
            if (ConnectionManager.isCachedConnection((DataSetExecutor)dataSetExecutor)) {
                return new ConnectionHolderImpl(dataSetExecutor.getRiderDataSource().getDBUnitConnection().getConnection());
            }
            return new ConnectionHolderImpl(dataSource.getConnection());
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not get connection from DataSource.");
        }
    }

    private static ConnectionHolder getConnectionFromTestClass(ExtensionContext extensionContext, String executorId) {
        DataSetExecutorImpl dataSetExecutor = DataSetExecutorImpl.getExecutorById((String)executorId);
        if (ConnectionManager.isCachedConnection((DataSetExecutor)dataSetExecutor)) {
            try {
                return new ConnectionHolderImpl(dataSetExecutor.getRiderDataSource().getDBUnitConnection().getConnection());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        Class testClass = extensionContext.getRequiredTestClass();
        ConnectionHolder conn = ConnectionManager.findConnectionFromTestClass(extensionContext, testClass);
        return conn;
    }

    private static ConnectionHolder findConnectionFromTestClass(ExtensionContext extensionContext, Class<?> testClass) {
        try {
            Optional<Field> fieldFound = Arrays.stream(testClass.getDeclaredFields()).filter(f -> f.getType() == ConnectionHolder.class).findFirst();
            if (fieldFound.isPresent()) {
                Object testInstance;
                ConnectionHolder connectionHolder;
                Field field = fieldFound.get();
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                if ((connectionHolder = (ConnectionHolder)field.get(testInstance = Modifier.isStatic(field.getModifiers()) ? null : extensionContext.getRequiredTestInstance())) == null) {
                    throw new RuntimeException("ConnectionHolder not initialized correctly");
                }
                return connectionHolder;
            }
            Optional<Method> methodFound = Arrays.stream(testClass.getDeclaredMethods()).filter(m -> m.getReturnType() == ConnectionHolder.class).findFirst();
            if (methodFound.isPresent()) {
                ConnectionHolder connectionHolder;
                Method method = methodFound.get();
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                if ((connectionHolder = (ConnectionHolder)method.invoke(extensionContext.getRequiredTestInstance(), new Object[0])) == null) {
                    throw new RuntimeException("ConnectionHolder not initialized correctly");
                }
                return connectionHolder;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get database connection for test " + testClass, e);
        }
        if (testClass.getSuperclass() != null) {
            return ConnectionManager.findConnectionFromTestClass(extensionContext, testClass.getSuperclass());
        }
        return null;
    }

    private static boolean isCachedConnection(DataSetExecutor executor) {
        return executor != null && executor.getDBUnitConfig().isCacheConnection() != false;
    }
}

