/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.junit5.integration;

import com.github.database.rider.core.api.connection.ConnectionHolder;
import com.github.database.rider.core.util.ClassUtils;
import com.github.database.rider.junit5.jdbc.ConnectionManager;
import javax.sql.DataSource;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.junit.jupiter.SpringExtension;

public class Spring {
    public static boolean isEnabled(ExtensionContext extensionContext) {
        if (!extensionContext.getTestClass().isPresent()) {
            return false;
        }
        if (!Spring.isSpringExtensionEnabled(extensionContext)) {
            return false;
        }
        ExtensionContext.Store springStore = extensionContext.getRoot().getStore(ExtensionContext.Namespace.create((Object[])new Object[]{SpringExtension.class}));
        return springStore != null && springStore.get(extensionContext.getTestClass().get()) != null;
    }

    public static ConnectionHolder getConnectionFromSpringContext(ExtensionContext extensionContext, String executorId) {
        String configuredDataSourceBeanName = ConnectionManager.getConfiguredDataSourceBeanName(extensionContext);
        DataSource dataSource = Spring.getDataSourceFromSpringContext(extensionContext, configuredDataSourceBeanName);
        return ConnectionManager.getConnectionHolder(executorId, dataSource);
    }

    private static DataSource getDataSourceFromSpringContext(ExtensionContext extensionContext, String beanName) {
        ApplicationContext context = SpringExtension.getApplicationContext((ExtensionContext)extensionContext);
        return beanName.isEmpty() ? (DataSource)context.getBean(DataSource.class) : (DataSource)context.getBean(beanName, DataSource.class);
    }

    private static boolean isSpringExtensionEnabled(ExtensionContext extensionContext) {
        try {
            return ClassUtils.isOnClasspath((String)"org.springframework.test.context.junit.jupiter.SpringExtension") && extensionContext.getRoot().getStore(ExtensionContext.Namespace.create((Object[])new Object[]{SpringExtension.class})) != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

