/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.junit5.util;

import com.github.database.rider.core.util.ClassUtils;
import com.github.database.rider.junit5.util.PropertyResolutionUtil;
import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import org.hibernate.Session;
import org.hibernate.internal.SessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManagerProvider {
    private static Map<String, EntityManagerProvider> providers = new ConcurrentHashMap<String, EntityManagerProvider>();
    private EntityManagerFactory emf;
    private EntityManager em;
    private EntityTransaction tx;
    private Connection conn;
    private static PropertyResolutionUtil propertyResolutionUtil = new PropertyResolutionUtil();
    private static Map<String, String> overridingProperties;
    private static EntityManagerProvider instance;
    private static Logger log;

    private EntityManagerProvider() {
    }

    public static synchronized EntityManagerProvider instance(String unitName) {
        instance = providers.get(unitName);
        if (instance == null) {
            instance = new EntityManagerProvider();
            providers.put(unitName, instance);
        }
        try {
            instance.init(unitName);
        }
        catch (Exception e) {
            log.error("Could not initialize persistence unit " + unitName, (Throwable)e);
        }
        return instance;
    }

    public static synchronized EntityManagerProvider instance(String unitName, Map<String, String> overridingPersistenceProps) {
        overridingProperties = overridingPersistenceProps;
        return EntityManagerProvider.instance(unitName);
    }

    public static synchronized EntityManagerProvider newInstance(String unitName) {
        instance = new EntityManagerProvider();
        providers.put(unitName, instance);
        try {
            instance.init(unitName);
        }
        catch (Exception e) {
            log.error("Could not initialize persistence unit " + unitName, (Throwable)e);
        }
        return instance;
    }

    private void init(String unitName) {
        if (this.emf == null) {
            log.debug("creating emf for unit {}", (Object)unitName);
            Map<String, String> dbConfig = this.getDbPropertyConfig();
            log.debug("using dbConfig '{}' to create emf", dbConfig);
            this.emf = dbConfig == null ? Persistence.createEntityManagerFactory((String)unitName) : Persistence.createEntityManagerFactory((String)unitName, dbConfig);
            this.em = this.emf.createEntityManager();
            this.tx = this.em.getTransaction();
            if (this.isHibernateOnClasspath() && this.em.getDelegate() instanceof Session) {
                this.conn = ((SessionImpl)this.em.unwrap(Session.class)).connection();
            } else {
                this.tx.begin();
                this.conn = (Connection)this.em.unwrap(Connection.class);
                this.tx.commit();
            }
        }
        this.emf.getCache().evictAll();
    }

    private Map<String, String> getDbPropertyConfig() {
        if (overridingProperties == null) {
            return propertyResolutionUtil.getSystemJavaxPersistenceOverrides();
        }
        return propertyResolutionUtil.persistencePropertiesOverrides(overridingProperties);
    }

    public Connection connection(String puName) {
        return EntityManagerProvider.instance((String)puName).conn;
    }

    public Connection connection() {
        EntityManagerProvider.checkInstance();
        return EntityManagerProvider.instance.conn;
    }

    public static EntityManager em(String puName) {
        return EntityManagerProvider.instance((String)puName).em;
    }

    public static EntityManagerFactory emf(String puName) {
        return EntityManagerProvider.instance((String)puName).emf;
    }

    public static EntityManager em() {
        EntityManagerProvider.checkInstance();
        return EntityManagerProvider.instance.em;
    }

    public EntityManager getEm() {
        return EntityManagerProvider.em();
    }

    public static EntityManagerFactory emf() {
        return EntityManagerProvider.instance.emf;
    }

    public EntityManagerFactory getEmf() {
        return EntityManagerProvider.instance.emf;
    }

    public EntityManager getEm(String puName) {
        return EntityManagerProvider.em(puName);
    }

    public static EntityManagerProvider clear(String puName) {
        EntityManagerProvider.em(puName).clear();
        EntityManagerProvider.emf(puName).getCache().evictAll();
        return providers.get(puName);
    }

    public static EntityManagerProvider clear() {
        EntityManagerProvider.em().clear();
        EntityManagerProvider.emf().getCache().evictAll();
        return instance;
    }

    public static EntityTransaction tx(String puName) {
        return EntityManagerProvider.em(puName).getTransaction();
    }

    public static EntityTransaction tx() {
        EntityManagerProvider.checkInstance();
        return EntityManagerProvider.instance.tx;
    }

    private boolean isHibernateOnClasspath() {
        return ClassUtils.isOnClasspath((String)"org.hibernate.Session");
    }

    private static void checkInstance() {
        if (instance == null) {
            throw new IllegalStateException("Call instance('PU_NAME') before calling em()");
        }
    }

    public static boolean isEntityManagerActive() {
        return instance != null && EntityManagerProvider.em().isOpen();
    }

    static {
        log = LoggerFactory.getLogger(EntityManagerProvider.class);
    }
}

