/*
 * Decompiled with CFR 0.152.
 */
package com.github.database.rider.spring;

import com.github.database.rider.core.AbstractRiderTestContext;
import com.github.database.rider.core.api.dataset.DataSetExecutor;
import com.github.database.rider.core.dataset.DataSetExecutorImpl;
import java.lang.annotation.Annotation;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.test.context.TestContext;

class SpringRiderTestContext
extends AbstractRiderTestContext {
    private final TestContext testContext;

    static SpringRiderTestContext create(TestContext testContext) {
        return new SpringRiderTestContext(SpringRiderTestContext.createDataSetExecutor(testContext), testContext);
    }

    private static DataSetExecutor createDataSetExecutor(TestContext testContext) {
        DataSource dataSource = SpringRiderTestContext.wrapInTransactionAwareProxy((DataSource)testContext.getApplicationContext().getBean(DataSource.class));
        DataSetExecutorImpl dataSetExecutor = DataSetExecutorImpl.instance(dataSource::getConnection);
        dataSetExecutor.clearRiderDataSource();
        return dataSetExecutor;
    }

    private static DataSource wrapInTransactionAwareProxy(DataSource dataSource) {
        if (dataSource instanceof TransactionAwareDataSourceProxy) {
            return dataSource;
        }
        return new TransactionAwareDataSourceProxy(dataSource);
    }

    private SpringRiderTestContext(DataSetExecutor executor, TestContext testContext) {
        super(executor);
        this.testContext = testContext;
    }

    public String getMethodName() {
        return this.testContext.getTestMethod().getName();
    }

    public <T extends Annotation> T getMethodAnnotation(Class<T> clazz) {
        return this.testContext.getTestMethod().getAnnotation(clazz);
    }

    public <T extends Annotation> T getClassAnnotation(Class<T> clazz) {
        return this.testContext.getTestClass().getAnnotation(clazz);
    }
}

