/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Core.Address;

import HslCommunication.Core.Address.DeviceAddressDataBase;
import HslCommunication.Core.Types.HslHelper;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.Profinet.Omron.OmronFinsDataType;
import HslCommunication.StringResources;

public class OmronFinsAddress
extends DeviceAddressDataBase {
    private byte BitCode = 0;
    private byte WordCode = 0;

    public byte getBitCode() {
        return this.BitCode;
    }

    public void setBitCode(byte bitCode) {
        this.BitCode = bitCode;
    }

    public byte getWordCode() {
        return this.WordCode;
    }

    public void setWordCode(byte wordCode) {
        this.WordCode = wordCode;
    }

    @Override
    public void Parse(String address, int length) {
        OperateResultExOne<OmronFinsAddress> addressData = OmronFinsAddress.ParseFrom(address, (short)length);
        if (addressData.IsSuccess) {
            this.setAddressStart(((OmronFinsAddress)addressData.Content).getAddressStart());
            this.setLength(((OmronFinsAddress)addressData.Content).getLength());
            this.setBitCode(((OmronFinsAddress)addressData.Content).getBitCode());
            this.setWordCode(((OmronFinsAddress)addressData.Content).getWordCode());
        }
    }

    public static OperateResultExOne<OmronFinsAddress> ParseFrom(String address) {
        return OmronFinsAddress.ParseFrom(address, (short)0);
    }

    public static OperateResultExOne<OmronFinsAddress> ParseFrom(String address, short length) {
        OmronFinsAddress addressData = new OmronFinsAddress();
        try {
            int addr;
            String[] splits;
            addressData.setLength(length);
            switch (address.charAt(0)) {
                case 'D': 
                case 'd': {
                    addressData.BitCode = OmronFinsDataType.DM.getBitCode();
                    addressData.WordCode = OmronFinsDataType.DM.getWordCode();
                    break;
                }
                case 'C': 
                case 'c': {
                    addressData.BitCode = OmronFinsDataType.CIO.getBitCode();
                    addressData.WordCode = OmronFinsDataType.CIO.getWordCode();
                    break;
                }
                case 'W': 
                case 'w': {
                    addressData.BitCode = OmronFinsDataType.WR.getBitCode();
                    addressData.WordCode = OmronFinsDataType.WR.getWordCode();
                    break;
                }
                case 'H': 
                case 'h': {
                    addressData.BitCode = OmronFinsDataType.HR.getBitCode();
                    addressData.WordCode = OmronFinsDataType.HR.getWordCode();
                    break;
                }
                case 'A': 
                case 'a': {
                    addressData.BitCode = OmronFinsDataType.AR.getBitCode();
                    addressData.WordCode = OmronFinsDataType.AR.getWordCode();
                    break;
                }
                case 'E': 
                case 'e': {
                    splits = address.split("\\.");
                    int block = Integer.parseInt(splits[0].substring(1), 16);
                    if (block < 16) {
                        addressData.BitCode = (byte)(32 + block);
                        addressData.WordCode = (byte)(160 + block);
                        break;
                    }
                    addressData.BitCode = (byte)(224 + block - 16);
                    addressData.WordCode = (byte)(96 + block - 16);
                    break;
                }
                default: {
                    throw new Exception(StringResources.Language.NotSupportedDataType());
                }
            }
            if (address.charAt(0) == 'E' || address.charAt(0) == 'e') {
                splits = address.split("\\.");
                addr = Integer.parseInt(splits[1]) * 16;
                if (splits.length > 2) {
                    addr += HslHelper.CalculateBitStartIndex(splits[2]);
                }
                addressData.setAddressStart(addr);
            } else {
                splits = address.substring(1).split("\\.");
                addr = Integer.parseInt(splits[0]) * 16;
                if (splits.length > 1) {
                    addr += HslHelper.CalculateBitStartIndex(splits[1]);
                }
                addressData.setAddressStart(addr);
            }
        }
        catch (Exception ex) {
            return new OperateResultExOne<OmronFinsAddress>(ex.getMessage());
        }
        return OperateResultExOne.CreateSuccessResult(addressData);
    }
}

