/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Core.Address;

import HslCommunication.Core.Address.DeviceAddressDataBase;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.StringResources;

public class S7AddressData
extends DeviceAddressDataBase {
    private int DataCode = 0;
    private int DbBlock = 0;

    public int getDataCode() {
        return this.DataCode;
    }

    public void setDataCode(int dataCode) {
        this.DataCode = dataCode;
    }

    public int getDbBlock() {
        return this.DbBlock;
    }

    public void setDbBlock(int dbBlock) {
        this.DbBlock = dbBlock;
    }

    @Override
    public void Parse(String address, int length) {
        OperateResultExOne<S7AddressData> addressData = S7AddressData.ParseFrom(address, length);
        if (addressData.IsSuccess) {
            this.setAddressStart(((S7AddressData)addressData.Content).getAddressStart());
            this.setLength(((S7AddressData)addressData.Content).getLength());
            this.DataCode = ((S7AddressData)addressData.Content).getDataCode();
            this.DbBlock = ((S7AddressData)addressData.Content).getDbBlock();
        }
    }

    public static int CalculateAddressStarted(String address, boolean isCT) {
        if (address.indexOf(46) < 0) {
            if (isCT) {
                return Integer.parseInt(address);
            }
            return Integer.parseInt(address) * 8;
        }
        String[] temp = address.split("\\.");
        return Integer.parseInt(temp[0]) * 8 + Integer.parseInt(temp[1]);
    }

    public static OperateResultExOne<S7AddressData> ParseFrom(String address) {
        return S7AddressData.ParseFrom(address, 0);
    }

    public static OperateResultExOne<S7AddressData> ParseFrom(String address, int length) {
        S7AddressData addressData;
        block14: {
            addressData = new S7AddressData();
            try {
                addressData.setLength(length);
                addressData.DbBlock = 0;
                if (address.startsWith("AI") || address.startsWith("ai")) {
                    addressData.DataCode = 6;
                    addressData.setAddressStart(S7AddressData.CalculateAddressStarted(address.substring(2), false));
                    break block14;
                }
                if (address.startsWith("AQ") || address.startsWith("aq")) {
                    addressData.DataCode = 7;
                    addressData.setAddressStart(S7AddressData.CalculateAddressStarted(address.substring(2), false));
                    break block14;
                }
                if (address.charAt(0) == 'I') {
                    addressData.DataCode = 129;
                    addressData.setAddressStart(S7AddressData.CalculateAddressStarted(address.substring(1), false));
                    break block14;
                }
                if (address.charAt(0) == 'Q') {
                    addressData.DataCode = 130;
                    addressData.setAddressStart(S7AddressData.CalculateAddressStarted(address.substring(1), false));
                    break block14;
                }
                if (address.charAt(0) == 'M') {
                    addressData.DataCode = 131;
                    addressData.setAddressStart(S7AddressData.CalculateAddressStarted(address.substring(1), false));
                    break block14;
                }
                if (address.charAt(0) == 'D' || address.substring(0, 2).equals("DB")) {
                    addressData.DataCode = 132;
                    String[] adds = address.split("\\.");
                    addressData.DbBlock = address.charAt(1) == 'B' ? Integer.parseInt(adds[0].substring(2)) : Integer.parseInt(adds[0].substring(1));
                    String addTemp = address.substring(address.indexOf(46) + 1);
                    if (addTemp.startsWith("DBX") || addTemp.startsWith("DBB") || addTemp.startsWith("DBW") || addTemp.startsWith("DBD")) {
                        addTemp = addTemp.substring(3);
                    }
                    addressData.setAddressStart(S7AddressData.CalculateAddressStarted(addTemp, false));
                    break block14;
                }
                if (address.charAt(0) == 'T') {
                    addressData.DataCode = 31;
                    addressData.setAddressStart(S7AddressData.CalculateAddressStarted(address.substring(1), true));
                    break block14;
                }
                if (address.charAt(0) == 'C') {
                    addressData.DataCode = 30;
                    addressData.setAddressStart(S7AddressData.CalculateAddressStarted(address.substring(1), true));
                    break block14;
                }
                if (address.charAt(0) == 'V') {
                    addressData.DataCode = 132;
                    addressData.DbBlock = 1;
                    if (address.startsWith("VB") || address.startsWith("VW") || address.startsWith("VD") || address.startsWith("VX")) {
                        addressData.setAddressStart(S7AddressData.CalculateAddressStarted(address.substring(2), false));
                    } else {
                        addressData.setAddressStart(S7AddressData.CalculateAddressStarted(address.substring(1), false));
                    }
                    break block14;
                }
                return new OperateResultExOne<S7AddressData>(StringResources.Language.NotSupportedDataType());
            }
            catch (Exception ex) {
                return new OperateResultExOne<S7AddressData>(ex.getMessage());
            }
        }
        return OperateResultExOne.CreateSuccessResult(addressData);
    }
}

