/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Profinet.Melsec;

import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.Core.Address.McAddressData;
import HslCommunication.Core.IMessage.INetMessage;
import HslCommunication.Core.IMessage.MelsecQnA3EBinaryMessage;
import HslCommunication.Core.Net.NetworkBase.NetworkDeviceBase;
import HslCommunication.Core.Transfer.RegularByteTransform;
import HslCommunication.Core.Types.OperateResult;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.Profinet.Melsec.Helper.IReadWriteMc;
import HslCommunication.Profinet.Melsec.Helper.McBinaryHelper;
import HslCommunication.Profinet.Melsec.Helper.McHelper;
import HslCommunication.Profinet.Melsec.Helper.McType;

public class MelsecMcNet
extends NetworkDeviceBase
implements IReadWriteMc {
    private byte NetworkNumber = 0;
    private byte NetworkStationNumber = 0;

    public MelsecMcNet() {
        this.WordLength = 1;
        this.setByteTransform(new RegularByteTransform());
    }

    public MelsecMcNet(String ipAddress, int port) {
        this.WordLength = 1;
        super.setIpAddress(ipAddress);
        super.setPort(port);
        this.setByteTransform(new RegularByteTransform());
    }

    @Override
    protected INetMessage GetNewNetMessage() {
        return new MelsecQnA3EBinaryMessage();
    }

    @Override
    public byte getNetworkNumber() {
        return this.NetworkNumber;
    }

    @Override
    public void setNetworkNumber(byte networkNumber) {
        this.NetworkNumber = networkNumber;
    }

    @Override
    public byte getNetworkStationNumber() {
        return this.NetworkStationNumber;
    }

    @Override
    public void setNetworkStationNumber(byte networkStationNumber) {
        this.NetworkStationNumber = networkStationNumber;
    }

    @Override
    public McType getMcType() {
        return McType.McBinary;
    }

    @Override
    public OperateResultExOne<McAddressData> McAnalysisAddress(String address, short length) {
        return McAddressData.ParseMelsecFrom(address, length);
    }

    @Override
    protected byte[] PackCommandWithHeader(byte[] command) {
        return McBinaryHelper.PackMcCommand(command, this.NetworkNumber, this.NetworkStationNumber);
    }

    @Override
    protected OperateResultExOne<byte[]> UnpackResponseContent(byte[] send, byte[] response) {
        OperateResult check = McBinaryHelper.CheckResponseContentHelper(response);
        if (!check.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(check);
        }
        return OperateResultExOne.CreateSuccessResult(SoftBasic.BytesArrayRemoveBegin(response, 11));
    }

    @Override
    public byte[] ExtractActualData(byte[] response, boolean isBit) {
        return McBinaryHelper.ExtractActualDataHelper(response, isBit);
    }

    @Override
    public OperateResultExOne<byte[]> Read(String address, short length) {
        return McHelper.Read(this, address, length);
    }

    @Override
    public OperateResultExOne<boolean[]> ReadBool(String address, short length) {
        return McHelper.ReadBool(this, address, length);
    }

    @Override
    public OperateResult Write(String address, byte[] value) {
        return McHelper.Write((IReadWriteMc)this, address, value);
    }

    @Override
    public OperateResult Write(String address, boolean[] values) {
        return McHelper.Write((IReadWriteMc)this, address, values);
    }

    public OperateResultExOne<byte[]> ReadRandom(String[] address) {
        return McHelper.ReadRandom(this, address);
    }

    public OperateResultExOne<byte[]> ReadRandom(String[] address, short[] length) {
        return McHelper.ReadRandom(this, address, length);
    }

    public OperateResultExOne<short[]> ReadRandomInt16(String[] address) {
        return McHelper.ReadRandomInt16(this, address);
    }

    public OperateResultExOne<byte[]> ReadTags(String tag, short length) {
        return this.ReadTags(new String[]{tag}, new short[]{length});
    }

    public OperateResultExOne<byte[]> ReadTags(String[] tags, short[] length) {
        return McBinaryHelper.ReadTags(this, tags, length);
    }

    public OperateResultExOne<byte[]> ReadExtend(short extend, String address, short length) {
        return McHelper.ReadExtend(this, extend, address, length);
    }

    public OperateResultExOne<byte[]> ReadMemory(String address, short length) {
        return McHelper.ReadMemory(this, address, length);
    }

    public OperateResult RemoteRun() {
        return McHelper.RemoteRun(this);
    }

    public OperateResult RemoteStop() {
        return McHelper.RemoteStop(this);
    }

    public OperateResult RemoteReset() {
        return McHelper.RemoteReset(this);
    }

    public OperateResultExOne<String> ReadPlcType() {
        return McHelper.ReadPlcType(this);
    }

    public OperateResult ErrorStateReset() {
        return McHelper.ErrorStateReset(this);
    }

    @Override
    public String toString() {
        return "MelsecMcNet[" + this.getIpAddress() + ":" + this.getPort() + "]";
    }
}

