package HslCommunication.CNC.Fanuc;

import HslCommunication.Core.Transfer.IByteTransform;

import java.nio.charset.Charset;

public class FanucOperatorMessage {
    /**
     * Number of operator's message
     */
    public short Number;

    /**
     * Kind of operator's message
     */
    public short Type;

    /**
     * Operator's message strings
     */
    public String Data;

    /**
     * 创建一个fanuc的操作消息对象
     * @param byteTransform 数据变换对象
     * @param buffer 读取的数据缓存信息
     * @param encoding 解析的编码信息
     * @return fanuc设备的操作信息
     */
    public static FanucOperatorMessage CreateMessage(IByteTransform byteTransform, byte[] buffer, Charset encoding) {
        FanucOperatorMessage fanucOperator = new FanucOperatorMessage();
        fanucOperator.Number = byteTransform.TransInt16(buffer, 2);
        fanucOperator.Type = byteTransform.TransInt16(buffer, 6);
        short len = byteTransform.TransInt16(buffer, 10);
        if (len + 12 <= buffer.length)
            fanucOperator.Data = new String(buffer, 12, len, encoding);
        else
            fanucOperator.Data = new String(buffer, 12, buffer.length - 12, encoding).trim();
        return fanucOperator;
    }
}
