package HslCommunication.Core.Types;

public class Convert {

    /**
     * 将原始字节数据转为base64编码的字符串
     * @param value 原始字节
     * @return base64编码的字符串
     */
    public static String ToBase64String(byte[] value) {
        return java.util.Base64.getEncoder().encodeToString(value);
    }

    /**
     * 将base64编码的字符串转为原始字节数据
     * @param value base64编码的字符串
     * @return 原始字节数据
     */
    public static byte[] FromBase64String(String value) {
        return java.util.Base64.getDecoder().decode(value);
    }

    public static int ToInt32( String value ){
        return Integer.parseInt(value);
    }


    public static int ToInt32( String value, int fromBase ){
        return Integer.parseInt(value, fromBase);
    }
}
