/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Core.Types;

import HslCommunication.Authorization;
import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.Core.Transfer.DataFormat;
import HslCommunication.Core.Transfer.IByteTransform;
import HslCommunication.Core.Types.OperateResultExThree;
import HslCommunication.Core.Types.OperateResultExTwo;
import HslCommunication.StringResources;
import HslCommunication.Utilities;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HslHelper {
    public static OperateResultExTwo<Integer, String> ExtractParameter(String address, String paraName, int defaultValue) {
        OperateResultExTwo<Integer, String> extra = HslHelper.ExtractParameter(address, paraName);
        return extra.IsSuccess ? extra : OperateResultExTwo.CreateSuccessResult(defaultValue, address);
    }

    public static OperateResultExTwo<Integer, String> ExtractParameter(String address, String paraName) {
        try {
            Pattern r = Pattern.compile(paraName + "=[0-9A-Fa-fx]+;");
            Matcher match = r.matcher(address);
            if (!match.find()) {
                return new OperateResultExTwo<Integer, String>("Address [" + address + "] can't find [" + paraName + "] Parameters. for example : " + paraName + "=1;100");
            }
            String number = match.group().substring(paraName.length() + 1, match.group().length() - paraName.length() - 2);
            int value = number.startsWith("0x") ? Integer.parseInt(number.substring(2), 16) : (number.startsWith("0") ? Integer.parseInt(number, 8) : Integer.parseInt(number));
            address = address.replace(match.group(), "");
            return OperateResultExTwo.CreateSuccessResult(value, address);
        }
        catch (Exception ex) {
            return new OperateResultExTwo<Integer, String>("Address [" + address + "] Get [" + paraName + "] Parameters failed: " + ex.getMessage());
        }
    }

    public static OperateResultExTwo<Integer, String> ExtractStartIndex(String address) {
        try {
            Pattern r = Pattern.compile("\\[[0-9]+\\]$");
            Matcher match = r.matcher(address);
            if (!match.find()) {
                return OperateResultExTwo.CreateSuccessResult(-1, address);
            }
            String number = match.group().substring(1, match.group().length() - 2);
            int value = Integer.parseInt(number);
            address = address.substring(match.group().length());
            return OperateResultExTwo.CreateSuccessResult(value, address);
        }
        catch (Exception ex) {
            return OperateResultExTwo.CreateSuccessResult(-1, address);
        }
    }

    public static OperateResultExTwo<IByteTransform, String> ExtractTransformParameter(String address, IByteTransform defaultTransform) {
        if (!Authorization.asdniasnfaksndiqwhawfskhfaiw()) {
            return OperateResultExTwo.CreateSuccessResult(defaultTransform, address);
        }
        String paraName = "format";
        Pattern r = Pattern.compile(paraName + "=(ABCD|BADC|DCBA|CDAB);", 2);
        Matcher match = r.matcher(address);
        if (!match.find()) {
            return OperateResultExTwo.CreateSuccessResult(defaultTransform, address);
        }
        String format = match.group(0).substring(paraName.length() + 1, match.group(0).length() - paraName.length() - 2);
        DataFormat dataFormat = defaultTransform.getDataFormat();
        switch (format.toUpperCase()) {
            case "ABCD": {
                dataFormat = DataFormat.ABCD;
                break;
            }
            case "BADC": {
                dataFormat = DataFormat.BADC;
                break;
            }
            case "DCBA": {
                dataFormat = DataFormat.DCBA;
                break;
            }
            case "CDAB": {
                dataFormat = DataFormat.CDAB;
                break;
            }
        }
        address = address.replace(match.group(0), "");
        if (dataFormat != defaultTransform.getDataFormat()) {
            return OperateResultExTwo.CreateSuccessResult(defaultTransform.CreateByDateFormat(dataFormat), address);
        }
        return OperateResultExTwo.CreateSuccessResult(defaultTransform, address);
    }

    public static OperateResultExTwo<int[], int[]> SplitReadLength(int address, short length, short segment) {
        int[] segments = SoftBasic.SplitIntegerToArray(length, segment);
        int[] addresses = new int[segments.length];
        for (int i = 0; i < addresses.length; ++i) {
            addresses[i] = i == 0 ? address : addresses[i - 1] + segments[i - 1];
        }
        return OperateResultExTwo.CreateSuccessResult(addresses, segments);
    }

    public static <T> OperateResultExTwo<int[], ArrayList<T[]>> SplitWriteData(Class<T> tClass, int address, T[] value, short segment, int addressLength) {
        ArrayList<T[]> segments = SoftBasic.ArraySplitByLength(tClass, value, segment * addressLength);
        int[] addresses = new int[segments.size()];
        for (int i = 0; i < addresses.length; ++i) {
            addresses[i] = i == 0 ? address : addresses[i - 1] + segments.get(i - 1).length / addressLength;
        }
        return OperateResultExTwo.CreateSuccessResult(addresses, segments);
    }

    public static OperateResultExTwo<Integer, String> GetBitIndexInformation(String address) {
        int bitIndex = 0;
        int lastIndex = address.lastIndexOf(46);
        if (lastIndex > 0 && lastIndex < address.length() - 1) {
            String bit = address.substring(lastIndex + 1);
            bitIndex = bit.contains("A") || bit.contains("B") || bit.contains("C") || bit.contains("D") || bit.contains("E") || bit.contains("F") ? Integer.parseInt(bit, 16) : Integer.parseInt(bit);
            address = address.substring(0, lastIndex);
        }
        return OperateResultExTwo.CreateSuccessResult(bitIndex, address);
    }

    public static byte[] GetUTF8Bytes(String message) {
        return Utilities.IsStringNullOrEmpty(message) ? new byte[]{} : message.getBytes(StandardCharsets.UTF_8);
    }

    public static OperateResultExThree<Integer, Short, Integer> CalculateStartBitIndexAndLength(int addressStart, short length) {
        OperateResultExThree<Integer, Short, Integer> result = new OperateResultExThree<Integer, Short, Integer>();
        result.IsSuccess = true;
        result.Message = StringResources.Language.SuccessText();
        short byteLength = (short)((addressStart + length - 1) / 8 - addressStart / 8 + 1);
        int offset = addressStart % 8;
        int newStart = addressStart - offset;
        result.Content1 = newStart;
        result.Content2 = byteLength;
        result.Content3 = offset;
        return result;
    }

    public static int CalculateBitStartIndex(String bit) {
        if (bit.contains("A") || bit.contains("B") || bit.contains("C") || bit.contains("D") || bit.contains("E") || bit.contains("F")) {
            return Integer.parseInt(bit, 16);
        }
        return Integer.parseInt(bit);
    }

    public static int CalculateOccupyLength(int address, int length) {
        return HslHelper.CalculateOccupyLength(address, length, 8);
    }

    public static int CalculateOccupyLength(int address, int length, int hex) {
        return (address + length - 1) / hex - address / hex + 1;
    }
}

