/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Profinet.Omron;

import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.Core.Address.OmronFinsAddress;
import HslCommunication.Core.Net.IReadWriteDevice;
import HslCommunication.Core.Types.OperateResult;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.StringResources;
import HslCommunication.Utilities;
import java.util.ArrayList;

public class OmronFinsNetHelper {
    public static OperateResultExOne<ArrayList<byte[]>> BuildReadCommand(String[] address) {
        ArrayList<byte[]> cmds = new ArrayList<byte[]>();
        ArrayList<String[]> splits = SoftBasic.ArraySplitByLength(address, 89);
        for (int i = 0; i < splits.size(); ++i) {
            String[] adds = splits.get(i);
            byte[] _PLCCommand = new byte[2 + 4 * adds.length];
            _PLCCommand[0] = 1;
            _PLCCommand[1] = 4;
            for (int j = 0; j < adds.length; ++j) {
                OperateResultExOne<OmronFinsAddress> analysis = OmronFinsAddress.ParseFrom(adds[j], (short)1);
                if (!analysis.IsSuccess) {
                    return OperateResultExOne.CreateFailedResult(analysis);
                }
                _PLCCommand[2 + 4 * j] = ((OmronFinsAddress)analysis.Content).getWordCode();
                _PLCCommand[3 + 4 * j] = (byte)(((OmronFinsAddress)analysis.Content).getAddressStart() / 16 / 256);
                _PLCCommand[4 + 4 * j] = (byte)(((OmronFinsAddress)analysis.Content).getAddressStart() / 16 % 256);
                _PLCCommand[5 + 4 * j] = (byte)(((OmronFinsAddress)analysis.Content).getAddressStart() % 16);
            }
            cmds.add(_PLCCommand);
        }
        return OperateResultExOne.CreateSuccessResult(cmds);
    }

    public static OperateResultExOne<byte[][]> BuildReadCommand(String address, short length, boolean isBit, int splitLength) {
        OperateResultExOne<OmronFinsAddress> analysis = OmronFinsAddress.ParseFrom(address, length);
        if (!analysis.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(analysis);
        }
        ArrayList<byte[]> cmds = new ArrayList<byte[]>();
        int[] lengths = SoftBasic.SplitIntegerToArray(length, isBit ? Integer.MAX_VALUE : splitLength);
        for (int i = 0; i < lengths.length; ++i) {
            byte[] _PLCCommand = new byte[]{1, 1, isBit ? ((OmronFinsAddress)analysis.Content).getBitCode() : ((OmronFinsAddress)analysis.Content).getWordCode(), (byte)(((OmronFinsAddress)analysis.Content).getAddressStart() / 16 / 256), (byte)(((OmronFinsAddress)analysis.Content).getAddressStart() / 16 % 256), (byte)(((OmronFinsAddress)analysis.Content).getAddressStart() % 16), (byte)(lengths[i] / 256), (byte)(lengths[i] % 256)};
            cmds.add(_PLCCommand);
            ((OmronFinsAddress)analysis.Content).setAddressStart(((OmronFinsAddress)analysis.Content).getAddressStart() + (isBit ? lengths[i] : lengths[i] * 16));
        }
        return OperateResultExOne.CreateSuccessResult(Utilities.ToArray(cmds));
    }

    public static OperateResultExOne<byte[]> BuildWriteWordCommand(String address, byte[] value, boolean isBit) {
        OperateResultExOne<OmronFinsAddress> analysis = OmronFinsAddress.ParseFrom(address, (short)0);
        if (!analysis.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(analysis);
        }
        byte[] _PLCCommand = new byte[8 + value.length];
        _PLCCommand[0] = 1;
        _PLCCommand[1] = 2;
        _PLCCommand[2] = isBit ? ((OmronFinsAddress)analysis.Content).getBitCode() : ((OmronFinsAddress)analysis.Content).getWordCode();
        _PLCCommand[3] = (byte)(((OmronFinsAddress)analysis.Content).getAddressStart() / 16 / 256);
        _PLCCommand[4] = (byte)(((OmronFinsAddress)analysis.Content).getAddressStart() / 16 % 256);
        _PLCCommand[5] = (byte)(((OmronFinsAddress)analysis.Content).getAddressStart() % 16);
        if (isBit) {
            _PLCCommand[6] = (byte)(value.length / 256);
            _PLCCommand[7] = (byte)(value.length % 256);
        } else {
            _PLCCommand[6] = (byte)(value.length / 2 / 256);
            _PLCCommand[7] = (byte)(value.length / 2 % 256);
        }
        System.arraycopy(value, 0, _PLCCommand, 8, value.length);
        return OperateResultExOne.CreateSuccessResult(_PLCCommand);
    }

    public static OperateResultExOne<byte[]> ResponseValidAnalysis(byte[] response) {
        if (response.length >= 16) {
            byte[] buffer = new byte[]{response[15], response[14], response[13], response[12]};
            int err = Utilities.getInt(buffer, 0);
            if (err > 0) {
                return new OperateResultExOne<byte[]>(err, OmronFinsNetHelper.GetStatusDescription(err));
            }
            byte[] result = new byte[response.length - 16];
            System.arraycopy(response, 16, result, 0, result.length);
            return OmronFinsNetHelper.UdpResponseValidAnalysis(result);
        }
        return new OperateResultExOne<byte[]>(StringResources.Language.OmronReceiveDataError());
    }

    public static OperateResultExOne<byte[]> UdpResponseValidAnalysis(byte[] response) {
        if (response.length >= 14) {
            int err = (response[12] & 0xFF) * 256 + (response[13] & 0xFF);
            if (response[10] == 1 & response[11] == 1 || response[10] == 1 & response[11] == 4 || response[10] == 2 & response[11] == 1 || response[10] == 3 & response[11] == 6 || response[10] == 5 & response[11] == 1 || response[10] == 5 & response[11] == 2 || response[10] == 6 & response[11] == 1 || response[10] == 6 & response[11] == 32 || response[10] == 7 & response[11] == 1 || response[10] == 9 & response[11] == 32 || response[10] == 33 & response[11] == 2 || response[10] == 34 & response[11] == 2) {
                byte[] content = new byte[response.length - 14];
                if (content.length > 0) {
                    System.arraycopy(response, 14, content, 0, content.length);
                }
                OperateResultExOne<byte[]> success = OperateResultExOne.CreateSuccessResult(content);
                if (content.length == 0) {
                    success.IsSuccess = false;
                }
                success.ErrorCode = err;
                success.Message = OmronFinsNetHelper.GetStatusDescription(err) + " Received:" + SoftBasic.ByteToHexString(response, ' ');
                if (response[10] == 1 & response[11] == 4) {
                    byte[] buffer = content.length > 0 ? new byte[content.length * 2 / 3] : new byte[]{};
                    for (int i = 0; i < content.length / 3; ++i) {
                        buffer[i * 2 + 0] = content[i * 3 + 1];
                        buffer[i * 2 + 1] = content[i * 3 + 2];
                    }
                    success.Content = buffer;
                }
                return success;
            }
            OperateResultExOne<byte[]> success = OperateResultExOne.CreateSuccessResult(new byte[0]);
            success.ErrorCode = err;
            success.Message = OmronFinsNetHelper.GetStatusDescription(err) + " Received:" + SoftBasic.ByteToHexString(response, ' ');
            return success;
        }
        return new OperateResultExOne<byte[]>(StringResources.Language.OmronReceiveDataError());
    }

    public static String GetStatusDescription(int err) {
        switch (err) {
            case 0: {
                return StringResources.Language.OmronStatus0();
            }
            case 1: {
                return StringResources.Language.OmronStatus1();
            }
            case 2: {
                return StringResources.Language.OmronStatus2();
            }
            case 3: {
                return StringResources.Language.OmronStatus3();
            }
            case 20: {
                return StringResources.Language.OmronStatus20();
            }
            case 21: {
                return StringResources.Language.OmronStatus21();
            }
            case 22: {
                return StringResources.Language.OmronStatus22();
            }
            case 23: {
                return StringResources.Language.OmronStatus23();
            }
            case 24: {
                return StringResources.Language.OmronStatus24();
            }
            case 25: {
                return StringResources.Language.OmronStatus25();
            }
        }
        return StringResources.Language.UnknownError();
    }

    public static OperateResultExOne<byte[]> Read(IReadWriteDevice omron, String address, short length, int splits) {
        OperateResultExOne<byte[][]> command = OmronFinsNetHelper.BuildReadCommand(address, length, false, splits);
        if (!command.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(command);
        }
        ArrayList<Byte> contentArray = new ArrayList<Byte>();
        for (int i = 0; i < ((byte[][])command.Content).length; ++i) {
            OperateResultExOne<byte[]> read = omron.ReadFromCoreServer(((byte[][])command.Content)[i]);
            if (!read.IsSuccess) {
                return OperateResultExOne.CreateFailedResult(read);
            }
            Utilities.ArrayListAddArray(contentArray, (byte[])read.Content);
        }
        return OperateResultExOne.CreateSuccessResult(Utilities.ToByteArray(contentArray));
    }

    public static OperateResultExOne<byte[]> Read(IReadWriteDevice omron, String[] address) {
        OperateResultExOne<ArrayList<byte[]>> command = OmronFinsNetHelper.BuildReadCommand(address);
        if (!command.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(command);
        }
        ArrayList<Byte> contentArray = new ArrayList<Byte>();
        for (int i = 0; i < ((ArrayList)command.Content).size(); ++i) {
            OperateResultExOne<byte[]> read = omron.ReadFromCoreServer((byte[])((ArrayList)command.Content).get(i));
            if (!read.IsSuccess) {
                return OperateResultExOne.CreateFailedResult(read);
            }
            Utilities.ArrayListAddArray(contentArray, (byte[])read.Content);
        }
        return OperateResultExOne.CreateSuccessResult(Utilities.ToByteArray(contentArray));
    }

    public static OperateResult Write(IReadWriteDevice omron, String address, byte[] value) {
        OperateResultExOne<byte[]> command = OmronFinsNetHelper.BuildWriteWordCommand(address, value, false);
        if (!command.IsSuccess) {
            return command;
        }
        OperateResultExOne<byte[]> read = omron.ReadFromCoreServer((byte[])command.Content);
        if (!read.IsSuccess) {
            return read;
        }
        return OperateResult.CreateSuccessResult();
    }

    public static OperateResultExOne<boolean[]> ReadBool(IReadWriteDevice omron, String address, short length, int splits) {
        OperateResultExOne<byte[][]> command = OmronFinsNetHelper.BuildReadCommand(address, length, true, splits);
        if (!command.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(command);
        }
        ArrayList<Boolean> contentArray = new ArrayList<Boolean>();
        for (int i = 0; i < ((byte[][])command.Content).length; ++i) {
            OperateResultExOne<byte[]> read = omron.ReadFromCoreServer(((byte[][])command.Content)[i]);
            if (!read.IsSuccess) {
                return OperateResultExOne.CreateFailedResult(read);
            }
            boolean[] array = new boolean[((byte[])read.Content).length];
            for (int j = 0; j < array.length; ++j) {
                array[j] = ((byte[])read.Content)[j] != 0;
            }
            Utilities.ArrayListAddArray(contentArray, array);
        }
        return OperateResultExOne.CreateSuccessResult(Utilities.getBools(contentArray));
    }

    public static OperateResult Write(IReadWriteDevice omron, String address, boolean[] values) {
        byte[] array = new byte[values.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = values[i] ? (byte)1 : 0;
        }
        OperateResultExOne<byte[]> command = OmronFinsNetHelper.BuildWriteWordCommand(address, array, true);
        if (!command.IsSuccess) {
            return command;
        }
        OperateResultExOne<byte[]> read = omron.ReadFromCoreServer((byte[])command.Content);
        if (!read.IsSuccess) {
            return read;
        }
        return OperateResult.CreateSuccessResult();
    }
}

