/*
 * Decompiled with CFR 0.152.
 */
package metrics_influxdb;

import com.codahale.metrics.Counting;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SkipIdleReporter
extends ScheduledReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipIdleReporter.class);
    protected final boolean skipIdleMetrics;
    protected final Map<String, Long> previousValues;

    public SkipIdleReporter(MetricRegistry registry, String name, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit, boolean skipIdleMetrics) {
        super(registry, name, filter, rateUnit, durationUnit);
        this.skipIdleMetrics = skipIdleMetrics;
        this.previousValues = new TreeMap<String, Long>();
    }

    protected boolean canSkipMetric(String name, Counting counting) {
        boolean isIdle;
        boolean bl = isIdle = this.calculateDelta(name, counting.getCount()) == 0L;
        if (this.skipIdleMetrics && !isIdle) {
            this.previousValues.put(name, counting.getCount());
        }
        return this.skipIdleMetrics && isIdle;
    }

    private long calculateDelta(String name, long count) {
        Long previous = this.previousValues.get(name);
        if (previous == null) {
            return -1L;
        }
        if (count < previous) {
            LOGGER.warn("Saw a non-monotonically increasing value for metric '{}'", (Object)name);
            return 0L;
        }
        return count - previous;
    }
}

