/*
 * Decompiled with CFR 0.152.
 */
package metrics_influxdb.api.measurements;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import metrics_influxdb.api.measurements.MetricMeasurementTransformer;

public class CategoriesMetricMeasurementTransformer
implements MetricMeasurementTransformer {
    private static final String SEPARATOR = "\\.";
    private final String[] categories;

    public CategoriesMetricMeasurementTransformer(String ... categories) {
        this.categories = categories;
    }

    @Override
    public Map<String, String> tags(String metricName) {
        HashMap<String, String> tags = new HashMap<String, String>();
        String[] splitted = metricName.split(SEPARATOR);
        int nbSplittedToUse = Math.min(splitted.length - 1, this.categories.length);
        for (int i = 0; i < nbSplittedToUse; ++i) {
            tags.put(this.categories[i], splitted[i]);
        }
        return tags;
    }

    @Override
    public String measurementName(String metricName) {
        String[] splitted = metricName.split(SEPARATOR);
        CharSequence[] toUseInMeasurement = this.categories.length < splitted.length ? Arrays.copyOfRange(splitted, this.categories.length, splitted.length) : new String[]{splitted[splitted.length - 1]};
        return String.join((CharSequence)".", toUseInMeasurement);
    }
}

