/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidcarboni.cryptolite;

import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class ByteArray {
    public static final String ENCODING = "UTF8";

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return Hex.encodeHexString((byte[])bytes);
    }

    public static byte[] fromHexString(String hex) {
        String data = hex;
        if (hex.length() > 1 && (hex.charAt(1) == 'x' || hex.charAt(1) == 'X')) {
            data = hex.substring(2);
        }
        int len = data.length();
        byte[] result = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            result[i / 2] = (byte)((Character.digit(data.charAt(i), 16) << 4) + Character.digit(data.charAt(i + 1), 16));
        }
        return result;
    }

    public static String toBase64String(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return Base64.encodeBase64String((byte[])bytes);
    }

    public static byte[] fromBase64String(String base64) {
        if (base64 == null) {
            return null;
        }
        return Base64.decodeBase64((String)base64);
    }

    public static byte[] fromString(String string) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Error converting String to byte array using encoding UTF8");
        }
    }

    public static String toString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Error converting byte array to String using encoding UTF8");
        }
    }
}

