/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidcarboni.cryptolite;

import com.github.davidcarboni.cryptolite.ByteArray;
import com.github.davidcarboni.cryptolite.Keys;
import com.github.davidcarboni.cryptolite.Random;
import com.github.davidcarboni.cryptolite.SecurityProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class Crypto {
    public static final String CIPHER_ALGORITHM = "AES";
    public static final String CIPHER_MODE = "CTR";
    public static final String CIPHER_PADDING = "NoPadding";
    public static final String CIPHER_NAME = "AES/CTR/NoPadding";
    private Cipher cipher;

    public Crypto() {
        this(CIPHER_NAME);
    }

    protected Crypto(String cipherName) {
        this.cipher = this.getCipher(cipherName);
    }

    private Cipher getCipher(String cipherName) {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(cipherName);
        }
        catch (NoSuchAlgorithmException e) {
            if (SecurityProvider.addProvider()) {
                cipher = this.getCipher(cipherName);
            }
            throw new IllegalStateException("Algorithm unavailable: " + cipherName, e);
        }
        catch (NoSuchPaddingException e) {
            throw new IllegalStateException("Padding method unavailable: " + cipherName, e);
        }
        return cipher;
    }

    public String encrypt(String string, String password) {
        if (string == null) {
            return null;
        }
        String salt = Random.salt();
        SecretKey key = Keys.generateSecretKey(password, salt);
        byte[] bytes = ByteArray.fromString(string);
        byte[] result = ArrayUtils.addAll((byte[])ByteArray.fromBase64String(salt), (byte[])this.encrypt(bytes, key));
        return ByteArray.toBase64String(result);
    }

    public String encrypt(String string, SecretKey key) {
        if (string == null) {
            return null;
        }
        byte[] bytes = ByteArray.fromString(string);
        byte[] result = this.encrypt(bytes, key);
        return ByteArray.toBase64String(result);
    }

    protected byte[] encrypt(byte[] bytes, SecretKey key) {
        byte[] result;
        if (bytes == null) {
            return null;
        }
        byte[] iv = this.generateInitialisationVector();
        this.initCipher(1, key, iv);
        try {
            result = this.cipher.doFinal(bytes);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalStateException("Block-size exception when completing encryption.", e);
        }
        catch (BadPaddingException e) {
            throw new IllegalStateException("Padding error detected when completing encryption.", e);
        }
        result = ArrayUtils.addAll((byte[])iv, (byte[])result);
        return result;
    }

    public String decrypt(String encrypted, String password) {
        if (StringUtils.isEmpty((String)encrypted)) {
            return encrypted;
        }
        byte[] bytes = ByteArray.fromBase64String(encrypted);
        if (bytes.length < 16) {
            throw new IllegalArgumentException("Are you sure this is encrypted data? Byte length (" + bytes.length + ") is shorter than a salt value.");
        }
        byte[] salt = ArrayUtils.subarray((byte[])bytes, (int)0, (int)16);
        byte[] data = ArrayUtils.subarray((byte[])bytes, (int)16, (int)bytes.length);
        SecretKey key = Keys.generateSecretKey(password, ByteArray.toBase64String(salt));
        return ByteArray.toString(this.decrypt(data, key));
    }

    public String decrypt(String encrypted, SecretKey key) {
        if (StringUtils.isEmpty((String)encrypted)) {
            return encrypted;
        }
        byte[] bytes = ByteArray.fromBase64String(encrypted);
        return ByteArray.toString(this.decrypt(bytes, key));
    }

    protected byte[] decrypt(byte[] bytes, SecretKey key) {
        byte[] result;
        if (bytes == null) {
            return null;
        }
        int ivSize = this.cipher.getBlockSize();
        if (bytes.length < ivSize) {
            throw new IllegalArgumentException("Are you sure this is encrypted data? Byte length (" + bytes.length + ") is shorter than an initialisation vector.");
        }
        byte[] iv = ArrayUtils.subarray((byte[])bytes, (int)0, (int)ivSize);
        byte[] data = ArrayUtils.subarray((byte[])bytes, (int)ivSize, (int)bytes.length);
        this.initCipher(2, key, iv);
        try {
            result = this.cipher.doFinal(data);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalStateException("Block-size exception when completing String encryption.", e);
        }
        catch (BadPaddingException e) {
            throw new IllegalStateException("Padding error detected when completing String encryption.", e);
        }
        return result;
    }

    public OutputStream encrypt(OutputStream destination, String password) throws IOException {
        if (destination == null) {
            return null;
        }
        String salt = Random.salt();
        SecretKey key = Keys.generateSecretKey(password, salt);
        destination.write(ByteArray.fromBase64String(salt));
        return this.encrypt(destination, key);
    }

    public OutputStream encrypt(OutputStream destination, SecretKey key) throws IOException {
        if (destination == null) {
            return null;
        }
        byte[] iv = this.generateInitialisationVector();
        this.initCipher(1, key, iv);
        CipherOutputStream cipherOutputStream = new CipherOutputStream(destination, this.cipher);
        destination.write(iv);
        return cipherOutputStream;
    }

    public InputStream encrypt(InputStream source, SecretKey key) throws IOException {
        byte[] iv = new byte[this.cipher.getBlockSize()];
        source.read(iv);
        this.initCipher(2, key, iv);
        CipherInputStream cipherInputStream = new CipherInputStream(source, this.cipher);
        return cipherInputStream;
    }

    public InputStream decrypt(InputStream source, String password) throws IOException {
        byte[] salt = new byte[16];
        source.read(salt);
        SecretKey key = Keys.generateSecretKey(password, ByteArray.toBase64String(salt));
        return this.decrypt(source, key);
    }

    public InputStream decrypt(InputStream source, SecretKey key) throws IOException {
        byte[] iv = new byte[this.cipher.getBlockSize()];
        source.read(iv);
        this.initCipher(2, key, iv);
        CipherInputStream cipherInputStream = new CipherInputStream(source, this.cipher);
        return cipherInputStream;
    }

    byte[] generateInitialisationVector() {
        byte[] bytes = Random.bytes(this.cipher.getBlockSize());
        return bytes;
    }

    public int getIvSize() {
        return this.cipher.getBlockSize();
    }

    private void initCipher(int mode, SecretKey key, byte[] iv) {
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        try {
            this.cipher.init(mode, (Key)key, ivParameterSpec);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Invalid key for AES/CTR/NoPadding", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IllegalArgumentException("Invalid parameter passed to initialise cipher for encryption: zero IvParameterSpec containing " + this.cipher.getBlockSize() + " bytes.", e);
        }
    }
}

