/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidcarboni.cryptolite;

import com.github.davidcarboni.cryptolite.ByteArray;
import com.github.davidcarboni.cryptolite.Random;
import com.github.davidcarboni.cryptolite.SecurityProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public class DigitalSignature {
    public static final String ALGORITHM = "SHA256withRSAandMGF1";
    private String algorithm;

    public DigitalSignature() {
        this(ALGORITHM);
    }

    protected DigitalSignature(String algorithm) {
        this.algorithm = algorithm;
    }

    public String sign(String content, PrivateKey privateKey) {
        if (content == null) {
            return null;
        }
        try {
            byte[] bytes = content.getBytes("UTF8");
            ByteArrayInputStream input = new ByteArrayInputStream(bytes);
            return this.sign(input, privateKey);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unable to get bytes from string as UTF8", e);
        }
    }

    public String sign(InputStream content, PrivateKey privateKey) {
        if (content == null) {
            return null;
        }
        Signature signer = this.getSignature();
        try {
            signer.initSign(privateKey, Random.getInstance());
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Error initialising digital signature - invalid key", e);
        }
        try {
            try {
                int b;
                while ((b = content.read()) != -1) {
                    signer.update((byte)b);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error reading input for digital signature creation", e);
            }
            byte[] signatureBytes = signer.sign();
            return ByteArray.toBase64String(signatureBytes);
        }
        catch (SignatureException e) {
            throw new IllegalStateException("Error generating digital signature", e);
        }
    }

    public boolean verify(String content, PublicKey publicKey, String signature) {
        byte[] bytes;
        try {
            bytes = content.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unable to get bytes from string as UTF8", e);
        }
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        return this.verify(input, publicKey, signature);
    }

    public boolean verify(InputStream input, PublicKey publicKey, String signature) {
        byte[] signatureBytes = ByteArray.fromBase64String(signature);
        Signature signer = this.getSignature();
        try {
            signer.initVerify(publicKey);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Error initialising digital signature - invalid key", e);
        }
        try {
            try {
                int b;
                while ((b = input.read()) != -1) {
                    signer.update((byte)b);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error reading input for digital signature verification", e);
            }
            return signer.verify(signatureBytes);
        }
        catch (SignatureException e) {
            throw new IllegalStateException("Error verifying digital signature", e);
        }
    }

    protected Signature getSignature() {
        try {
            return Signature.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            if (SecurityProvider.addProvider()) {
                return this.getSignature();
            }
            throw new IllegalStateException("Algorithm unavailable: " + this.algorithm, e);
        }
    }
}

