/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidcarboni.cryptolite;

import com.github.davidcarboni.cryptolite.ByteArray;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class HashMac {
    public static final String ALGORITHM = "HmacSHA256";
    private byte[] key;
    private String algorithm;

    public HashMac(String key) {
        this(ByteArray.fromString(key), ALGORITHM);
    }

    public HashMac(SecretKey key) {
        this(key.getEncoded(), ALGORITHM);
    }

    protected HashMac(byte[] key, String algorithm) {
        this.key = key;
        this.algorithm = algorithm;
    }

    public String digest(String message) {
        try {
            Mac mac = Mac.getInstance(this.algorithm);
            SecretKeySpec macKey = new SecretKeySpec(this.key, this.algorithm);
            mac.init(macKey);
            byte[] digest = mac.doFinal(ByteArray.fromString(message));
            return ByteArray.toHexString(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm unavailable: " + this.algorithm, e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Unable to construct key for " + this.algorithm + ". Please check the value passed in when this class was initialised.", e);
        }
    }
}

