/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidcarboni.cryptolite;

import com.github.davidcarboni.cryptolite.ByteArray;
import com.github.davidcarboni.cryptolite.Random;
import com.github.davidcarboni.cryptolite.SecurityProvider;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class KeyExchange {
    public static final String CIPHER_ALGORITHM = "RSA";
    public static final String CIPHER_MODE = "None";
    public static final String CIPHER_PADDING = "OAEPWithSHA256AndMGF1Padding";
    private static final String CIPHER_NAME = "RSA/None/OAEPWithSHA256AndMGF1Padding";
    private Cipher cipher;
    private String cipherName;

    public KeyExchange() {
        this(CIPHER_NAME);
    }

    protected KeyExchange(String cipherName) {
        this.cipherName = cipherName;
    }

    public String encryptKey(SecretKey key, PublicKey destinationPublicKey) {
        byte[] encrypted;
        if (key == null) {
            return null;
        }
        byte[] bytes = key.getEncoded();
        try {
            Cipher cipher = this.getCipher(destinationPublicKey);
            encrypted = cipher.doFinal(bytes);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalArgumentException("Error encrypting SecretKey: " + IllegalBlockSizeException.class.getSimpleName(), e);
        }
        catch (BadPaddingException e) {
            throw new IllegalArgumentException("Error encrypting SecretKey: " + BadPaddingException.class.getSimpleName(), e);
        }
        return ByteArray.toBase64String(encrypted);
    }

    public SecretKey decryptKey(String encryptedKey, PrivateKey privateKey) {
        byte[] decrypted;
        if (encryptedKey == null) {
            return null;
        }
        byte[] bytes = ByteArray.fromBase64String(encryptedKey);
        try {
            Cipher cipher = this.getCipher(privateKey);
            decrypted = cipher.doFinal(bytes);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalArgumentException("Error encrypting SecretKey: " + IllegalBlockSizeException.class.getSimpleName(), e);
        }
        catch (BadPaddingException e) {
            throw new IllegalArgumentException("Error decrypting SecretKey", e);
        }
        return new SecretKeySpec(decrypted, "AES");
    }

    private Cipher getCipher(PublicKey key) {
        return this.getCipher(1, key);
    }

    private Cipher getCipher(PrivateKey key) {
        return this.getCipher(2, key);
    }

    private Cipher getCipher(int mode, Key key) {
        if (this.cipher == null) {
            try {
                this.cipher = Cipher.getInstance(this.cipherName);
            }
            catch (NoSuchAlgorithmException e) {
                if (SecurityProvider.addProvider()) {
                    this.cipher = this.getCipher(mode, key);
                }
                throw new IllegalStateException("Algorithm unavailable: " + this.cipherName, e);
            }
            catch (NoSuchPaddingException e) {
                throw new IllegalStateException("Padding method unavailable: " + this.cipherName, e);
            }
        }
        try {
            this.cipher.init(mode, key, Random.getInstance());
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Invalid key used to initialise cipher.", e);
        }
        return this.cipher;
    }
}

