/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidcarboni.cryptolite;

import com.github.davidcarboni.cryptolite.ByteArray;
import com.github.davidcarboni.cryptolite.Keys;
import com.github.davidcarboni.cryptolite.Random;
import com.github.davidcarboni.cryptolite.SecurityProvider;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.apache.commons.lang.StringUtils;

public class KeyWrapper
implements Serializable {
    private static final long serialVersionUID = -6232240044326148130L;
    private static final String WRAP_KEY_ALGORITHM = "AES";
    private static final String WRAP_ALGORITHM_SYMMETRIC = "AESWrap";
    private static final String WRAP_ALGORITHM_ASYMMETRIC = "AES/ECB/PKCS7Padding";
    public static final int PBKD_ITERATIONS = 1024;
    private SecretKey wrapKey;

    public KeyWrapper(String password, String salt) {
        this.wrapKey = Keys.generateSecretKey(password, salt);
    }

    public KeyWrapper(SecretKey wrapKey) {
        if (!StringUtils.equals((String)WRAP_KEY_ALGORITHM, (String)wrapKey.getAlgorithm())) {
            throw new IllegalArgumentException("The wrapping key algorithm needs to be AES");
        }
        this.wrapKey = wrapKey;
    }

    public String wrapSecretKey(SecretKey key) {
        return this.wrap(key, WRAP_ALGORITHM_SYMMETRIC);
    }

    public String wrapPrivateKey(PrivateKey key) {
        return this.wrap(key, WRAP_ALGORITHM_ASYMMETRIC);
    }

    public static String encodePublicKey(PublicKey key) {
        byte[] bytes = key.getEncoded();
        return ByteArray.toBase64String(bytes);
    }

    public SecretKey unwrapSecretKey(String wrappedKey) {
        return (SecretKey)this.unwrap(wrappedKey, WRAP_KEY_ALGORITHM, 3, WRAP_ALGORITHM_SYMMETRIC);
    }

    public PrivateKey unwrapPrivateKey(String wrappedKey) {
        return (PrivateKey)this.unwrap(wrappedKey, "RSA", 2, WRAP_ALGORITHM_ASYMMETRIC);
    }

    public static PublicKey decodePublicKey(String encodedKey) {
        KeyFactory keyFactory;
        byte[] bytes = ByteArray.fromBase64String(encodedKey);
        try {
            keyFactory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            if (SecurityProvider.addProvider()) {
                return KeyWrapper.decodePublicKey(encodedKey);
            }
            throw new IllegalStateException("Algorithm unavailable: AES", e);
        }
        try {
            return keyFactory.generatePublic(new X509EncodedKeySpec(bytes));
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException("Unable to convert key '" + encodedKey + "' to a valid public key.", e);
        }
    }

    private String wrap(Key key, String wrapAlgorithm) {
        try {
            Cipher cipher = Cipher.getInstance(wrapAlgorithm);
            cipher.init(3, (Key)this.wrapKey, Random.getInstance());
            byte[] wrappedKey = cipher.wrap(key);
            return ByteArray.toBase64String(wrappedKey);
        }
        catch (NoSuchAlgorithmException e) {
            if (SecurityProvider.addProvider()) {
                return this.wrap(key, wrapAlgorithm);
            }
            throw new IllegalStateException("Algorithm unavailable: " + wrapAlgorithm, e);
        }
        catch (NoSuchPaddingException e) {
            throw new IllegalStateException("Padding unavailable: " + wrapAlgorithm, e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Invalid key for " + wrapAlgorithm, e);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalStateException("Error in block size for algorithm " + wrapAlgorithm, e);
        }
    }

    private Key unwrap(String wrappedKey, String keyAlgorithm, int keyType, String wrapAlgorithm) {
        try {
            byte[] wrapped = ByteArray.fromBase64String(wrappedKey);
            Cipher cipher = Cipher.getInstance(wrapAlgorithm);
            cipher.init(4, (Key)this.wrapKey, Random.getInstance());
            Key result = cipher.unwrap(wrapped, keyAlgorithm, keyType);
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            if (SecurityProvider.addProvider()) {
                return this.unwrap(wrappedKey, keyAlgorithm, keyType, wrapAlgorithm);
            }
            throw new IllegalStateException("Algorithm unavailable: " + wrapAlgorithm, e);
        }
        catch (NoSuchPaddingException e) {
            throw new IllegalStateException("Padding unavailable: " + wrapAlgorithm, e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Invalid key for algorithm " + wrapAlgorithm, e);
        }
    }
}

