/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidcarboni.cryptolite;

import com.github.davidcarboni.cryptolite.ByteArray;
import com.github.davidcarboni.cryptolite.Random;
import com.github.davidcarboni.cryptolite.SecurityProvider;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class Keys {
    public static final String SYMMETRIC_ALGORITHM = "AES";
    public static final int SYMMETRIC_KEY_SIZE_STANDARD = 128;
    public static final int SYMMETRIC_KEY_SIZE_UNLIMITED = 256;
    public static final String SYMMETRIC_PASSWORD_ALGORITHM = "PBKDF2WithHmacSHA1";
    public static final int SYMMETRIC_PASSWORD_ITERATIONS = 1024;
    public static final String ASYMMETRIC_ALGORITHM = "RSA";
    public static final int ASYMMETRIC_KEY_SIZE = 3072;
    private static int symmetricKeySize = 128;

    public static SecretKey newSecretKey() {
        return Keys.newSecretKey(symmetricKeySize);
    }

    private static SecretKey newSecretKey(int symmetricKeySize) {
        KeyGenerator keyGenerator;
        try {
            keyGenerator = KeyGenerator.getInstance(SYMMETRIC_ALGORITHM);
            keyGenerator.init(symmetricKeySize, Random.getInstance());
        }
        catch (NoSuchAlgorithmException e) {
            if (SecurityProvider.addProvider()) {
                return Keys.newSecretKey(symmetricKeySize);
            }
            throw new IllegalStateException("Algorithm unavailable: AES", e);
        }
        SecretKey result = keyGenerator.generateKey();
        return result;
    }

    public static SecretKey generateSecretKey(String password, String salt) {
        return Keys.generateSecretKey(password.toCharArray(), salt, symmetricKeySize);
    }

    static SecretKey generateSecretKey(char[] password, String salt, int keySize) {
        SecretKey key;
        SecretKeyFactory factory;
        try {
            factory = SecretKeyFactory.getInstance(SYMMETRIC_PASSWORD_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            if (SecurityProvider.addProvider()) {
                return Keys.generateSecretKey(password, salt, keySize);
            }
            throw new IllegalStateException("Algorithm unavailable: PBKDF2WithHmacSHA1", e);
        }
        byte[] saltBytes = ByteArray.fromBase64String(salt);
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password, saltBytes, 1024, keySize);
        try {
            key = factory.generateSecret(pbeKeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalStateException("Error generating password-based key.", e);
        }
        return new SecretKeySpec(key.getEncoded(), SYMMETRIC_ALGORITHM);
    }

    public static KeyPair newKeyPair() {
        KeyPairGenerator keyPairGenerator;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance(ASYMMETRIC_ALGORITHM);
            keyPairGenerator.initialize(3072, Random.getInstance());
        }
        catch (NoSuchAlgorithmException e) {
            if (SecurityProvider.addProvider()) {
                return Keys.newKeyPair();
            }
            throw new IllegalStateException("Algorithm unavailable: RSA", e);
        }
        KeyPair result = keyPairGenerator.generateKeyPair();
        return result;
    }

    public static int getSymmetricKeySize() {
        return symmetricKeySize;
    }

    public static void setSymmetricKeySize(int newSymmetricKeySize) {
        symmetricKeySize = newSymmetricKeySize;
    }

    public static boolean canUseStrongKeys() {
        try {
            int maxKeyLen = Cipher.getMaxAllowedKeyLength(SYMMETRIC_ALGORITHM);
            return maxKeyLen >= 256;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm unavailable: AES", e);
        }
    }
}

