/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidcarboni.cryptolite;

import com.github.davidcarboni.cryptolite.ByteArray;
import com.github.davidcarboni.cryptolite.Keys;
import com.github.davidcarboni.cryptolite.Random;
import java.util.Arrays;
import javax.crypto.SecretKey;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class Password {
    public static final String ALGORITHM = "PBKDF2WithHmacSHA1";
    public static final int ITERATION_COUNT = 1024;
    public static final int HASH_SIZE = 256;

    public static String hash(String password) {
        String result = null;
        if (password != null) {
            String salt = Random.salt();
            byte[] hash = Password.hash(password, salt);
            byte[] concatenated = ArrayUtils.addAll((byte[])ByteArray.fromBase64String(salt), (byte[])hash);
            result = ByteArray.toBase64String(concatenated);
        }
        return result;
    }

    public static boolean verify(String password, String hash) {
        byte[] bytes;
        boolean result = false;
        if (StringUtils.isNotBlank((String)hash) && password != null && (bytes = ByteArray.fromBase64String(hash)).length >= 16) {
            String salt = Password.getSalt(bytes);
            byte[] existingHash = Password.getHash(bytes);
            byte[] comparisonHash = Password.hash(password, salt);
            result = Arrays.equals(existingHash, comparisonHash);
        }
        return result;
    }

    private static byte[] hash(String password, String salt) {
        SecretKey key = Keys.generateSecretKey(Password.toCharArray(password), salt, 256);
        return key.getEncoded();
    }

    private static char[] toCharArray(String password) {
        char[] result = password.toCharArray();
        if (result.length == 0) {
            result = new char[]{'\u0000'};
        }
        return result;
    }

    private static String getSalt(byte[] value) {
        byte[] salt = new byte[16];
        System.arraycopy(value, 0, salt, 0, salt.length);
        return ByteArray.toBase64String(salt);
    }

    private static byte[] getHash(byte[] value) {
        byte[] hash = new byte[value.length - 16];
        System.arraycopy(value, 16, hash, 0, hash.length);
        return hash;
    }
}

