/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidcarboni.cryptolite;

import com.github.davidcarboni.cryptolite.ByteArray;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class Random {
    public static final int ID_BITS = 256;
    public static final String ALGORITHM = "SHA1PRNG";
    public static final int SALT_BYTES = 16;
    private static final int bitsInAByte = 8;
    private static final int idLengthBytes = 32;
    private static final String passwordCharacters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static SecureRandom secureRandom;

    public static SecureRandom getInstance() {
        if (secureRandom == null) {
            try {
                secureRandom = SecureRandom.getInstance(ALGORITHM);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("Algorithm unavailable: SHA1PRNG", e);
            }
        }
        return secureRandom;
    }

    public static byte[] bytes(int length) {
        byte[] bytes = new byte[length];
        Random.getInstance().nextBytes(bytes);
        return bytes;
    }

    public static InputStream inputStream(final long length) {
        return new InputStream(){
            int count;

            @Override
            public int read() throws IOException {
                if ((long)this.count++ < length) {
                    return Random.bytes(1)[0] & 0xFF;
                }
                return -1;
            }
        };
    }

    public static String id() {
        byte[] idBytes = Random.bytes(32);
        return ByteArray.toHexString(idBytes);
    }

    public static String password(int length) {
        StringBuilder result = new StringBuilder();
        while (result.length() < length) {
            byte[] buffer = Random.bytes(length);
            int i = 0;
            do {
                int index;
                if ((index = buffer[i++] & 0x3F) >= passwordCharacters.length()) continue;
                result.append(passwordCharacters.charAt(index));
            } while (result.length() < length && i < buffer.length);
        }
        return result.toString();
    }

    public static String salt() {
        byte[] salt = Random.bytes(16);
        return ByteArray.toBase64String(salt);
    }
}

