/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidcarboni;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ResourceUtils {
    public static Class<?> classLoaderClass = ResourceUtils.class;

    public static InputStream getStream(String name) throws IOException {
        InputStream stream = classLoaderClass.getResourceAsStream(name);
        if (stream == null) {
            throw new IOException("Unable to locate resource " + name);
        }
        return stream;
    }

    public static Reader getReader(String name) throws IOException {
        InputStream input = ResourceUtils.getStream(name);
        return new InputStreamReader(input, "UTF-8");
    }

    public static String getString(String name) throws IOException {
        InputStream input = ResourceUtils.getStream(name);
        try {
            String string = IOUtils.toString((InputStream)input, (String)"UTF-8");
            return string;
        }
        catch (IOException e) {
            throw new IOException("Error reading resource to String.", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    public static File getFile(String name) throws IOException {
        InputStream input = ResourceUtils.getStream(name);
        try {
            File file = File.createTempFile("extracted", "resource");
            file.deleteOnExit();
            FileUtils.copyInputStreamToFile((InputStream)input, (File)file);
            File file2 = file;
            return file2;
        }
        catch (IOException e) {
            throw new IOException("Error copying resource to file.", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    public static Path getPath(String name) throws IOException {
        URL url = classLoaderClass.getResource(name);
        if (url == null) {
            throw new IOException("Unable to identify a CodeSource.");
        }
        try {
            URI uri = url.toURI();
            if (!uri.getScheme().equalsIgnoreCase("file")) {
                FileSystem fileSystem;
                try {
                    fileSystem = FileSystems.getFileSystem(uri);
                }
                catch (FileSystemNotFoundException e) {
                    fileSystem = FileSystems.newFileSystem(uri, new HashMap());
                }
                return fileSystem.getPath(name, new String[0]);
            }
            return Paths.get(uri);
        }
        catch (URISyntaxException e) {
            throw new IOException("Error copying resource to file.", e);
        }
    }

    public static Properties getProperties(String name) throws IOException {
        return ResourceUtils.getProperties(name, null);
    }

    public static Properties getProperties(String name, Properties defaults) throws IOException {
        InputStream input = ResourceUtils.getStream(name);
        try {
            Properties properties = new Properties(defaults);
            properties.load(input);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new IOException("Error reading properties file.", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    public static Document getXml(String name) throws IOException {
        Document result;
        InputStream input = null;
        try {
            input = ResourceUtils.getStream(name);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilderdocumentBuilder = documentBuilderFactory.newDocumentBuilder();
            result = documentBuilderdocumentBuilder.parse(input);
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Error reading XML resource: " + name, e);
        }
        catch (SAXException e) {
            throw new IOException("Error reading XML resource: " + name, e);
        }
        catch (IOException e) {
            throw new IOException("Error reading XML resource: " + name, e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
        return result;
    }
}

