/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.android;

import com.github.dm.jrt.ObjectProxyRoutineBuilder;
import com.github.dm.jrt.android.ServiceObjectProxyRoutineBuilder;
import com.github.dm.jrt.android.core.ServiceContext;
import com.github.dm.jrt.android.core.config.ServiceConfiguration;
import com.github.dm.jrt.android.object.ContextInvocationTarget;
import com.github.dm.jrt.android.object.JRoutineServiceObject;
import com.github.dm.jrt.android.object.builder.ServiceObjectRoutineBuilder;
import com.github.dm.jrt.android.proxy.JRoutineServiceProxy;
import com.github.dm.jrt.android.proxy.annotation.ServiceProxy;
import com.github.dm.jrt.android.proxy.builder.ServiceProxyRoutineBuilder;
import com.github.dm.jrt.core.config.InvocationConfiguration;
import com.github.dm.jrt.core.routine.Routine;
import com.github.dm.jrt.core.util.ClassToken;
import com.github.dm.jrt.core.util.ConstantConditions;
import com.github.dm.jrt.object.config.ObjectConfiguration;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DefaultServiceObjectProxyRoutineBuilder
implements ServiceObjectProxyRoutineBuilder {
    private final ServiceContext mContext;
    private final ContextInvocationTarget<?> mTarget;
    private ObjectProxyRoutineBuilder.BuilderType mBuilderType;
    private InvocationConfiguration mInvocationConfiguration = InvocationConfiguration.defaultConfiguration();
    private ObjectConfiguration mObjectConfiguration = ObjectConfiguration.defaultConfiguration();
    private ServiceConfiguration mServiceConfiguration = ServiceConfiguration.defaultConfiguration();

    DefaultServiceObjectProxyRoutineBuilder(@NotNull ServiceContext context, @NotNull ContextInvocationTarget<?> target) {
        this.mContext = (ServiceContext)ConstantConditions.notNull((String)"Service context", (Object)context);
        this.mTarget = (ContextInvocationTarget)ConstantConditions.notNull((String)"invocation target", target);
    }

    @Override
    @NotNull
    public ServiceObjectProxyRoutineBuilder apply(@NotNull InvocationConfiguration configuration) {
        this.mInvocationConfiguration = (InvocationConfiguration)ConstantConditions.notNull((String)"invocation configuration", (Object)configuration);
        return this;
    }

    @Override
    @NotNull
    public ServiceObjectProxyRoutineBuilder apply(@NotNull ObjectConfiguration configuration) {
        this.mObjectConfiguration = (ObjectConfiguration)ConstantConditions.notNull((String)"object configuration", (Object)configuration);
        return this;
    }

    @Override
    @NotNull
    public InvocationConfiguration.Builder<? extends ServiceObjectProxyRoutineBuilder> applyInvocationConfiguration() {
        return new InvocationConfiguration.Builder((InvocationConfiguration.Configurable)new InvocationConfiguration.Configurable<ServiceObjectProxyRoutineBuilder>(){

            @NotNull
            public ServiceObjectProxyRoutineBuilder apply(@NotNull InvocationConfiguration configuration) {
                return DefaultServiceObjectProxyRoutineBuilder.this.apply(configuration);
            }
        }, this.mInvocationConfiguration);
    }

    @Override
    @NotNull
    public ObjectConfiguration.Builder<? extends ServiceObjectProxyRoutineBuilder> applyObjectConfiguration() {
        return new ObjectConfiguration.Builder((ObjectConfiguration.Configurable)new ObjectConfiguration.Configurable<ServiceObjectProxyRoutineBuilder>(){

            @NotNull
            public ServiceObjectProxyRoutineBuilder apply(@NotNull ObjectConfiguration configuration) {
                return DefaultServiceObjectProxyRoutineBuilder.this.apply(configuration);
            }
        }, this.mObjectConfiguration);
    }

    @Override
    @NotNull
    public ServiceObjectProxyRoutineBuilder withType(@Nullable ObjectProxyRoutineBuilder.BuilderType builderType) {
        this.mBuilderType = builderType;
        return this;
    }

    @Override
    @NotNull
    public ServiceObjectProxyRoutineBuilder apply(@NotNull ServiceConfiguration configuration) {
        this.mServiceConfiguration = (ServiceConfiguration)ConstantConditions.notNull((String)"Service configuration", (Object)configuration);
        return this;
    }

    @Override
    @NotNull
    public ServiceConfiguration.Builder<? extends ServiceObjectProxyRoutineBuilder> applyServiceConfiguration() {
        return new ServiceConfiguration.Builder((ServiceConfiguration.Configurable)new ServiceConfiguration.Configurable<ServiceObjectProxyRoutineBuilder>(){

            @NotNull
            public ServiceObjectProxyRoutineBuilder apply(@NotNull ServiceConfiguration configuration) {
                return DefaultServiceObjectProxyRoutineBuilder.this.apply(configuration);
            }
        }, this.mServiceConfiguration);
    }

    @NotNull
    public <TYPE> TYPE buildProxy(@NotNull Class<TYPE> itf) {
        ObjectProxyRoutineBuilder.BuilderType builderType = this.mBuilderType;
        if (builderType == null) {
            ServiceProxy proxyAnnotation = itf.getAnnotation(ServiceProxy.class);
            if (proxyAnnotation != null && this.mTarget.isAssignableTo(proxyAnnotation.value())) {
                return (TYPE)this.newProxyBuilder().buildProxy(itf);
            }
            return (TYPE)this.newObjectBuilder().buildProxy(itf);
        }
        if (builderType == ObjectProxyRoutineBuilder.BuilderType.PROXY) {
            return (TYPE)this.newProxyBuilder().buildProxy(itf);
        }
        return (TYPE)this.newObjectBuilder().buildProxy(itf);
    }

    @NotNull
    public <TYPE> TYPE buildProxy(@NotNull ClassToken<TYPE> itf) {
        return this.buildProxy(itf.getRawClass());
    }

    @NotNull
    public <IN, OUT> Routine<IN, OUT> method(@NotNull String name) {
        return this.newObjectBuilder().method(name);
    }

    @NotNull
    public <IN, OUT> Routine<IN, OUT> method(@NotNull String name, Class<?> ... parameterTypes) {
        return this.newObjectBuilder().method(name, (Class[])parameterTypes);
    }

    @NotNull
    public <IN, OUT> Routine<IN, OUT> method(@NotNull Method method) {
        return this.newObjectBuilder().method(method);
    }

    @NotNull
    private ServiceObjectRoutineBuilder newObjectBuilder() {
        return (ServiceObjectRoutineBuilder)JRoutineServiceObject.on((ServiceContext)this.mContext).with(this.mTarget).apply(this.mInvocationConfiguration).apply(this.mObjectConfiguration).apply(this.mServiceConfiguration);
    }

    @NotNull
    private ServiceProxyRoutineBuilder newProxyBuilder() {
        return (ServiceProxyRoutineBuilder)JRoutineServiceProxy.on((ServiceContext)this.mContext).with(this.mTarget).apply(this.mInvocationConfiguration).apply(this.mObjectConfiguration).apply(this.mServiceConfiguration);
    }
}

