/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.android;

import com.github.dm.jrt.android.DefaultServiceObjectProxyRoutineBuilder;
import com.github.dm.jrt.android.ServiceObjectProxyRoutineBuilder;
import com.github.dm.jrt.android.core.JRoutineService;
import com.github.dm.jrt.android.core.ServiceContext;
import com.github.dm.jrt.android.core.builder.ServiceRoutineBuilder;
import com.github.dm.jrt.android.core.invocation.TargetInvocationFactory;
import com.github.dm.jrt.android.object.ContextInvocationTarget;
import com.github.dm.jrt.core.builder.RoutineBuilder;
import com.github.dm.jrt.core.invocation.Invocation;
import com.github.dm.jrt.core.util.ClassToken;
import com.github.dm.jrt.core.util.ConstantConditions;
import org.jetbrains.annotations.NotNull;

public class ServiceBuilder {
    private final ServiceContext mContext;

    protected ServiceBuilder(@NotNull ServiceContext context) {
        this.mContext = (ServiceContext)ConstantConditions.notNull((String)"Service context", (Object)context);
    }

    @NotNull
    public <IN, OUT> RoutineBuilder<IN, OUT> with(@NotNull Class<? extends Invocation<IN, OUT>> invocationClass) {
        return this.with(TargetInvocationFactory.factoryOf(invocationClass));
    }

    @NotNull
    public <IN, OUT> RoutineBuilder<IN, OUT> with(@NotNull Class<? extends Invocation<IN, OUT>> invocationClass, Object ... args) {
        return this.with(TargetInvocationFactory.factoryOf(invocationClass, (Object[])args));
    }

    @NotNull
    public <IN, OUT> RoutineBuilder<IN, OUT> with(@NotNull ClassToken<? extends Invocation<IN, OUT>> invocationToken) {
        return this.with(TargetInvocationFactory.factoryOf(invocationToken));
    }

    @NotNull
    public <IN, OUT> RoutineBuilder<IN, OUT> with(@NotNull ClassToken<? extends Invocation<IN, OUT>> invocationToken, Object ... args) {
        return this.with(TargetInvocationFactory.factoryOf(invocationToken, (Object[])args));
    }

    @NotNull
    public <IN, OUT> RoutineBuilder<IN, OUT> with(@NotNull Invocation<IN, OUT> invocation) {
        return this.with(ClassToken.tokenOf(invocation));
    }

    @NotNull
    public <IN, OUT> RoutineBuilder<IN, OUT> with(@NotNull Invocation<IN, OUT> invocation, Object ... args) {
        return this.with(ClassToken.tokenOf(invocation), args);
    }

    @NotNull
    public ServiceObjectProxyRoutineBuilder with(@NotNull ContextInvocationTarget<?> target) {
        return new DefaultServiceObjectProxyRoutineBuilder(this.mContext, target);
    }

    @NotNull
    public <IN, OUT> ServiceRoutineBuilder<IN, OUT> with(@NotNull TargetInvocationFactory<IN, OUT> target) {
        return JRoutineService.on((ServiceContext)this.mContext).with(target);
    }

    @NotNull
    public ServiceObjectProxyRoutineBuilder withClassOfType(@NotNull Class<?> targetClass) {
        return this.with(ContextInvocationTarget.classOfType(targetClass));
    }

    @NotNull
    public ServiceObjectProxyRoutineBuilder withInstanceOf(@NotNull Class<?> targetClass) {
        return this.with(ContextInvocationTarget.instanceOf(targetClass));
    }

    @NotNull
    public ServiceObjectProxyRoutineBuilder withInstanceOf(@NotNull Class<?> targetClass, Object ... factoryArgs) {
        return this.with(ContextInvocationTarget.instanceOf(targetClass, (Object[])factoryArgs));
    }
}

