/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.android.v11;

import com.github.dm.jrt.android.LoaderObjectProxyRoutineBuilder;
import com.github.dm.jrt.android.core.builder.LoaderChannelBuilder;
import com.github.dm.jrt.android.core.builder.LoaderRoutineBuilder;
import com.github.dm.jrt.android.core.invocation.ContextInvocation;
import com.github.dm.jrt.android.core.invocation.ContextInvocationFactory;
import com.github.dm.jrt.android.object.ContextInvocationTarget;
import com.github.dm.jrt.android.v11.DefaultLoaderObjectProxyRoutineBuilder;
import com.github.dm.jrt.android.v11.SupplierContextInvocationFactory;
import com.github.dm.jrt.android.v11.core.JRoutineLoader;
import com.github.dm.jrt.android.v11.core.LoaderContext;
import com.github.dm.jrt.core.channel.Channel;
import com.github.dm.jrt.core.invocation.CommandInvocation;
import com.github.dm.jrt.core.invocation.Invocation;
import com.github.dm.jrt.core.invocation.InvocationFactory;
import com.github.dm.jrt.core.invocation.MappingInvocation;
import com.github.dm.jrt.core.util.ClassToken;
import com.github.dm.jrt.core.util.ConstantConditions;
import com.github.dm.jrt.function.BiConsumer;
import com.github.dm.jrt.function.Consumer;
import com.github.dm.jrt.function.Decorator;
import com.github.dm.jrt.function.Function;
import com.github.dm.jrt.function.Functions;
import com.github.dm.jrt.function.Predicate;
import com.github.dm.jrt.function.Supplier;
import com.github.dm.jrt.function.SupplierDecorator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LoaderBuilder {
    private final LoaderContext mContext;

    LoaderBuilder(@NotNull LoaderContext context) {
        this.mContext = (LoaderContext)ConstantConditions.notNull((String)"Loader context", (Object)context);
    }

    private static void checkStatic(@NotNull Decorator decorator, @NotNull Object function) {
        if (!decorator.hasStaticScope()) {
            throw new IllegalArgumentException("the function instance does not have a static scope: " + function.getClass().getName());
        }
    }

    @NotNull
    public <IN, OUT> LoaderRoutineBuilder<IN, OUT> with(@NotNull Class<? extends Invocation<IN, OUT>> invocationClass) {
        return this.with(ContextInvocationFactory.factoryOf(invocationClass));
    }

    @NotNull
    public <IN, OUT> LoaderRoutineBuilder<IN, OUT> with(@NotNull Class<? extends Invocation<IN, OUT>> invocationClass, Object ... args) {
        return this.with(ContextInvocationFactory.factoryOf(invocationClass, (Object[])args));
    }

    @NotNull
    public <IN, OUT> LoaderRoutineBuilder<IN, OUT> with(@NotNull ClassToken<? extends Invocation<IN, OUT>> invocationToken) {
        return this.with(ContextInvocationFactory.factoryOf(invocationToken));
    }

    @NotNull
    public <IN, OUT> LoaderRoutineBuilder<IN, OUT> with(@NotNull ClassToken<? extends Invocation<IN, OUT>> invocationToken, Object ... args) {
        return this.with(ContextInvocationFactory.factoryOf(invocationToken, (Object[])args));
    }

    @NotNull
    public <OUT> LoaderRoutineBuilder<Void, OUT> with(@NotNull CommandInvocation<OUT> invocation) {
        return this.with((InvocationFactory)invocation);
    }

    @NotNull
    public <IN, OUT> LoaderRoutineBuilder<IN, OUT> with(@NotNull MappingInvocation<IN, OUT> invocation) {
        return this.with((InvocationFactory<IN, OUT>)invocation);
    }

    @NotNull
    public <IN, OUT> LoaderRoutineBuilder<IN, OUT> with(@NotNull Invocation<IN, OUT> invocation) {
        return this.with(ClassToken.tokenOf(invocation));
    }

    @NotNull
    public <IN, OUT> LoaderRoutineBuilder<IN, OUT> with(@NotNull Invocation<IN, OUT> invocation, Object ... args) {
        return this.with(ClassToken.tokenOf(invocation), args);
    }

    @NotNull
    public <IN, OUT> LoaderRoutineBuilder<IN, OUT> with(@NotNull ContextInvocationFactory<IN, OUT> factory) {
        return JRoutineLoader.on((LoaderContext)this.mContext).with(factory);
    }

    @NotNull
    public LoaderObjectProxyRoutineBuilder with(@NotNull ContextInvocationTarget<?> target) {
        return new DefaultLoaderObjectProxyRoutineBuilder(this.mContext, target);
    }

    @NotNull
    public <IN, OUT> LoaderRoutineBuilder<IN, OUT> with(@NotNull InvocationFactory<IN, OUT> factory) {
        return this.with(ContextInvocationFactory.factoryFrom(factory));
    }

    @NotNull
    public <IN, OUT> LoaderRoutineBuilder<IN, OUT> withCall(@NotNull Function<? super List<IN>, ? extends OUT> function) {
        LoaderBuilder.checkStatic((Decorator)Functions.decorate(function), function);
        return this.with(Functions.functionCall(function));
    }

    @NotNull
    public <IN, OUT> LoaderRoutineBuilder<IN, OUT> withCallConsumer(@NotNull BiConsumer<? super List<IN>, ? super Channel<OUT, ?>> consumer) {
        LoaderBuilder.checkStatic((Decorator)Functions.decorate(consumer), consumer);
        return this.with(Functions.consumerCall(consumer));
    }

    @NotNull
    public LoaderObjectProxyRoutineBuilder withClassOfType(@NotNull Class<?> targetClass) {
        return this.with(ContextInvocationTarget.classOfType(targetClass));
    }

    @NotNull
    public <OUT> LoaderRoutineBuilder<Void, OUT> withCommand(@NotNull Supplier<? extends OUT> supplier) {
        LoaderBuilder.checkStatic((Decorator)Functions.decorate(supplier), supplier);
        return this.with(Functions.supplierCommand(supplier));
    }

    @NotNull
    public <OUT> LoaderRoutineBuilder<Void, OUT> withCommandConsumer(@NotNull Consumer<? super Channel<OUT, ?>> consumer) {
        LoaderBuilder.checkStatic((Decorator)Functions.decorate(consumer), consumer);
        return this.with(Functions.consumerCommand(consumer));
    }

    @NotNull
    public <IN, OUT> LoaderRoutineBuilder<IN, OUT> withContextFactory(@NotNull Supplier<? extends ContextInvocation<? super IN, ? extends OUT>> supplier) {
        SupplierDecorator wrapper = Functions.decorate(supplier);
        LoaderBuilder.checkStatic((Decorator)wrapper, supplier);
        return this.with(new SupplierContextInvocationFactory(wrapper));
    }

    @NotNull
    public <IN, OUT> LoaderRoutineBuilder<IN, OUT> withFactory(@NotNull Supplier<? extends Invocation<? super IN, ? extends OUT>> supplier) {
        LoaderBuilder.checkStatic((Decorator)Functions.decorate(supplier), supplier);
        return this.with(Functions.supplierFactory(supplier));
    }

    @NotNull
    public <IN> LoaderRoutineBuilder<IN, IN> withFilter(@NotNull Predicate<? super IN> predicate) {
        LoaderBuilder.checkStatic((Decorator)Functions.decorate(predicate), predicate);
        return this.with(Functions.predicateFilter(predicate));
    }

    @NotNull
    public LoaderChannelBuilder withId(int loaderId) {
        return JRoutineLoader.on((LoaderContext)this.mContext).withId(loaderId);
    }

    @NotNull
    public LoaderObjectProxyRoutineBuilder withInstanceOf(@NotNull Class<?> targetClass) {
        return this.with(ContextInvocationTarget.instanceOf(targetClass));
    }

    @NotNull
    public LoaderObjectProxyRoutineBuilder withInstanceOf(@NotNull Class<?> targetClass, Object ... factoryArgs) {
        return this.with(ContextInvocationTarget.instanceOf(targetClass, (Object[])factoryArgs));
    }

    @NotNull
    public <IN, OUT> LoaderRoutineBuilder<IN, OUT> withMapping(@NotNull Function<? super IN, ? extends OUT> function) {
        LoaderBuilder.checkStatic((Decorator)Functions.decorate(function), function);
        return this.with(Functions.functionMapping(function));
    }

    @NotNull
    public <IN, OUT> LoaderRoutineBuilder<IN, OUT> withMappingConsumer(@NotNull BiConsumer<? super IN, ? super Channel<OUT, ?>> consumer) {
        LoaderBuilder.checkStatic((Decorator)Functions.decorate(consumer), consumer);
        return this.with(Functions.consumerMapping(consumer));
    }
}

