/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.android.v4;

import com.github.dm.jrt.ObjectProxyRoutineBuilder;
import com.github.dm.jrt.android.LoaderObjectProxyRoutineBuilder;
import com.github.dm.jrt.android.core.config.LoaderConfiguration;
import com.github.dm.jrt.android.core.routine.LoaderRoutine;
import com.github.dm.jrt.android.object.ContextInvocationTarget;
import com.github.dm.jrt.android.object.builder.LoaderObjectRoutineBuilder;
import com.github.dm.jrt.android.proxy.annotation.LoaderProxyCompat;
import com.github.dm.jrt.android.proxy.builder.LoaderProxyRoutineBuilder;
import com.github.dm.jrt.android.v4.core.LoaderContextCompat;
import com.github.dm.jrt.android.v4.object.JRoutineLoaderObjectCompat;
import com.github.dm.jrt.android.v4.proxy.JRoutineLoaderProxyCompat;
import com.github.dm.jrt.core.config.InvocationConfiguration;
import com.github.dm.jrt.core.util.ClassToken;
import com.github.dm.jrt.core.util.ConstantConditions;
import com.github.dm.jrt.object.config.ObjectConfiguration;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DefaultLoaderObjectProxyRoutineBuilderCompat
implements LoaderObjectProxyRoutineBuilder {
    private final LoaderContextCompat mContext;
    private final ContextInvocationTarget<?> mTarget;
    private ObjectProxyRoutineBuilder.BuilderType mBuilderType;
    private InvocationConfiguration mInvocationConfiguration = InvocationConfiguration.defaultConfiguration();
    private LoaderConfiguration mLoaderConfiguration = LoaderConfiguration.defaultConfiguration();
    private ObjectConfiguration mObjectConfiguration = ObjectConfiguration.defaultConfiguration();

    DefaultLoaderObjectProxyRoutineBuilderCompat(@NotNull LoaderContextCompat context, @NotNull ContextInvocationTarget<?> target) {
        this.mContext = (LoaderContextCompat)ConstantConditions.notNull((String)"Loader context", (Object)context);
        this.mTarget = (ContextInvocationTarget)ConstantConditions.notNull((String)"invocation target", target);
    }

    @Override
    @NotNull
    public LoaderObjectProxyRoutineBuilder apply(@NotNull InvocationConfiguration configuration) {
        this.mInvocationConfiguration = (InvocationConfiguration)ConstantConditions.notNull((String)"invocation configuration", (Object)configuration);
        return this;
    }

    @Override
    @NotNull
    public LoaderObjectProxyRoutineBuilder apply(@NotNull ObjectConfiguration configuration) {
        this.mObjectConfiguration = (ObjectConfiguration)ConstantConditions.notNull((String)"object configuration", (Object)configuration);
        return this;
    }

    @Override
    @NotNull
    public InvocationConfiguration.Builder<? extends LoaderObjectProxyRoutineBuilder> applyInvocationConfiguration() {
        return new InvocationConfiguration.Builder((InvocationConfiguration.Configurable)new InvocationConfiguration.Configurable<LoaderObjectProxyRoutineBuilder>(){

            @NotNull
            public LoaderObjectProxyRoutineBuilder apply(@NotNull InvocationConfiguration configuration) {
                return DefaultLoaderObjectProxyRoutineBuilderCompat.this.apply(configuration);
            }
        }, this.mInvocationConfiguration);
    }

    @Override
    @NotNull
    public ObjectConfiguration.Builder<? extends LoaderObjectProxyRoutineBuilder> applyObjectConfiguration() {
        return new ObjectConfiguration.Builder((ObjectConfiguration.Configurable)new ObjectConfiguration.Configurable<LoaderObjectProxyRoutineBuilder>(){

            @NotNull
            public LoaderObjectProxyRoutineBuilder apply(@NotNull ObjectConfiguration configuration) {
                return DefaultLoaderObjectProxyRoutineBuilderCompat.this.apply(configuration);
            }
        }, this.mObjectConfiguration);
    }

    @Override
    @NotNull
    public LoaderObjectProxyRoutineBuilder withType(@Nullable ObjectProxyRoutineBuilder.BuilderType builderType) {
        this.mBuilderType = builderType;
        return this;
    }

    @Override
    @NotNull
    public LoaderObjectProxyRoutineBuilder apply(@NotNull LoaderConfiguration configuration) {
        this.mLoaderConfiguration = (LoaderConfiguration)ConstantConditions.notNull((String)"Loader configuration", (Object)configuration);
        return this;
    }

    @Override
    @NotNull
    public LoaderConfiguration.Builder<? extends LoaderObjectProxyRoutineBuilder> applyLoaderConfiguration() {
        return new LoaderConfiguration.Builder((LoaderConfiguration.Configurable)new LoaderConfiguration.Configurable<LoaderObjectProxyRoutineBuilder>(){

            @NotNull
            public LoaderObjectProxyRoutineBuilder apply(@NotNull LoaderConfiguration configuration) {
                return DefaultLoaderObjectProxyRoutineBuilderCompat.this.apply(configuration);
            }
        }, this.mLoaderConfiguration);
    }

    @NotNull
    public <TYPE> TYPE buildProxy(@NotNull Class<TYPE> itf) {
        ObjectProxyRoutineBuilder.BuilderType builderType = this.mBuilderType;
        if (builderType == null) {
            LoaderProxyCompat proxyAnnotation = itf.getAnnotation(LoaderProxyCompat.class);
            if (proxyAnnotation != null && this.mTarget.isAssignableTo(proxyAnnotation.value())) {
                return (TYPE)this.newProxyBuilder().buildProxy(itf);
            }
            return (TYPE)this.newObjectBuilder().buildProxy(itf);
        }
        if (builderType == ObjectProxyRoutineBuilder.BuilderType.PROXY) {
            return (TYPE)this.newProxyBuilder().buildProxy(itf);
        }
        return (TYPE)this.newObjectBuilder().buildProxy(itf);
    }

    @NotNull
    public <TYPE> TYPE buildProxy(@NotNull ClassToken<TYPE> itf) {
        return this.buildProxy(itf.getRawClass());
    }

    @NotNull
    public <IN, OUT> LoaderRoutine<IN, OUT> method(@NotNull String name) {
        return this.newObjectBuilder().method(name);
    }

    @NotNull
    public <IN, OUT> LoaderRoutine<IN, OUT> method(@NotNull String name, Class<?> ... parameterTypes) {
        return this.newObjectBuilder().method(name, (Class[])parameterTypes);
    }

    @NotNull
    public <IN, OUT> LoaderRoutine<IN, OUT> method(@NotNull Method method) {
        return this.newObjectBuilder().method(method);
    }

    @NotNull
    private LoaderObjectRoutineBuilder newObjectBuilder() {
        return (LoaderObjectRoutineBuilder)JRoutineLoaderObjectCompat.on((LoaderContextCompat)this.mContext).with(this.mTarget).apply(this.mInvocationConfiguration).apply(this.mObjectConfiguration).apply(this.mLoaderConfiguration);
    }

    @NotNull
    private LoaderProxyRoutineBuilder newProxyBuilder() {
        return (LoaderProxyRoutineBuilder)JRoutineLoaderProxyCompat.on((LoaderContextCompat)this.mContext).with(this.mTarget).apply(this.mInvocationConfiguration).apply(this.mObjectConfiguration).apply(this.mLoaderConfiguration);
    }
}

