/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.dm.jrt.core;

import com.github.dm.jrt.invocation.Invocation;

import org.jetbrains.annotations.NotNull;

/**
 * Interface defining an observer of invocation instances.
 * <p/>
 * Created by davide-maestroni on 11/26/2015.
 *
 * @param <IN>  the input data type.
 * @param <OUT> the output data type.
 */
interface InvocationObserver<IN, OUT> {

    /**
     * Called when a new invocation instances is available.
     *
     * @param invocation the invocation.
     */
    void onCreate(@NotNull Invocation<IN, OUT> invocation);

    /**
     * Called when an error occurs during the invocation instantiation.
     *
     * @param error the error.
     */
    void onError(@NotNull Throwable error);
}
