/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.builder;

import com.github.dm.jrt.builder.InvocationConfiguration;
import com.github.dm.jrt.log.Log;
import com.github.dm.jrt.runner.Runner;
import com.github.dm.jrt.util.TimeDuration;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChannelConfiguration {
    public static final int DEFAULT = Integer.MIN_VALUE;
    private static final DefaultConfigurable sDefaultConfigurable = new DefaultConfigurable();
    public static final ChannelConfiguration DEFAULT_CONFIGURATION = Builder.access$100(ChannelConfiguration.builder());
    private final Runner mAsyncRunner;
    private final int mChannelMaxSize;
    private final InvocationConfiguration.OrderType mChannelOrderType;
    private final TimeDuration mChannelTimeout;
    private final Log mLog;
    private final Log.Level mLogLevel;
    private final TimeDuration mReadTimeout;
    private final InvocationConfiguration.TimeoutActionType mTimeoutActionType;

    private ChannelConfiguration(@Nullable Runner asyncRunner, @Nullable TimeDuration readTimeout, @Nullable InvocationConfiguration.TimeoutActionType actionType, @Nullable InvocationConfiguration.OrderType channelOrderType, int channelMaxSize, @Nullable TimeDuration channelTimeout, @Nullable Log log, @Nullable Log.Level logLevel) {
        this.mAsyncRunner = asyncRunner;
        this.mReadTimeout = readTimeout;
        this.mTimeoutActionType = actionType;
        this.mChannelOrderType = channelOrderType;
        this.mChannelMaxSize = channelMaxSize;
        this.mChannelTimeout = channelTimeout;
        this.mLog = log;
        this.mLogLevel = logLevel;
    }

    @NotNull
    public static Builder<ChannelConfiguration> builder() {
        return new Builder<ChannelConfiguration>(sDefaultConfigurable);
    }

    @NotNull
    public static Builder<ChannelConfiguration> builderFrom(@Nullable ChannelConfiguration initialConfiguration) {
        return initialConfiguration == null ? ChannelConfiguration.builder() : new Builder<ChannelConfiguration>(sDefaultConfigurable, initialConfiguration);
    }

    @NotNull
    public Builder<ChannelConfiguration> builderFrom() {
        return ChannelConfiguration.builderFrom(this);
    }

    public Runner getAsyncRunnerOr(@Nullable Runner valueIfNotSet) {
        Runner runner = this.mAsyncRunner;
        return runner != null ? runner : valueIfNotSet;
    }

    public int getChannelMaxSizeOr(int valueIfNotSet) {
        int maxSize = this.mChannelMaxSize;
        return maxSize != Integer.MIN_VALUE ? maxSize : valueIfNotSet;
    }

    public InvocationConfiguration.OrderType getChannelOrderTypeOr(@Nullable InvocationConfiguration.OrderType valueIfNotSet) {
        InvocationConfiguration.OrderType orderType = this.mChannelOrderType;
        return orderType != null ? orderType : valueIfNotSet;
    }

    public TimeDuration getChannelTimeoutOr(@Nullable TimeDuration valueIfNotSet) {
        TimeDuration timeout = this.mChannelTimeout;
        return timeout != null ? timeout : valueIfNotSet;
    }

    public Log.Level getLogLevelOr(@Nullable Log.Level valueIfNotSet) {
        Log.Level logLevel = this.mLogLevel;
        return logLevel != null ? logLevel : valueIfNotSet;
    }

    public Log getLogOr(@Nullable Log valueIfNotSet) {
        Log log = this.mLog;
        return log != null ? log : valueIfNotSet;
    }

    public InvocationConfiguration.TimeoutActionType getReadTimeoutActionOr(@Nullable InvocationConfiguration.TimeoutActionType valueIfNotSet) {
        InvocationConfiguration.TimeoutActionType timeoutActionType = this.mTimeoutActionType;
        return timeoutActionType != null ? timeoutActionType : valueIfNotSet;
    }

    public TimeDuration getReadTimeoutOr(@Nullable TimeDuration valueIfNotSet) {
        TimeDuration readTimeout = this.mReadTimeout;
        return readTimeout != null ? readTimeout : valueIfNotSet;
    }

    public int hashCode() {
        int result = this.mAsyncRunner != null ? this.mAsyncRunner.hashCode() : 0;
        result = 31 * result + this.mChannelMaxSize;
        result = 31 * result + (this.mChannelOrderType != null ? this.mChannelOrderType.hashCode() : 0);
        result = 31 * result + (this.mChannelTimeout != null ? this.mChannelTimeout.hashCode() : 0);
        result = 31 * result + (this.mLog != null ? this.mLog.hashCode() : 0);
        result = 31 * result + (this.mLogLevel != null ? this.mLogLevel.hashCode() : 0);
        result = 31 * result + (this.mReadTimeout != null ? this.mReadTimeout.hashCode() : 0);
        result = 31 * result + (this.mTimeoutActionType != null ? this.mTimeoutActionType.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChannelConfiguration)) {
            return false;
        }
        ChannelConfiguration that = (ChannelConfiguration)o;
        if (this.mChannelMaxSize != that.mChannelMaxSize) {
            return false;
        }
        if (this.mAsyncRunner != null ? !this.mAsyncRunner.equals(that.mAsyncRunner) : that.mAsyncRunner != null) {
            return false;
        }
        if (this.mChannelOrderType != that.mChannelOrderType) {
            return false;
        }
        if (this.mChannelTimeout != null ? !this.mChannelTimeout.equals(that.mChannelTimeout) : that.mChannelTimeout != null) {
            return false;
        }
        if (this.mLog != null ? !this.mLog.equals(that.mLog) : that.mLog != null) {
            return false;
        }
        if (this.mLogLevel != that.mLogLevel) {
            return false;
        }
        if (this.mReadTimeout != null ? !this.mReadTimeout.equals(that.mReadTimeout) : that.mReadTimeout != null) {
            return false;
        }
        return this.mTimeoutActionType == that.mTimeoutActionType;
    }

    public String toString() {
        return "ChannelConfiguration{mAsyncRunner=" + this.mAsyncRunner + ", mChannelMaxSize=" + this.mChannelMaxSize + ", mChannelOrderType=" + (Object)((Object)this.mChannelOrderType) + ", mChannelTimeout=" + this.mChannelTimeout + ", mLog=" + this.mLog + ", mLogLevel=" + (Object)((Object)this.mLogLevel) + ", mReadTimeout=" + this.mReadTimeout + ", mTimeoutActionType=" + (Object)((Object)this.mTimeoutActionType) + '}';
    }

    @NotNull
    public InvocationConfiguration toInputChannelConfiguration() {
        return this.toInvocationConfiguration().builderFrom().withInputMaxSize(this.getChannelMaxSizeOr(Integer.MIN_VALUE)).withInputOrder(this.getChannelOrderTypeOr(null)).withInputTimeout(this.getChannelTimeoutOr(null)).set();
    }

    @NotNull
    public InvocationConfiguration toInvocationConfiguration() {
        return InvocationConfiguration.builder().withRunner(this.getAsyncRunnerOr(null)).withReadTimeout(this.getReadTimeoutOr(null)).withReadTimeoutAction(this.getReadTimeoutActionOr(null)).withLog(this.getLogOr(null)).withLogLevel(this.getLogLevelOr(null)).set();
    }

    @NotNull
    public InvocationConfiguration toOutputChannelConfiguration() {
        return this.toInvocationConfiguration().builderFrom().withOutputMaxSize(this.getChannelMaxSizeOr(Integer.MIN_VALUE)).withOutputOrder(this.getChannelOrderTypeOr(null)).withOutputTimeout(this.getChannelTimeoutOr(null)).set();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultConfigurable
    implements Configurable<ChannelConfiguration> {
        private DefaultConfigurable() {
        }

        @Override
        @NotNull
        public ChannelConfiguration setConfiguration(@NotNull ChannelConfiguration configuration) {
            return configuration;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder<TYPE> {
        private final Configurable<? extends TYPE> mConfigurable;
        private Runner mAsyncRunner;
        private int mChannelMaxSize;
        private InvocationConfiguration.OrderType mChannelOrderType;
        private TimeDuration mChannelTimeout;
        private Log mLog;
        private Log.Level mLogLevel;
        private TimeDuration mReadTimeout;
        private InvocationConfiguration.TimeoutActionType mTimeoutActionType;

        public Builder(@NotNull Configurable<? extends TYPE> configurable) {
            if (configurable == null) {
                throw new NullPointerException("the configurable instance must no be null");
            }
            this.mConfigurable = configurable;
            this.mChannelMaxSize = Integer.MIN_VALUE;
        }

        public Builder(@NotNull Configurable<? extends TYPE> configurable, @NotNull ChannelConfiguration initialConfiguration) {
            if (configurable == null) {
                throw new NullPointerException("the configurable instance must no be null");
            }
            this.mConfigurable = configurable;
            this.setConfiguration(initialConfiguration);
        }

        @NotNull
        public TYPE set() {
            return this.mConfigurable.setConfiguration(this.buildConfiguration());
        }

        @NotNull
        public Builder<TYPE> with(@Nullable ChannelConfiguration configuration) {
            Log.Level logLevel;
            Log log;
            TimeDuration channelTimeout;
            int maxSize;
            InvocationConfiguration.OrderType orderType;
            InvocationConfiguration.TimeoutActionType timeoutActionType;
            TimeDuration readTimeout;
            if (configuration == null) {
                this.setConfiguration(DEFAULT_CONFIGURATION);
                return this;
            }
            Runner asyncRunner = configuration.mAsyncRunner;
            if (asyncRunner != null) {
                this.withAsyncRunner(asyncRunner);
            }
            if ((readTimeout = configuration.mReadTimeout) != null) {
                this.withReadTimeout(readTimeout);
            }
            if ((timeoutActionType = configuration.mTimeoutActionType) != null) {
                this.withReadTimeoutAction(timeoutActionType);
            }
            if ((orderType = configuration.mChannelOrderType) != null) {
                this.withChannelOrder(orderType);
            }
            if ((maxSize = configuration.mChannelMaxSize) != Integer.MIN_VALUE) {
                this.withChannelMaxSize(maxSize);
            }
            if ((channelTimeout = configuration.mChannelTimeout) != null) {
                this.withChannelTimeout(channelTimeout);
            }
            if ((log = configuration.mLog) != null) {
                this.withLog(log);
            }
            if ((logLevel = configuration.mLogLevel) != null) {
                this.withLogLevel(logLevel);
            }
            return this;
        }

        @NotNull
        public Builder<TYPE> withAsyncRunner(@Nullable Runner runner) {
            this.mAsyncRunner = runner;
            return this;
        }

        @NotNull
        public Builder<TYPE> withChannelMaxSize(int maxSize) {
            if (maxSize != Integer.MIN_VALUE && maxSize <= 0) {
                throw new IllegalArgumentException("the channel buffer size cannot be 0 or negative: " + maxSize);
            }
            this.mChannelMaxSize = maxSize;
            return this;
        }

        @NotNull
        public Builder<TYPE> withChannelOrder(@Nullable InvocationConfiguration.OrderType orderType) {
            this.mChannelOrderType = orderType;
            return this;
        }

        @NotNull
        public Builder<TYPE> withChannelTimeout(long timeout, @NotNull TimeUnit timeUnit) {
            return this.withChannelTimeout(TimeDuration.fromUnit(timeout, timeUnit));
        }

        @NotNull
        public Builder<TYPE> withChannelTimeout(@Nullable TimeDuration timeout) {
            this.mChannelTimeout = timeout;
            return this;
        }

        @NotNull
        public Builder<TYPE> withLog(@Nullable Log log) {
            this.mLog = log;
            return this;
        }

        @NotNull
        public Builder<TYPE> withLogLevel(@Nullable Log.Level level) {
            this.mLogLevel = level;
            return this;
        }

        @NotNull
        public Builder<TYPE> withReadTimeout(long timeout, @NotNull TimeUnit timeUnit) {
            return this.withReadTimeout(TimeDuration.fromUnit(timeout, timeUnit));
        }

        @NotNull
        public Builder<TYPE> withReadTimeout(@Nullable TimeDuration timeout) {
            this.mReadTimeout = timeout;
            return this;
        }

        @NotNull
        public Builder<TYPE> withReadTimeoutAction(@Nullable InvocationConfiguration.TimeoutActionType actionType) {
            this.mTimeoutActionType = actionType;
            return this;
        }

        @NotNull
        private ChannelConfiguration buildConfiguration() {
            return new ChannelConfiguration(this.mAsyncRunner, this.mReadTimeout, this.mTimeoutActionType, this.mChannelOrderType, this.mChannelMaxSize, this.mChannelTimeout, this.mLog, this.mLogLevel);
        }

        private void setConfiguration(@NotNull ChannelConfiguration configuration) {
            this.mAsyncRunner = configuration.mAsyncRunner;
            this.mReadTimeout = configuration.mReadTimeout;
            this.mTimeoutActionType = configuration.mTimeoutActionType;
            this.mChannelOrderType = configuration.mChannelOrderType;
            this.mChannelMaxSize = configuration.mChannelMaxSize;
            this.mChannelTimeout = configuration.mChannelTimeout;
            this.mLog = configuration.mLog;
            this.mLogLevel = configuration.mLogLevel;
        }

        static /* synthetic */ ChannelConfiguration access$100(Builder x0) {
            return x0.buildConfiguration();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Configurable<TYPE> {
        @NotNull
        public TYPE setConfiguration(@NotNull ChannelConfiguration var1);
    }
}

