/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.builder;

import com.github.dm.jrt.log.Log;
import com.github.dm.jrt.log.Logger;
import com.github.dm.jrt.runner.Runner;
import com.github.dm.jrt.util.TimeDuration;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InvocationConfiguration {
    public static final int DEFAULT = Integer.MIN_VALUE;
    private static final DefaultConfigurable sDefaultConfigurable = new DefaultConfigurable();
    public static final InvocationConfiguration DEFAULT_CONFIGURATION = Builder.access$100(InvocationConfiguration.builder());
    private final int mCoreInstances;
    private final int mInputMaxSize;
    private final OrderType mInputOrderType;
    private final TimeDuration mInputTimeout;
    private final Log mLog;
    private final Log.Level mLogLevel;
    private final int mMaxInstances;
    private final int mOutputMaxSize;
    private final OrderType mOutputOrderType;
    private final TimeDuration mOutputTimeout;
    private final int mPriority;
    private final TimeDuration mReadTimeout;
    private final Runner mRunner;
    private final TimeoutActionType mTimeoutActionType;

    private InvocationConfiguration(@Nullable Runner runner, int priority, int maxInstances, int coreInstances, @Nullable TimeDuration readTimeout, @Nullable TimeoutActionType actionType, @Nullable OrderType inputOrderType, int inputMaxSize, @Nullable TimeDuration inputTimeout, @Nullable OrderType outputOrderType, int outputMaxSize, @Nullable TimeDuration outputTimeout, @Nullable Log log, @Nullable Log.Level logLevel) {
        this.mRunner = runner;
        this.mPriority = priority;
        this.mMaxInstances = maxInstances;
        this.mCoreInstances = coreInstances;
        this.mReadTimeout = readTimeout;
        this.mTimeoutActionType = actionType;
        this.mInputOrderType = inputOrderType;
        this.mInputMaxSize = inputMaxSize;
        this.mInputTimeout = inputTimeout;
        this.mOutputOrderType = outputOrderType;
        this.mOutputMaxSize = outputMaxSize;
        this.mOutputTimeout = outputTimeout;
        this.mLog = log;
        this.mLogLevel = logLevel;
    }

    @NotNull
    public static Builder<InvocationConfiguration> builder() {
        return new Builder<InvocationConfiguration>(sDefaultConfigurable);
    }

    @NotNull
    public static Builder<InvocationConfiguration> builderFrom(@Nullable InvocationConfiguration initialConfiguration) {
        return initialConfiguration == null ? InvocationConfiguration.builder() : new Builder<InvocationConfiguration>(sDefaultConfigurable, initialConfiguration);
    }

    @NotNull
    public Builder<InvocationConfiguration> builderFrom() {
        return InvocationConfiguration.builderFrom(this);
    }

    public int getCoreInstancesOr(int valueIfNotSet) {
        int coreInstances = this.mCoreInstances;
        return coreInstances != Integer.MIN_VALUE ? coreInstances : valueIfNotSet;
    }

    public int getInputMaxSizeOr(int valueIfNotSet) {
        int inputMaxSize = this.mInputMaxSize;
        return inputMaxSize != Integer.MIN_VALUE ? inputMaxSize : valueIfNotSet;
    }

    public OrderType getInputOrderTypeOr(@Nullable OrderType valueIfNotSet) {
        OrderType inputOrderType = this.mInputOrderType;
        return inputOrderType != null ? inputOrderType : valueIfNotSet;
    }

    public TimeDuration getInputTimeoutOr(@Nullable TimeDuration valueIfNotSet) {
        TimeDuration inputTimeout = this.mInputTimeout;
        return inputTimeout != null ? inputTimeout : valueIfNotSet;
    }

    public Log.Level getLogLevelOr(@Nullable Log.Level valueIfNotSet) {
        Log.Level logLevel = this.mLogLevel;
        return logLevel != null ? logLevel : valueIfNotSet;
    }

    public Log getLogOr(@Nullable Log valueIfNotSet) {
        Log log = this.mLog;
        return log != null ? log : valueIfNotSet;
    }

    public int getMaxInstancesOr(int valueIfNotSet) {
        int maxInstances = this.mMaxInstances;
        return maxInstances != Integer.MIN_VALUE ? maxInstances : valueIfNotSet;
    }

    public int getOutputMaxSizeOr(int valueIfNotSet) {
        int outputMaxSize = this.mOutputMaxSize;
        return outputMaxSize != Integer.MIN_VALUE ? outputMaxSize : valueIfNotSet;
    }

    public OrderType getOutputOrderTypeOr(@Nullable OrderType valueIfNotSet) {
        OrderType outputOrderType = this.mOutputOrderType;
        return outputOrderType != null ? outputOrderType : valueIfNotSet;
    }

    public TimeDuration getOutputTimeoutOr(@Nullable TimeDuration valueIfNotSet) {
        TimeDuration outputTimeout = this.mOutputTimeout;
        return outputTimeout != null ? outputTimeout : valueIfNotSet;
    }

    public int getPriorityOr(int valueIfNotSet) {
        int priority = this.mPriority;
        return priority != Integer.MIN_VALUE ? priority : valueIfNotSet;
    }

    public TimeoutActionType getReadTimeoutActionOr(@Nullable TimeoutActionType valueIfNotSet) {
        TimeoutActionType timeoutActionType = this.mTimeoutActionType;
        return timeoutActionType != null ? timeoutActionType : valueIfNotSet;
    }

    public TimeDuration getReadTimeoutOr(@Nullable TimeDuration valueIfNotSet) {
        TimeDuration readTimeout = this.mReadTimeout;
        return readTimeout != null ? readTimeout : valueIfNotSet;
    }

    public Runner getRunnerOr(@Nullable Runner valueIfNotSet) {
        Runner runner = this.mRunner;
        return runner != null ? runner : valueIfNotSet;
    }

    public int hashCode() {
        int result = this.mRunner != null ? this.mRunner.hashCode() : 0;
        result = 31 * result + this.mCoreInstances;
        result = 31 * result + this.mInputMaxSize;
        result = 31 * result + (this.mInputOrderType != null ? this.mInputOrderType.hashCode() : 0);
        result = 31 * result + (this.mInputTimeout != null ? this.mInputTimeout.hashCode() : 0);
        result = 31 * result + (this.mLog != null ? this.mLog.hashCode() : 0);
        result = 31 * result + (this.mLogLevel != null ? this.mLogLevel.hashCode() : 0);
        result = 31 * result + this.mMaxInstances;
        result = 31 * result + this.mOutputMaxSize;
        result = 31 * result + (this.mOutputOrderType != null ? this.mOutputOrderType.hashCode() : 0);
        result = 31 * result + (this.mOutputTimeout != null ? this.mOutputTimeout.hashCode() : 0);
        result = 31 * result + this.mPriority;
        result = 31 * result + (this.mReadTimeout != null ? this.mReadTimeout.hashCode() : 0);
        result = 31 * result + (this.mTimeoutActionType != null ? this.mTimeoutActionType.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvocationConfiguration)) {
            return false;
        }
        InvocationConfiguration that = (InvocationConfiguration)o;
        if (this.mCoreInstances != that.mCoreInstances) {
            return false;
        }
        if (this.mInputMaxSize != that.mInputMaxSize) {
            return false;
        }
        if (this.mMaxInstances != that.mMaxInstances) {
            return false;
        }
        if (this.mOutputMaxSize != that.mOutputMaxSize) {
            return false;
        }
        if (this.mPriority != that.mPriority) {
            return false;
        }
        if (this.mRunner != null ? !this.mRunner.equals(that.mRunner) : that.mRunner != null) {
            return false;
        }
        if (this.mInputOrderType != that.mInputOrderType) {
            return false;
        }
        if (this.mInputTimeout != null ? !this.mInputTimeout.equals(that.mInputTimeout) : that.mInputTimeout != null) {
            return false;
        }
        if (this.mLog != null ? !this.mLog.equals(that.mLog) : that.mLog != null) {
            return false;
        }
        if (this.mLogLevel != that.mLogLevel) {
            return false;
        }
        if (this.mOutputOrderType != that.mOutputOrderType) {
            return false;
        }
        if (this.mOutputTimeout != null ? !this.mOutputTimeout.equals(that.mOutputTimeout) : that.mOutputTimeout != null) {
            return false;
        }
        if (this.mReadTimeout != null ? !this.mReadTimeout.equals(that.mReadTimeout) : that.mReadTimeout != null) {
            return false;
        }
        return this.mTimeoutActionType == that.mTimeoutActionType;
    }

    public String toString() {
        return "InvocationConfiguration{mRunner=" + this.mRunner + ", mCoreInstances=" + this.mCoreInstances + ", mInputMaxSize=" + this.mInputMaxSize + ", mInputOrderType=" + (Object)((Object)this.mInputOrderType) + ", mInputTimeout=" + this.mInputTimeout + ", mLog=" + this.mLog + ", mLogLevel=" + (Object)((Object)this.mLogLevel) + ", mMaxInstances=" + this.mMaxInstances + ", mOutputMaxSize=" + this.mOutputMaxSize + ", mOutputOrderType=" + (Object)((Object)this.mOutputOrderType) + ", mOutputTimeout=" + this.mOutputTimeout + ", mPriority=" + this.mPriority + ", mReadTimeout=" + this.mReadTimeout + ", mTimeoutActionType=" + (Object)((Object)this.mTimeoutActionType) + '}';
    }

    @NotNull
    public Logger newLogger(@NotNull Object context) {
        return Logger.newLogger(this.getLogOr(null), this.getLogLevelOr(null), context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultConfigurable
    implements Configurable<InvocationConfiguration> {
        private DefaultConfigurable() {
        }

        @Override
        @NotNull
        public InvocationConfiguration setConfiguration(@NotNull InvocationConfiguration configuration) {
            return configuration;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder<TYPE> {
        private final Configurable<? extends TYPE> mConfigurable;
        private int mCoreInstances;
        private int mInputMaxSize;
        private OrderType mInputOrderType;
        private TimeDuration mInputTimeout;
        private Log mLog;
        private Log.Level mLogLevel;
        private int mMaxInstances;
        private int mOutputMaxSize;
        private OrderType mOutputOrderType;
        private TimeDuration mOutputTimeout;
        private int mPriority;
        private TimeDuration mReadTimeout;
        private Runner mRunner;
        private TimeoutActionType mTimeoutActionType;

        public Builder(@NotNull Configurable<? extends TYPE> configurable) {
            if (configurable == null) {
                throw new NullPointerException("the configurable instance must no be null");
            }
            this.mConfigurable = configurable;
            this.mPriority = Integer.MIN_VALUE;
            this.mMaxInstances = Integer.MIN_VALUE;
            this.mCoreInstances = Integer.MIN_VALUE;
            this.mInputMaxSize = Integer.MIN_VALUE;
            this.mOutputMaxSize = Integer.MIN_VALUE;
        }

        public Builder(@NotNull Configurable<? extends TYPE> configurable, @NotNull InvocationConfiguration initialConfiguration) {
            if (configurable == null) {
                throw new NullPointerException("the configurable instance must no be null");
            }
            this.mConfigurable = configurable;
            this.setConfiguration(initialConfiguration);
        }

        @NotNull
        public TYPE set() {
            return this.mConfigurable.setConfiguration(this.buildConfiguration());
        }

        @NotNull
        public Builder<TYPE> with(@Nullable InvocationConfiguration configuration) {
            if (configuration == null) {
                this.setConfiguration(DEFAULT_CONFIGURATION);
                return this;
            }
            this.applyBaseConfiguration(configuration);
            this.applyChannelConfiguration(configuration);
            this.applyLogConfiguration(configuration);
            return this;
        }

        @NotNull
        public Builder<TYPE> withCoreInstances(int coreInstances) {
            if (coreInstances != Integer.MIN_VALUE && coreInstances < 0) {
                throw new IllegalArgumentException("the maximum number of retained instances cannot be negative: " + coreInstances);
            }
            this.mCoreInstances = coreInstances;
            return this;
        }

        @NotNull
        public Builder<TYPE> withInputMaxSize(int inputMaxSize) {
            if (inputMaxSize != Integer.MIN_VALUE && inputMaxSize <= 0) {
                throw new IllegalArgumentException("the input buffer size cannot be 0 or negative: " + inputMaxSize);
            }
            this.mInputMaxSize = inputMaxSize;
            return this;
        }

        @NotNull
        public Builder<TYPE> withInputOrder(@Nullable OrderType orderType) {
            this.mInputOrderType = orderType;
            return this;
        }

        @NotNull
        public Builder<TYPE> withInputTimeout(long timeout, @NotNull TimeUnit timeUnit) {
            return this.withInputTimeout(TimeDuration.fromUnit(timeout, timeUnit));
        }

        @NotNull
        public Builder<TYPE> withInputTimeout(@Nullable TimeDuration timeout) {
            this.mInputTimeout = timeout;
            return this;
        }

        @NotNull
        public Builder<TYPE> withLog(@Nullable Log log) {
            this.mLog = log;
            return this;
        }

        @NotNull
        public Builder<TYPE> withLogLevel(@Nullable Log.Level level) {
            this.mLogLevel = level;
            return this;
        }

        @NotNull
        public Builder<TYPE> withMaxInstances(int maxInstances) {
            if (maxInstances != Integer.MIN_VALUE && maxInstances < 1) {
                throw new IllegalArgumentException("the maximum number of concurrently running instances cannot be less than 1: " + maxInstances);
            }
            this.mMaxInstances = maxInstances;
            return this;
        }

        @NotNull
        public Builder<TYPE> withOutputMaxSize(int outputMaxSize) {
            if (outputMaxSize != Integer.MIN_VALUE && outputMaxSize <= 0) {
                throw new IllegalArgumentException("the output buffer size cannot be 0 or negative: " + outputMaxSize);
            }
            this.mOutputMaxSize = outputMaxSize;
            return this;
        }

        @NotNull
        public Builder<TYPE> withOutputOrder(@Nullable OrderType orderType) {
            this.mOutputOrderType = orderType;
            return this;
        }

        @NotNull
        public Builder<TYPE> withOutputTimeout(long timeout, @NotNull TimeUnit timeUnit) {
            return this.withOutputTimeout(TimeDuration.fromUnit(timeout, timeUnit));
        }

        @NotNull
        public Builder<TYPE> withOutputTimeout(@Nullable TimeDuration timeout) {
            this.mOutputTimeout = timeout;
            return this;
        }

        @NotNull
        public Builder<TYPE> withPriority(int priority) {
            this.mPriority = priority;
            return this;
        }

        @NotNull
        public Builder<TYPE> withReadTimeout(long timeout, @NotNull TimeUnit timeUnit) {
            return this.withReadTimeout(TimeDuration.fromUnit(timeout, timeUnit));
        }

        @NotNull
        public Builder<TYPE> withReadTimeout(@Nullable TimeDuration timeout) {
            this.mReadTimeout = timeout;
            return this;
        }

        @NotNull
        public Builder<TYPE> withReadTimeoutAction(@Nullable TimeoutActionType actionType) {
            this.mTimeoutActionType = actionType;
            return this;
        }

        @NotNull
        public Builder<TYPE> withRunner(@Nullable Runner runner) {
            this.mRunner = runner;
            return this;
        }

        private void applyBaseConfiguration(@NotNull InvocationConfiguration configuration) {
            TimeoutActionType timeoutActionType;
            TimeDuration readTimeout;
            int coreInvocations;
            int maxInvocations;
            int priority;
            Runner runner = configuration.mRunner;
            if (runner != null) {
                this.withRunner(runner);
            }
            if ((priority = configuration.mPriority) != Integer.MIN_VALUE) {
                this.withPriority(priority);
            }
            if ((maxInvocations = configuration.mMaxInstances) != Integer.MIN_VALUE) {
                this.withMaxInstances(maxInvocations);
            }
            if ((coreInvocations = configuration.mCoreInstances) != Integer.MIN_VALUE) {
                this.withCoreInstances(coreInvocations);
            }
            if ((readTimeout = configuration.mReadTimeout) != null) {
                this.withReadTimeout(readTimeout);
            }
            if ((timeoutActionType = configuration.mTimeoutActionType) != null) {
                this.withReadTimeoutAction(timeoutActionType);
            }
        }

        private void applyChannelConfiguration(@NotNull InvocationConfiguration configuration) {
            TimeDuration outputTimeout;
            int outputSize;
            OrderType outputOrderType;
            TimeDuration inputTimeout;
            int inputSize;
            OrderType inputOrderType = configuration.mInputOrderType;
            if (inputOrderType != null) {
                this.withInputOrder(inputOrderType);
            }
            if ((inputSize = configuration.mInputMaxSize) != Integer.MIN_VALUE) {
                this.withInputMaxSize(inputSize);
            }
            if ((inputTimeout = configuration.mInputTimeout) != null) {
                this.withInputTimeout(inputTimeout);
            }
            if ((outputOrderType = configuration.mOutputOrderType) != null) {
                this.withOutputOrder(outputOrderType);
            }
            if ((outputSize = configuration.mOutputMaxSize) != Integer.MIN_VALUE) {
                this.withOutputMaxSize(outputSize);
            }
            if ((outputTimeout = configuration.mOutputTimeout) != null) {
                this.withOutputTimeout(outputTimeout);
            }
        }

        private void applyLogConfiguration(@NotNull InvocationConfiguration configuration) {
            Log.Level logLevel;
            Log log = configuration.mLog;
            if (log != null) {
                this.withLog(log);
            }
            if ((logLevel = configuration.mLogLevel) != null) {
                this.withLogLevel(logLevel);
            }
        }

        @NotNull
        private InvocationConfiguration buildConfiguration() {
            return new InvocationConfiguration(this.mRunner, this.mPriority, this.mMaxInstances, this.mCoreInstances, this.mReadTimeout, this.mTimeoutActionType, this.mInputOrderType, this.mInputMaxSize, this.mInputTimeout, this.mOutputOrderType, this.mOutputMaxSize, this.mOutputTimeout, this.mLog, this.mLogLevel);
        }

        private void setConfiguration(@NotNull InvocationConfiguration configuration) {
            this.mRunner = configuration.mRunner;
            this.mPriority = configuration.mPriority;
            this.mMaxInstances = configuration.mMaxInstances;
            this.mCoreInstances = configuration.mCoreInstances;
            this.mReadTimeout = configuration.mReadTimeout;
            this.mTimeoutActionType = configuration.mTimeoutActionType;
            this.mInputOrderType = configuration.mInputOrderType;
            this.mInputMaxSize = configuration.mInputMaxSize;
            this.mInputTimeout = configuration.mInputTimeout;
            this.mOutputOrderType = configuration.mOutputOrderType;
            this.mOutputMaxSize = configuration.mOutputMaxSize;
            this.mOutputTimeout = configuration.mOutputTimeout;
            this.mLog = configuration.mLog;
            this.mLogLevel = configuration.mLogLevel;
        }

        static /* synthetic */ InvocationConfiguration access$100(Builder x0) {
            return x0.buildConfiguration();
        }
    }

    public static interface NotAgingPriority {
        public static final int HIGHEST_PRIORITY = Integer.MAX_VALUE;
        public static final int HIGH_PRIORITY = 0x3FFFFFFF;
        public static final int LOWEST_PRIORITY = -2147483647;
        public static final int LOW_PRIORITY = -1073741823;
        public static final int NORMAL_PRIORITY = 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Configurable<TYPE> {
        @NotNull
        public TYPE setConfiguration(@NotNull InvocationConfiguration var1);
    }

    public static interface AgingPriority {
        public static final int HIGH_PRIORITY = 10;
        public static final int HIGHEST_PRIORITY = 20;
        public static final int LOWEST_PRIORITY = -20;
        public static final int LOW_PRIORITY = -10;
        public static final int NORMAL_PRIORITY = 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimeoutActionType {
        THROW,
        EXIT,
        ABORT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OrderType {
        BY_CALL,
        BY_DELAY,
        BY_CHANCE;

    }
}

