/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProxyConfiguration {
    private static final DefaultConfigurable sDefaultConfigurable = new DefaultConfigurable();
    public static final ProxyConfiguration DEFAULT_CONFIGURATION = Builder.access$100(ProxyConfiguration.builder());
    private final List<String> mFieldNames;

    private ProxyConfiguration(@Nullable List<String> fieldNames) {
        this.mFieldNames = fieldNames;
    }

    @NotNull
    public static Builder<ProxyConfiguration> builder() {
        return new Builder<ProxyConfiguration>(sDefaultConfigurable);
    }

    @NotNull
    public static Builder<ProxyConfiguration> builderFrom(@Nullable ProxyConfiguration initialConfiguration) {
        return initialConfiguration == null ? ProxyConfiguration.builder() : new Builder<ProxyConfiguration>(sDefaultConfigurable, initialConfiguration);
    }

    @NotNull
    public Builder<ProxyConfiguration> builderFrom() {
        return ProxyConfiguration.builderFrom(this);
    }

    public List<String> getSharedFieldsOr(@Nullable List<String> valueIfNotSet) {
        List<String> fieldNames = this.mFieldNames;
        return fieldNames != null ? fieldNames : valueIfNotSet;
    }

    public int hashCode() {
        return this.mFieldNames != null ? this.mFieldNames.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProxyConfiguration)) {
            return false;
        }
        ProxyConfiguration that = (ProxyConfiguration)o;
        return !(this.mFieldNames == null ? that.mFieldNames != null : !this.mFieldNames.equals(that.mFieldNames));
    }

    public String toString() {
        return "ProxyConfiguration{mFieldNames='" + this.mFieldNames + '\'' + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultConfigurable
    implements Configurable<ProxyConfiguration> {
        private DefaultConfigurable() {
        }

        @Override
        @NotNull
        public ProxyConfiguration setConfiguration(@NotNull ProxyConfiguration configuration) {
            return configuration;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder<TYPE> {
        private final Configurable<? extends TYPE> mConfigurable;
        private List<String> mFieldNames;

        public Builder(@NotNull Configurable<? extends TYPE> configurable) {
            if (configurable == null) {
                throw new NullPointerException("the configurable instance must no be null");
            }
            this.mConfigurable = configurable;
        }

        public Builder(@NotNull Configurable<? extends TYPE> configurable, @NotNull ProxyConfiguration initialConfiguration) {
            if (configurable == null) {
                throw new NullPointerException("the configurable instance must no be null");
            }
            this.mConfigurable = configurable;
            this.setConfiguration(initialConfiguration);
        }

        @NotNull
        public TYPE set() {
            return this.mConfigurable.setConfiguration(this.buildConfiguration());
        }

        @NotNull
        public Builder<TYPE> with(@Nullable ProxyConfiguration configuration) {
            if (configuration == null) {
                this.setConfiguration(DEFAULT_CONFIGURATION);
                return this;
            }
            List fieldNames = configuration.mFieldNames;
            if (fieldNames != null) {
                this.withSharedFields(fieldNames);
            }
            return this;
        }

        @NotNull
        public Builder<TYPE> withSharedFields() {
            this.mFieldNames = Collections.emptyList();
            return this;
        }

        @NotNull
        public Builder<TYPE> withSharedFields(String ... fieldNames) {
            this.mFieldNames = fieldNames != null ? Arrays.asList(fieldNames) : null;
            return this;
        }

        @NotNull
        public Builder<TYPE> withSharedFields(@Nullable List<String> fieldNames) {
            this.mFieldNames = fieldNames != null ? Collections.unmodifiableList(new ArrayList<String>(fieldNames)) : null;
            return this;
        }

        @NotNull
        private ProxyConfiguration buildConfiguration() {
            return new ProxyConfiguration(this.mFieldNames);
        }

        private void setConfiguration(@NotNull ProxyConfiguration configuration) {
            this.mFieldNames = configuration.mFieldNames;
        }

        static /* synthetic */ ProxyConfiguration access$100(Builder x0) {
            return x0.buildConfiguration();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Configurable<TYPE> {
        @NotNull
        public TYPE setConfiguration(@NotNull ProxyConfiguration var1);
    }
}

