/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.core;

import com.github.dm.jrt.builder.InvocationConfiguration;
import com.github.dm.jrt.channel.InvocationChannel;
import com.github.dm.jrt.channel.ResultChannel;
import com.github.dm.jrt.core.DefaultInvocationChannel;
import com.github.dm.jrt.core.InvocationManager;
import com.github.dm.jrt.core.InvocationObserver;
import com.github.dm.jrt.core.SimpleQueue;
import com.github.dm.jrt.invocation.Invocation;
import com.github.dm.jrt.invocation.InvocationDeadlockException;
import com.github.dm.jrt.invocation.InvocationInterruptedException;
import com.github.dm.jrt.invocation.TemplateInvocation;
import com.github.dm.jrt.log.Logger;
import com.github.dm.jrt.routine.Routine;
import com.github.dm.jrt.routine.TemplateRoutine;
import com.github.dm.jrt.runner.Runner;
import com.github.dm.jrt.runner.Runners;
import com.github.dm.jrt.runner.TemplateExecution;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRoutine<IN, OUT>
extends TemplateRoutine<IN, OUT> {
    private static final int DEFAULT_CORE_INVOCATIONS = 10;
    private static final int DEFAULT_MAX_INVOCATIONS = Integer.MAX_VALUE;
    private final LinkedList<Invocation<IN, OUT>> mAsyncInvocations = new LinkedList();
    private final Runner mAsyncRunner;
    private final InvocationConfiguration mConfiguration;
    private final int mCoreInvocations;
    private final Logger mLogger;
    private final int mMaxInvocations;
    private final Object mMutex = new Object();
    private final SimpleQueue<InvocationObserver<IN, OUT>> mObservers = new SimpleQueue();
    private final Object mParallelMutex = new Object();
    private final LinkedList<Invocation<IN, OUT>> mSyncInvocations = new LinkedList();
    private final Runner mSyncRunner;
    private volatile DefaultInvocationManager mAsyncManager;
    private AbstractRoutine<IN, OUT> mParallelRoutine;
    private int mRunningCount;
    private volatile DefaultInvocationManager mSyncManager;

    protected AbstractRoutine(@NotNull InvocationConfiguration configuration) {
        this.mConfiguration = configuration;
        this.mSyncRunner = Runners.syncRunner();
        int priority = configuration.getPriorityOr(Integer.MIN_VALUE);
        Runner asyncRunner = configuration.getRunnerOr(Runners.sharedRunner());
        this.mAsyncRunner = priority != Integer.MIN_VALUE ? Runners.priorityRunner(asyncRunner).getRunner(priority) : asyncRunner;
        this.mMaxInvocations = configuration.getMaxInstancesOr(Integer.MAX_VALUE);
        this.mCoreInvocations = configuration.getCoreInstancesOr(10);
        this.mLogger = configuration.newLogger(this);
        this.mLogger.dbg("building routine with configuration: %s", (Object)configuration);
    }

    private AbstractRoutine(@NotNull InvocationConfiguration configuration, @NotNull Runner syncRunner, @NotNull Runner asyncRunner, @NotNull Logger logger) {
        this.mConfiguration = configuration;
        this.mSyncRunner = syncRunner;
        this.mAsyncRunner = asyncRunner;
        this.mMaxInvocations = Integer.MAX_VALUE;
        this.mCoreInvocations = 10;
        this.mLogger = logger.subContextLogger(this);
    }

    @Override
    @NotNull
    public InvocationChannel<IN, OUT> asyncInvoke() {
        return this.invoke(InvocationType.ASYNC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public InvocationChannel<IN, OUT> parallelInvoke() {
        Object object = this.mParallelMutex;
        synchronized (object) {
            this.mLogger.dbg("invoking routine: parallel");
            if (this.mParallelRoutine == null) {
                this.mParallelRoutine = new AbstractRoutine<IN, OUT>(this.mConfiguration, this.mSyncRunner, this.mAsyncRunner, this.mLogger){

                    @Override
                    @NotNull
                    protected Invocation<IN, OUT> newInvocation(@NotNull InvocationType type) {
                        return new ParallelInvocation(AbstractRoutine.this);
                    }
                };
            }
        }
        return this.mParallelRoutine.asyncInvoke();
    }

    @Override
    @NotNull
    public InvocationChannel<IN, OUT> syncInvoke() {
        return this.invoke(InvocationType.SYNC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge() {
        Object object = this.mMutex;
        synchronized (object) {
            Logger logger = this.mLogger;
            LinkedList<Invocation<IN, OUT>> syncInvocations = this.mSyncInvocations;
            for (Invocation invocation : syncInvocations) {
                try {
                    invocation.onDestroy();
                }
                catch (Throwable throwable) {
                    InvocationInterruptedException.throwIfInterrupt(throwable);
                    logger.wrn(throwable, "ignoring exception while destroying invocation instance");
                }
            }
            syncInvocations.clear();
            LinkedList<Invocation<IN, OUT>> asyncInvocations = this.mAsyncInvocations;
            for (Invocation invocation : asyncInvocations) {
                try {
                    invocation.onDestroy();
                }
                catch (Throwable t) {
                    InvocationInterruptedException.throwIfInterrupt(t);
                    logger.wrn(t, "ignoring exception while destroying invocation instance");
                }
            }
            asyncInvocations.clear();
        }
    }

    @NotNull
    protected Invocation<IN, OUT> convertInvocation(@NotNull Invocation<IN, OUT> invocation, @NotNull InvocationType type) {
        return invocation;
    }

    @NotNull
    protected InvocationConfiguration getConfiguration() {
        return this.mConfiguration;
    }

    @NotNull
    protected Logger getLogger() {
        return this.mLogger;
    }

    @NotNull
    protected abstract Invocation<IN, OUT> newInvocation(@NotNull InvocationType var1);

    @NotNull
    private DefaultInvocationManager getInvocationManager(@NotNull InvocationType type) {
        if (type == InvocationType.ASYNC) {
            if (this.mAsyncManager == null) {
                this.mAsyncManager = new DefaultInvocationManager(type, this.mAsyncRunner, this.mAsyncInvocations, this.mSyncInvocations);
            }
            return this.mAsyncManager;
        }
        if (this.mSyncManager == null) {
            this.mSyncManager = new DefaultInvocationManager(type, this.mSyncRunner, this.mSyncInvocations, this.mAsyncInvocations);
        }
        return this.mSyncManager;
    }

    @NotNull
    private InvocationChannel<IN, OUT> invoke(@NotNull InvocationType type) {
        Logger logger = this.mLogger;
        logger.dbg("invoking routine: %s", (Object)type);
        Runner runner = type == InvocationType.ASYNC ? this.mAsyncRunner : this.mSyncRunner;
        return new DefaultInvocationChannel(this.mConfiguration, this.getInvocationManager(type), runner, logger);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultInvocationManager
    implements InvocationManager<IN, OUT> {
        private final CreateExecution mCreateExecution;
        private final LinkedList<Invocation<IN, OUT>> mFallbackInvocations;
        private final InvocationType mInvocationType;
        private final LinkedList<Invocation<IN, OUT>> mPrimaryInvocations;
        private final Runner mRunner;

        private DefaultInvocationManager(@NotNull InvocationType type, @NotNull Runner runner, @NotNull LinkedList<Invocation<IN, OUT>> primaryInvocations, LinkedList<Invocation<IN, OUT>> fallbackInvocations) {
            this.mInvocationType = type;
            this.mRunner = runner;
            this.mPrimaryInvocations = primaryInvocations;
            this.mFallbackInvocations = fallbackInvocations;
            this.mCreateExecution = new CreateExecution(this);
        }

        @Override
        public void create(@NotNull InvocationObserver<IN, OUT> observer) {
            this.create(observer, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void discard(@NotNull Invocation<IN, OUT> invocation) {
            boolean hasDelayed;
            Object object = AbstractRoutine.this.mMutex;
            synchronized (object) {
                Logger logger = AbstractRoutine.this.mLogger;
                logger.wrn("discarding invocation instance after error: %s", (Object)invocation);
                try {
                    invocation.onDestroy();
                }
                catch (Throwable t) {
                    InvocationInterruptedException.throwIfInterrupt(t);
                    logger.wrn(t, "ignoring exception while destroying invocation instance");
                }
                hasDelayed = !AbstractRoutine.this.mObservers.isEmpty();
                --AbstractRoutine.this.mRunningCount;
            }
            if (hasDelayed) {
                this.mRunner.run(this.mCreateExecution, 0L, TimeUnit.MILLISECONDS);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void recycle(@NotNull Invocation<IN, OUT> invocation) {
            boolean hasDelayed;
            Object object = AbstractRoutine.this.mMutex;
            synchronized (object) {
                Logger logger = AbstractRoutine.this.mLogger;
                int coreInvocations = AbstractRoutine.this.mCoreInvocations;
                LinkedList primaryInvocations = this.mPrimaryInvocations;
                LinkedList fallbackInvocations = this.mFallbackInvocations;
                if (primaryInvocations.size() + fallbackInvocations.size() < coreInvocations) {
                    logger.dbg("recycling %s invocation instance [%d/%d]: %s", (Object)this.mInvocationType, (Object)(primaryInvocations.size() + 1), (Object)coreInvocations, (Object)invocation);
                    primaryInvocations.add(invocation);
                } else {
                    logger.wrn("discarding %s invocation instance [%d/%d]: %s", (Object)this.mInvocationType, (Object)coreInvocations, (Object)coreInvocations, (Object)invocation);
                    try {
                        invocation.onDestroy();
                    }
                    catch (Throwable t) {
                        InvocationInterruptedException.throwIfInterrupt(t);
                        logger.wrn(t, "ignoring exception while destroying invocation instance");
                    }
                }
                hasDelayed = !AbstractRoutine.this.mObservers.isEmpty();
                --AbstractRoutine.this.mRunningCount;
            }
            if (hasDelayed) {
                this.mRunner.run(this.mCreateExecution, 0L, TimeUnit.MILLISECONDS);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void create(@Nullable InvocationObserver<IN, OUT> observer, boolean isDelayed) {
            InvocationObserver invocationObserver = observer;
            try {
                InvocationDeadlockException error = null;
                Invocation invocation = null;
                Object object = AbstractRoutine.this.mMutex;
                synchronized (object) {
                    SimpleQueue observers = AbstractRoutine.this.mObservers;
                    if (isDelayed) {
                        if (observers.isEmpty()) {
                            return;
                        }
                        invocationObserver = (InvocationObserver)observers.removeFirst();
                    }
                    if (isDelayed || AbstractRoutine.this.mRunningCount < AbstractRoutine.this.mMaxInvocations + observers.size()) {
                        InvocationType invocationType = this.mInvocationType;
                        int coreInvocations = AbstractRoutine.this.mCoreInvocations;
                        LinkedList invocations = this.mPrimaryInvocations;
                        if (!invocations.isEmpty()) {
                            invocation = invocations.removeFirst();
                            AbstractRoutine.this.mLogger.dbg("reusing %s invocation instance [%d/%d]: %s", (Object)invocationType, (Object)(invocations.size() + 1), (Object)coreInvocations, (Object)invocation);
                        } else {
                            LinkedList fallbackInvocations = this.mFallbackInvocations;
                            if (!fallbackInvocations.isEmpty()) {
                                Invocation convertInvocation = fallbackInvocations.removeFirst();
                                AbstractRoutine.this.mLogger.dbg("converting %s invocation instance [%d/%d]: %s", (Object)invocationType, (Object)(invocations.size() + 1), (Object)coreInvocations, (Object)convertInvocation);
                                invocation = AbstractRoutine.this.convertInvocation(convertInvocation, invocationType);
                            } else {
                                AbstractRoutine.this.mLogger.dbg("creating %s invocation instance [1/%d]", (Object)invocationType, (Object)coreInvocations);
                                invocation = AbstractRoutine.this.newInvocation(invocationType);
                            }
                        }
                        if (invocation != null) {
                            ++AbstractRoutine.this.mRunningCount;
                        }
                    } else if (this.mInvocationType == InvocationType.SYNC) {
                        error = new InvocationDeadlockException("cannot wait for invocation instances on a synchronous runner thread\nTry increasing the max number of instances");
                    } else {
                        observers.add(invocationObserver);
                        return;
                    }
                }
                if (invocation != null) {
                    invocationObserver.onCreate(invocation);
                } else {
                    invocationObserver.onError(error != null ? error : new NullPointerException("null invocation returned"));
                }
            }
            catch (InvocationInterruptedException e) {
                throw e;
            }
            catch (Throwable t) {
                AbstractRoutine.this.mLogger.err(t, "error while creating new invocation instance", (Object)AbstractRoutine.this.mMaxInvocations);
                invocationObserver.onError(t);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CreateExecution
    extends TemplateExecution {
        private final DefaultInvocationManager mManager;

        private CreateExecution(DefaultInvocationManager invocationManager) {
            this.mManager = invocationManager;
        }

        @Override
        public void run() {
            this.mManager.create(null, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParallelInvocation<IN, OUT>
    extends TemplateInvocation<IN, OUT> {
        private final Routine<IN, OUT> mRoutine;
        private boolean mHasInputs;

        private ParallelInvocation(@NotNull Routine<IN, OUT> routine) {
            this.mRoutine = routine;
        }

        @Override
        public void onInitialize() {
            this.mHasInputs = false;
        }

        @Override
        public void onInput(IN input, @NotNull ResultChannel<OUT> result) {
            this.mHasInputs = true;
            result.pass(this.mRoutine.asyncCall(input));
        }

        @Override
        public void onResult(@NotNull ResultChannel<OUT> result) {
            if (!this.mHasInputs) {
                result.pass(this.mRoutine.asyncCall());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum InvocationType {
        SYNC,
        ASYNC;

    }
}

