/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.core;

import com.github.dm.jrt.channel.Channel;
import com.github.dm.jrt.channel.IOChannel;
import com.github.dm.jrt.util.WeakIdentityHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteChannel {
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    public static final int DEFAULT_POOL_SIZE = 16;
    private static final int DEFAULT_MEM_SIZE = 262144;
    private final LinkedList<ByteBuffer> mBufferPool = new LinkedList();
    private final int mCorePoolSize;
    private final int mDataBufferSize;
    private final WeakIdentityHashMap<Channel.InputChannel<? super ByteBuffer>, BufferOutputStream> mStreams = new WeakIdentityHashMap();

    private ByteChannel(int dataBufferSize, int corePoolSize) {
        if (dataBufferSize < 1) {
            throw new IllegalArgumentException("the data buffer size must be greater than 0");
        }
        this.mCorePoolSize = corePoolSize;
        this.mDataBufferSize = dataBufferSize;
    }

    @NotNull
    public static ByteChannel byteChannel() {
        return new ByteChannel(16384, 16);
    }

    @NotNull
    public static ByteChannel byteChannel(int dataBufferSize) {
        return new ByteChannel(dataBufferSize, 262144 / Math.max(dataBufferSize, 1));
    }

    @NotNull
    public static ByteChannel byteChannel(int dataBufferSize, int corePoolSize) {
        return new ByteChannel(dataBufferSize, corePoolSize);
    }

    @NotNull
    public static BufferInputStream inputStream(@NotNull ByteBuffer buffer) {
        return buffer.getStream();
    }

    @NotNull
    public static BufferInputStream inputStream(ByteBuffer ... buffers) {
        return new MultiBufferInputStream(buffers);
    }

    @NotNull
    public static BufferInputStream inputStream(@NotNull List<ByteBuffer> buffers) {
        return new MultiBufferInputStream(buffers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public BufferOutputStream passTo(@NotNull Channel.InputChannel<? super ByteBuffer> channel) {
        BufferOutputStream stream;
        WeakIdentityHashMap<Channel.InputChannel<? super ByteBuffer>, BufferOutputStream> weakIdentityHashMap = this.mStreams;
        synchronized (weakIdentityHashMap) {
            WeakIdentityHashMap<Channel.InputChannel<? super ByteBuffer>, BufferOutputStream> streams = this.mStreams;
            stream = streams.get(channel);
            if (stream == null) {
                stream = new DefaultBufferOutputStream(channel);
                streams.put(channel, stream);
            }
        }
        return stream;
    }

    @NotNull
    public BufferOutputStream passTo(@NotNull IOChannel<? super ByteBuffer, ?> channel) {
        return new IOBufferOutputStream(this.passTo(channel.asInput()), channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ByteBuffer acquire() {
        ByteBuffer buffer = null;
        LinkedList<ByteBuffer> linkedList = this.mBufferPool;
        synchronized (linkedList) {
            LinkedList<ByteBuffer> bufferPool = this.mBufferPool;
            if (!bufferPool.isEmpty()) {
                buffer = bufferPool.removeFirst();
            }
        }
        if (buffer != null) {
            return buffer.unlock();
        }
        return new ByteBuffer(this.mDataBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(@NotNull ByteBuffer buffer) {
        LinkedList<ByteBuffer> linkedList = this.mBufferPool;
        synchronized (linkedList) {
            LinkedList<ByteBuffer> bufferPool = this.mBufferPool;
            if (bufferPool.size() < this.mCorePoolSize) {
                bufferPool.add(buffer);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultBufferOutputStream
    extends BufferOutputStream {
        private final Channel.InputChannel<? super ByteBuffer> mChannel;
        private final Object mMutex = new Object();
        private ByteBuffer mBuffer;
        private boolean mIsClosed;
        private int mOffset;

        private DefaultBufferOutputStream(Channel.InputChannel<? super ByteBuffer> channel) {
            if (channel == null) {
                throw new NullPointerException("the input channel must not be null");
            }
            this.mChannel = channel;
        }

        @NotNull
        private ByteBuffer getBuffer() {
            ByteBuffer byteBuffer = this.mBuffer;
            if (byteBuffer != null) {
                return byteBuffer;
            }
            this.mBuffer = ByteChannel.this.acquire();
            return this.mBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(@NotNull InputStream in) throws IOException {
            boolean isPass;
            int size;
            int read;
            ByteBuffer byteBuffer;
            Object object = this.mMutex;
            synchronized (object) {
                int length;
                int offset;
                if (this.mIsClosed) {
                    throw new IOException("cannot write into a closed output stream");
                }
                byteBuffer = this.getBuffer();
                byte[] buffer = byteBuffer.writeBuffer();
                read = in.read(buffer, offset = this.mOffset, (length = buffer.length) - offset);
                if (read > 0) {
                    this.mOffset += Math.max(read, 0);
                    size = this.mOffset;
                    boolean bl = isPass = size >= length;
                    if (isPass) {
                        this.mOffset = 0;
                        this.mBuffer = null;
                    }
                } else {
                    size = this.mOffset;
                    isPass = false;
                }
            }
            if (isPass) {
                this.mChannel.pass(byteBuffer.lock(size));
            }
            return read;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() {
            ByteBuffer byteBuffer;
            int size;
            Object object = this.mMutex;
            synchronized (object) {
                size = this.mOffset;
                if (size == 0) {
                    return;
                }
                byteBuffer = this.getBuffer();
                this.mOffset = 0;
                this.mBuffer = null;
            }
            this.mChannel.pass(byteBuffer.lock(size));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.mMutex;
            synchronized (object) {
                if (this.mIsClosed) {
                    return;
                }
                this.mIsClosed = true;
            }
            this.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            boolean isPass;
            int size;
            ByteBuffer byteBuffer;
            Object object = this.mMutex;
            synchronized (object) {
                if (this.mIsClosed) {
                    throw new IOException("cannot write into a closed output stream");
                }
                byteBuffer = this.getBuffer();
                byte[] buffer = byteBuffer.writeBuffer();
                buffer[this.mOffset++] = (byte)b;
                size = this.mOffset;
                boolean bl = isPass = size >= buffer.length;
                if (isPass) {
                    this.mOffset = 0;
                    this.mBuffer = null;
                }
            }
            if (isPass) {
                this.mChannel.pass(byteBuffer.lock(size));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(@NotNull byte[] b) throws IOException {
            int len = b.length;
            if (len == 0) {
                return;
            }
            int written = 0;
            do {
                boolean isPass;
                int size;
                ByteBuffer byteBuffer;
                Object object = this.mMutex;
                synchronized (object) {
                    if (this.mIsClosed) {
                        throw new IOException("cannot write into a closed output stream");
                    }
                    byteBuffer = this.getBuffer();
                    byte[] buffer = byteBuffer.writeBuffer();
                    int length = buffer.length;
                    int offset = this.mOffset;
                    int count = Math.min(len - written, length - offset);
                    System.arraycopy(b, written, buffer, offset, count);
                    written += count;
                    this.mOffset += count;
                    size = this.mOffset;
                    boolean bl = isPass = size >= length;
                    if (isPass) {
                        this.mOffset = 0;
                        this.mBuffer = null;
                    }
                }
                if (!isPass) continue;
                this.mChannel.pass(byteBuffer.lock(size));
            } while (written < len);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(@NotNull byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            int written = 0;
            do {
                boolean isPass;
                int size;
                ByteBuffer byteBuffer;
                Object object = this.mMutex;
                synchronized (object) {
                    if (this.mIsClosed) {
                        throw new IOException("cannot write into a closed output stream");
                    }
                    byteBuffer = this.getBuffer();
                    byte[] buffer = byteBuffer.writeBuffer();
                    int length = buffer.length;
                    int offset = this.mOffset;
                    int count = Math.min(len - written, length - offset);
                    System.arraycopy(b, off + written, buffer, offset, count);
                    written += count;
                    this.mOffset += count;
                    size = this.mOffset;
                    boolean bl = isPass = size >= length;
                    if (isPass) {
                        this.mOffset = 0;
                        this.mBuffer = null;
                    }
                }
                if (!isPass) continue;
                this.mChannel.pass(byteBuffer.lock(size));
            } while (written < len);
        }
    }

    private class DefaultBufferInputStream
    extends BufferInputStream {
        private final ByteBuffer mBuffer;
        private final Object mMutex = new Object();
        private boolean mIsClosed;
        private int mMark;
        private int mOffset;

        private DefaultBufferInputStream(ByteBuffer buffer) {
            this.mBuffer = buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(@NotNull OutputStream out) throws IOException {
            Object object = this.mMutex;
            synchronized (object) {
                ByteBuffer buffer = this.mBuffer;
                int size = buffer.getSize();
                int offset = this.mOffset;
                if (offset >= size) {
                    return -1;
                }
                int count = size - offset;
                out.write(buffer.readBuffer(), offset, count);
                this.mOffset = size;
                return count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(@NotNull byte[] b) {
            int len = b.length;
            if (len == 0) {
                return 0;
            }
            Object object = this.mMutex;
            synchronized (object) {
                ByteBuffer buffer = this.mBuffer;
                int size = buffer.getSize();
                int offset = this.mOffset;
                if (offset >= size) {
                    return -1;
                }
                int count = Math.min(len, size - offset);
                System.arraycopy(buffer.readBuffer(), offset, b, 0, count);
                this.mOffset += count;
                return count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(@NotNull byte[] b, int off, int len) {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            Object object = this.mMutex;
            synchronized (object) {
                ByteBuffer buffer = this.mBuffer;
                int size = buffer.getSize();
                int offset = this.mOffset;
                if (offset >= size) {
                    return -1;
                }
                int count = Math.min(len, size - offset);
                System.arraycopy(buffer.readBuffer(), offset, b, off, count);
                this.mOffset += count;
                return count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long skip(long n) {
            Object object = this.mMutex;
            synchronized (object) {
                long skipped = Math.min((long)(this.mBuffer.getSize() - this.mOffset), n);
                if (skipped > 0L) {
                    this.mOffset = (int)((long)this.mOffset + skipped);
                }
                return skipped;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int available() {
            Object object = this.mMutex;
            synchronized (object) {
                return Math.max(0, this.mBuffer.getSize() - this.mOffset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.mMutex;
            synchronized (object) {
                if (this.mIsClosed) {
                    return;
                }
                this.mIsClosed = true;
                this.mMark = 0;
                this.mBuffer.recycle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Object object = this.mMutex;
            synchronized (object) {
                this.mOffset = this.mMark;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() {
            Object object = this.mMutex;
            synchronized (object) {
                ByteBuffer buffer = this.mBuffer;
                int size = buffer.getSize();
                if (this.mOffset >= size) {
                    return -1;
                }
                return buffer.readBuffer()[this.mOffset++];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mark(int readLimit) {
            Object object = this.mMutex;
            synchronized (object) {
                this.mMark = this.mOffset;
            }
        }

        public boolean markSupported() {
            return true;
        }
    }

    public class ByteBuffer {
        private final byte[] mBuffer;
        private final Object mMutex = new Object();
        private final DefaultBufferInputStream mStream;
        private int mSize;
        private BufferState mState = BufferState.WRITE;

        private ByteBuffer(int bufferSize) {
            this.mBuffer = new byte[bufferSize];
            this.mStream = new DefaultBufferInputStream(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getSize() {
            Object object = this.mMutex;
            synchronized (object) {
                return this.mSize;
            }
        }

        public int hashCode() {
            int size = this.getSize();
            byte[] buffer = this.mBuffer;
            int result = size;
            for (int i = 0; i < size; ++i) {
                result = 31 * result + buffer[i];
            }
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ByteBuffer)) {
                return false;
            }
            ByteBuffer that = (ByteBuffer)o;
            int size = this.getSize();
            if (size != that.getSize()) {
                return false;
            }
            byte[] thisBuffer = this.mBuffer;
            byte[] thatBuffer = that.mBuffer;
            for (int i = 0; i < size; ++i) {
                if (thisBuffer[i] == thatBuffer[i]) continue;
                return false;
            }
            return true;
        }

        private void changeState(@NotNull BufferState expected, @NotNull BufferState updated, @NotNull String errorMessage) {
            if (this.mState != expected) {
                throw new IllegalStateException(errorMessage + ": " + (Object)((Object)this.mState));
            }
            this.mState = updated;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        private BufferInputStream getStream() {
            Object object = this.mMutex;
            synchronized (object) {
                this.changeState(BufferState.TRANSFER, BufferState.READ, "attempting to get buffer stream while in illegal state");
                return this.mStream;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        private ByteBuffer lock(int size) {
            Object object = this.mMutex;
            synchronized (object) {
                this.changeState(BufferState.WRITE, BufferState.TRANSFER, "attempting to write to output while in illegal state");
                this.mSize = size;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        private byte[] readBuffer() {
            Object object = this.mMutex;
            synchronized (object) {
                BufferState state = this.mState;
                if (state != BufferState.READ) {
                    throw new IllegalStateException("attempting to read buffer data while in illegal state: " + (Object)((Object)state));
                }
            }
            return this.mBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void recycle() {
            Object object = this.mMutex;
            synchronized (object) {
                this.changeState(BufferState.READ, BufferState.RECYCLED, "attempting to read from buffer while in illegal state");
                this.mSize = 0;
            }
            ByteChannel.this.release(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        private ByteBuffer unlock() {
            Object object = this.mMutex;
            synchronized (object) {
                this.changeState(BufferState.RECYCLED, BufferState.WRITE, "attempting to reuse instance while in illegal state");
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        private byte[] writeBuffer() {
            Object object = this.mMutex;
            synchronized (object) {
                BufferState state = this.mState;
                if (state != BufferState.WRITE) {
                    throw new IllegalStateException("attempting to write buffer data while in illegal state: " + (Object)((Object)state));
                }
            }
            return this.mBuffer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiBufferInputStream
    extends BufferInputStream {
        private final Object mMutex = new Object();
        private final ArrayList<BufferInputStream> mStreams;
        private int mIndex;
        private int mMarkIndex;

        private MultiBufferInputStream(@NotNull ByteBuffer[] buffers) {
            this.mStreams = new ArrayList<BufferInputStream>(buffers.length);
            ArrayList<BufferInputStream> streams = this.mStreams;
            for (ByteBuffer buffer : buffers) {
                streams.add(buffer.getStream());
            }
        }

        private MultiBufferInputStream(@NotNull List<ByteBuffer> buffers) {
            this.mStreams = new ArrayList<BufferInputStream>(buffers.size());
            ArrayList<BufferInputStream> streams = this.mStreams;
            for (ByteBuffer buffer : buffers) {
                streams.add(buffer.getStream());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(@NotNull OutputStream out) throws IOException {
            Object object = this.mMutex;
            synchronized (object) {
                ArrayList<BufferInputStream> streams = this.mStreams;
                int size = streams.size();
                if (this.mIndex >= size) {
                    return -1;
                }
                int read = streams.get(this.mIndex).read(out);
                while (read < 0) {
                    if (++this.mIndex >= size) {
                        return -1;
                    }
                    read = streams.get(this.mIndex).read(out);
                }
                return read;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() {
            Object object = this.mMutex;
            synchronized (object) {
                ArrayList<BufferInputStream> streams = this.mStreams;
                int size = streams.size();
                if (this.mIndex >= size) {
                    return -1;
                }
                int read = streams.get(this.mIndex).read();
                while (read == -1) {
                    if (++this.mIndex >= size) {
                        return -1;
                    }
                    read = streams.get(this.mIndex).read();
                }
                return read;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(@NotNull byte[] b) {
            int len = b.length;
            if (len == 0) {
                return 0;
            }
            Object object = this.mMutex;
            synchronized (object) {
                ArrayList<BufferInputStream> streams = this.mStreams;
                int size = streams.size();
                if (this.mIndex >= size) {
                    return -1;
                }
                int count = 0;
                int read = streams.get(this.mIndex).read(b);
                if (read > 0) {
                    count += read;
                }
                while (count < len) {
                    if (++this.mIndex >= size) {
                        return count > 0 ? count : -1;
                    }
                    read = streams.get(this.mIndex).read(b, count, len - count);
                    if (read <= 0) continue;
                    count += read;
                }
                return count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(@NotNull byte[] b, int off, int len) {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            Object object = this.mMutex;
            synchronized (object) {
                ArrayList<BufferInputStream> streams = this.mStreams;
                int size = streams.size();
                if (this.mIndex >= size) {
                    return -1;
                }
                int count = 0;
                int read = streams.get(this.mIndex).read(b, off, len);
                if (read > 0) {
                    count += read;
                }
                while (count < len) {
                    if (++this.mIndex >= size) {
                        return count > 0 ? count : -1;
                    }
                    read = streams.get(this.mIndex).read(b, off + count, len - count);
                    if (read <= 0) continue;
                    count += read;
                }
                return count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long n) {
            Object object = this.mMutex;
            synchronized (object) {
                ArrayList<BufferInputStream> streams = this.mStreams;
                int size = streams.size();
                if (this.mIndex >= size) {
                    return 0L;
                }
                long count = 0L;
                long skipped = streams.get(this.mIndex).skip(n);
                if (skipped > 0L) {
                    count += skipped;
                }
                while (count < n) {
                    if (++this.mIndex >= size) {
                        return count;
                    }
                    skipped = streams.get(this.mIndex).skip(n - count);
                    if (skipped <= 0L) continue;
                    count += skipped;
                }
                return count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() {
            int available = 0;
            Object object = this.mMutex;
            synchronized (object) {
                ArrayList<BufferInputStream> streams = this.mStreams;
                int size = streams.size();
                for (int i = this.mIndex; i < size; ++i) {
                    available += streams.get(i).available();
                }
            }
            return available;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.mMutex;
            synchronized (object) {
                for (BufferInputStream stream : this.mStreams) {
                    stream.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mark(int readLimit) {
            Object object = this.mMutex;
            synchronized (object) {
                int index = this.mMarkIndex = this.mIndex;
                this.mStreams.get(index).mark(readLimit);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset() {
            Object object = this.mMutex;
            synchronized (object) {
                int index = this.mIndex = this.mMarkIndex;
                ArrayList<BufferInputStream> streams = this.mStreams;
                streams.get(index).reset();
                int size = streams.size();
                for (int i = index + 1; i < size; ++i) {
                    streams.get(i).reset();
                }
            }
        }

        @Override
        public boolean markSupported() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IOBufferOutputStream
    extends BufferOutputStream {
        private final IOChannel<? super ByteBuffer, ?> mIOChannel;
        private final BufferOutputStream mOutputStream;

        private IOBufferOutputStream(@NotNull BufferOutputStream wrapped, @NotNull IOChannel<? super ByteBuffer, ?> channel) {
            this.mOutputStream = wrapped;
            this.mIOChannel = channel;
        }

        @Override
        public int write(@NotNull InputStream in) throws IOException {
            return this.mOutputStream.write(in);
        }

        @Override
        public void write(int b) throws IOException {
            this.mOutputStream.write(b);
        }

        @Override
        public void write(@NotNull byte[] b) throws IOException {
            this.mOutputStream.write(b);
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) throws IOException {
            this.mOutputStream.write(b, off, len);
        }

        @Override
        public void flush() {
            this.mOutputStream.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            try {
                this.mOutputStream.close();
            }
            finally {
                this.mIOChannel.close();
            }
        }
    }

    public static abstract class BufferOutputStream
    extends OutputStream {
        public abstract int write(@NotNull InputStream var1) throws IOException;

        public long writeAll(@NotNull InputStream in) throws IOException {
            int b;
            long count = 0L;
            while ((b = this.write(in)) > 0) {
                count += (long)b;
            }
            return count;
        }

        public abstract void flush();

        public abstract void close();
    }

    public static abstract class BufferInputStream
    extends InputStream {
        public abstract int read(@NotNull OutputStream var1) throws IOException;

        public abstract int read();

        public abstract int read(@NotNull byte[] var1);

        public abstract int read(@NotNull byte[] var1, int var2, int var3);

        public abstract long skip(long var1);

        public abstract int available();

        public abstract void close();

        public abstract void mark(int var1);

        public abstract void reset();

        public long readAll(@NotNull OutputStream out) throws IOException {
            int b;
            long count = 0L;
            while ((b = this.read(out)) > 0) {
                count += (long)b;
            }
            return count;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BufferState {
        WRITE,
        TRANSFER,
        READ,
        RECYCLED;

    }
}

