/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.core;

import com.github.dm.jrt.channel.Channel;
import com.github.dm.jrt.channel.IOChannel;
import com.github.dm.jrt.channel.OutputConsumer;
import com.github.dm.jrt.channel.RoutineException;
import com.github.dm.jrt.channel.StreamingChannel;
import com.github.dm.jrt.core.DefaultStreamingChannel;
import com.github.dm.jrt.core.JRoutine;
import com.github.dm.jrt.core.SimpleQueue;
import com.github.dm.jrt.routine.Routine;
import com.github.dm.jrt.util.WeakIdentityHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Channels {
    private static final WeakIdentityHashMap<Channel.OutputChannel<?>, DefaultSelectableOutputChannel<?>> sSelectableChannels = new WeakIdentityHashMap();

    protected Channels() {
    }

    @NotNull
    public static <IN, OUT> StreamingChannel<IN, OUT> asyncStream(@NotNull Routine<IN, OUT> routine) {
        IOChannel ioChannel = JRoutine.io().buildChannel();
        return Channels.stream(ioChannel, routine.asyncCall(ioChannel));
    }

    @NotNull
    public static IOChannel<Selectable<?>, Selectable<?>> combine(Channel.InputChannel<?> ... channels) {
        return Channels.combine(0, channels);
    }

    @NotNull
    public static IOChannel<Selectable<?>, Selectable<?>> combine(int startIndex, Channel.InputChannel<?> ... channels) {
        int length = channels.length;
        if (length == 0) {
            throw new IllegalArgumentException("the array of channels must not be empty");
        }
        ArrayList channelList = new ArrayList(length);
        for (Channel.InputChannel<?> channel : channels) {
            IOChannel ioChannel = JRoutine.io().buildChannel();
            ioChannel.passTo(channel);
            channelList.add(ioChannel);
        }
        IOChannel<Selectable<?>, Selectable<?>> ioChannel = JRoutine.io().buildChannel();
        ioChannel.passTo(new SortingArrayOutputConsumer(startIndex, channelList));
        return ioChannel;
    }

    @NotNull
    public static <IN> IOChannel<Selectable<? extends IN>, Selectable<? extends IN>> combine(int startIndex, @NotNull List<? extends Channel.InputChannel<? extends IN>> channels) {
        if (channels.isEmpty()) {
            throw new IllegalArgumentException("the list of channels must not be empty");
        }
        ArrayList channelList = new ArrayList(channels.size());
        for (Channel.InputChannel<IN> inputChannel : channels) {
            IOChannel ioChannel = JRoutine.io().buildChannel();
            ioChannel.passTo(inputChannel);
            channelList.add(ioChannel);
        }
        IOChannel<Selectable<IN>, Selectable<IN>> ioChannel = JRoutine.io().buildChannel();
        ioChannel.passTo(new SortingArrayOutputConsumer(startIndex, channelList));
        return ioChannel;
    }

    @NotNull
    public static <IN> IOChannel<Selectable<? extends IN>, Selectable<? extends IN>> combine(@NotNull List<? extends Channel.InputChannel<? extends IN>> channels) {
        return Channels.combine(0, channels);
    }

    @NotNull
    public static <IN> IOChannel<Selectable<? extends IN>, Selectable<? extends IN>> combine(@NotNull Map<Integer, ? extends Channel.InputChannel<? extends IN>> channels) {
        if (channels.isEmpty()) {
            throw new IllegalArgumentException("the map of channels must not be empty");
        }
        HashMap channelMap = new HashMap(channels.size());
        for (Map.Entry<Integer, Channel.InputChannel<IN>> entry : channels.entrySet()) {
            IOChannel ioChannel = JRoutine.io().buildChannel();
            ioChannel.passTo(entry.getValue());
            channelMap.put(entry.getKey(), ioChannel);
        }
        IOChannel<Selectable<IN>, Selectable<IN>> ioChannel = JRoutine.io().buildChannel();
        ioChannel.passTo(new SortingMapOutputConsumer(channelMap));
        return ioChannel;
    }

    @NotNull
    public static IOChannel<List<?>, List<?>> distribute(Channel.InputChannel<?> ... channels) {
        return Channels.distribute(false, channels);
    }

    @NotNull
    public static <IN> IOChannel<List<? extends IN>, List<? extends IN>> distribute(@NotNull List<? extends Channel.InputChannel<? extends IN>> channels) {
        return Channels.distribute(false, channels);
    }

    @NotNull
    public static IOChannel<List<?>, List<?>> distributeAndFlush(Channel.InputChannel<?> ... channels) {
        return Channels.distribute(true, channels);
    }

    @NotNull
    public static <IN> IOChannel<List<? extends IN>, List<? extends IN>> distributeAndFlush(@NotNull List<? extends Channel.InputChannel<? extends IN>> channels) {
        return Channels.distribute(true, channels);
    }

    @NotNull
    public static <OUT> Channel.OutputChannel<List<? extends OUT>> join(@NotNull List<? extends Channel.OutputChannel<? extends OUT>> channels) {
        return Channels.join(false, channels);
    }

    @NotNull
    public static Channel.OutputChannel<List<?>> join(Channel.OutputChannel<?> ... channels) {
        return Channels.join(false, channels);
    }

    @NotNull
    public static <OUT> Channel.OutputChannel<List<? extends OUT>> joinAndFlush(@NotNull List<? extends Channel.OutputChannel<? extends OUT>> channels) {
        return Channels.join(true, channels);
    }

    @NotNull
    public static Channel.OutputChannel<List<?>> joinAndFlush(Channel.OutputChannel<?> ... channels) {
        return Channels.join(true, channels);
    }

    @NotNull
    public static <OUT> Channel.OutputChannel<? extends Selectable<OUT>> merge(int startIndex, @NotNull List<? extends Channel.OutputChannel<? extends OUT>> channels) {
        if (channels.isEmpty()) {
            throw new IllegalArgumentException("the list of channels must not be empty");
        }
        IOChannel ioChannel = JRoutine.io().buildChannel();
        int i = startIndex;
        for (Channel.OutputChannel<OUT> outputChannel : channels) {
            ioChannel.pass(Channels.toSelectable(outputChannel, i++));
        }
        return ioChannel.close();
    }

    @NotNull
    public static Channel.OutputChannel<? extends Selectable<?>> merge(int startIndex, Channel.OutputChannel<?> ... channels) {
        if (channels.length == 0) {
            throw new IllegalArgumentException("the array of channels must not be empty");
        }
        IOChannel ioChannel = JRoutine.io().buildChannel();
        int i = startIndex;
        for (Channel.OutputChannel<?> channel : channels) {
            ioChannel.pass(Channels.toSelectable(channel, i++));
        }
        return ioChannel.close();
    }

    @NotNull
    public static <OUT> Channel.OutputChannel<? extends Selectable<OUT>> merge(@NotNull List<? extends Channel.OutputChannel<? extends OUT>> channels) {
        return Channels.merge(0, channels);
    }

    @NotNull
    public static <OUT> Channel.OutputChannel<? extends Selectable<OUT>> merge(@NotNull Map<Integer, ? extends Channel.OutputChannel<? extends OUT>> channelMap) {
        if (channelMap.isEmpty()) {
            throw new IllegalArgumentException("the map of channels must not be empty");
        }
        IOChannel ioChannel = JRoutine.io().buildChannel();
        for (Map.Entry<Integer, Channel.OutputChannel<OUT>> entry : channelMap.entrySet()) {
            ioChannel.pass(Channels.toSelectable(entry.getValue(), (int)entry.getKey()));
        }
        return ioChannel.close();
    }

    @NotNull
    public static Channel.OutputChannel<? extends Selectable<?>> merge(Channel.OutputChannel<?> ... channels) {
        return Channels.merge(0, channels);
    }

    @NotNull
    public static <IN, OUT> StreamingChannel<IN, OUT> parallelStream(@NotNull Routine<IN, OUT> routine) {
        IOChannel ioChannel = JRoutine.io().buildChannel();
        return Channels.stream(ioChannel, routine.parallelCall(ioChannel));
    }

    @NotNull
    public static <DATA, IN extends DATA> IOChannel<IN, IN> select(@Nullable Channel.InputChannel<? super Selectable<DATA>> channel, int index) {
        IOChannel inputChannel = JRoutine.io().buildChannel();
        if (channel != null) {
            IOChannel ioChannel = JRoutine.io().buildChannel();
            ioChannel.passTo(channel);
            inputChannel.passTo(new SelectableOutputConsumer(ioChannel, index));
        }
        return inputChannel;
    }

    @NotNull
    public static <DATA, IN extends DATA> Map<Integer, IOChannel<IN, IN>> select(@NotNull Channel.InputChannel<? super Selectable<DATA>> channel, @NotNull Iterable<Integer> indexes) {
        HashMap<Integer, IOChannel<IN, IN>> channelMap = new HashMap<Integer, IOChannel<IN, IN>>();
        for (Integer index : indexes) {
            channelMap.put(index, Channels.select(channel, (int)index));
        }
        return channelMap;
    }

    @NotNull
    public static <DATA, IN extends DATA> Map<Integer, IOChannel<IN, IN>> select(@NotNull Channel.InputChannel<? super Selectable<DATA>> channel, int ... indexes) {
        int size = indexes.length;
        HashMap<Integer, IOChannel<IN, IN>> channelMap = new HashMap<Integer, IOChannel<IN, IN>>(size);
        for (int index : indexes) {
            channelMap.put(index, Channels.select(channel, index));
        }
        return channelMap;
    }

    @NotNull
    public static <DATA, IN extends DATA> Map<Integer, IOChannel<IN, IN>> select(int startIndex, int rangeSize, @NotNull Channel.InputChannel<? super Selectable<DATA>> channel) {
        if (rangeSize <= 0) {
            throw new IllegalArgumentException("invalid range size: " + rangeSize);
        }
        HashMap<Integer, IOChannel<IN, IN>> channelMap = new HashMap<Integer, IOChannel<IN, IN>>(rangeSize);
        for (int index = startIndex; index < rangeSize; ++index) {
            channelMap.put(index, Channels.select(channel, index));
        }
        return channelMap;
    }

    @NotNull
    public static <OUT> Map<Integer, Channel.OutputChannel<OUT>> select(int startIndex, int rangeSize, @NotNull Channel.OutputChannel<? extends Selectable<? extends OUT>> channel) {
        if (rangeSize <= 0) {
            throw new IllegalArgumentException("invalid range size: " + rangeSize);
        }
        HashMap inputMap = new HashMap(rangeSize);
        HashMap<Integer, Channel.OutputChannel<OUT>> outputMap = new HashMap<Integer, Channel.OutputChannel<OUT>>(rangeSize);
        for (int index = startIndex; index < rangeSize; ++index) {
            Integer integer = index;
            IOChannel ioChannel = JRoutine.io().buildChannel();
            inputMap.put(integer, ioChannel);
            outputMap.put(integer, ioChannel);
        }
        channel.passTo(new SortingMapOutputConsumer(inputMap));
        return outputMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static <OUT> SelectableOutputChannel<OUT> select(@NotNull Channel.OutputChannel<? extends Selectable<? extends OUT>> channel) {
        WeakIdentityHashMap<Channel.OutputChannel<?>, DefaultSelectableOutputChannel<?>> weakIdentityHashMap = sSelectableChannels;
        synchronized (weakIdentityHashMap) {
            WeakIdentityHashMap<Channel.OutputChannel<?>, DefaultSelectableOutputChannel<?>> selectableOutputs = sSelectableChannels;
            DefaultSelectableOutputChannel<?> selectableOutput = selectableOutputs.get(channel);
            if (selectableOutput == null) {
                DefaultSelectableOutputChannel output = new DefaultSelectableOutputChannel();
                channel.passTo(output);
                selectableOutputs.put(channel, output);
                return output;
            }
            return selectableOutput;
        }
    }

    @NotNull
    public static <OUT> Map<Integer, Channel.OutputChannel<OUT>> select(@NotNull Channel.OutputChannel<? extends Selectable<? extends OUT>> channel, int ... indexes) {
        int size = indexes.length;
        HashMap inputMap = new HashMap(size);
        HashMap<Integer, Channel.OutputChannel<OUT>> outputMap = new HashMap<Integer, Channel.OutputChannel<OUT>>(size);
        int[] arr$ = indexes;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer index = arr$[i$];
            IOChannel ioChannel = JRoutine.io().buildChannel();
            inputMap.put(index, ioChannel);
            outputMap.put(index, ioChannel);
        }
        channel.passTo(new SortingMapOutputConsumer(inputMap));
        return outputMap;
    }

    @NotNull
    public static <OUT> Map<Integer, Channel.OutputChannel<OUT>> select(@NotNull Channel.OutputChannel<? extends Selectable<? extends OUT>> channel, @NotNull Iterable<Integer> indexes) {
        HashMap inputMap = new HashMap();
        HashMap<Integer, Channel.OutputChannel<OUT>> outputMap = new HashMap<Integer, Channel.OutputChannel<OUT>>();
        for (Integer index : indexes) {
            IOChannel ioChannel = JRoutine.io().buildChannel();
            inputMap.put(index, ioChannel);
            outputMap.put(index, ioChannel);
        }
        channel.passTo(new SortingMapOutputConsumer(inputMap));
        return outputMap;
    }

    @NotNull
    public static <IN, OUT> StreamingChannel<IN, OUT> stream(@NotNull IOChannel<IN, ?> inputChannel, @NotNull Channel.OutputChannel<OUT> outputChannel) {
        return new DefaultStreamingChannel<IN, OUT>(inputChannel, outputChannel);
    }

    @NotNull
    public static <IN, OUT> StreamingChannel<IN, OUT> syncStream(@NotNull Routine<IN, OUT> routine) {
        IOChannel ioChannel = JRoutine.io().buildChannel();
        return Channels.stream(ioChannel, routine.syncCall(ioChannel));
    }

    @NotNull
    public static <IN> IOChannel<Selectable<IN>, Selectable<IN>> toSelectable(@Nullable Channel.InputChannel<? super IN> channel, int index) {
        IOChannel<Selectable<IN>, Selectable<IN>> inputChannel = JRoutine.io().buildChannel();
        if (channel != null) {
            IOChannel ioChannel = JRoutine.io().buildChannel();
            ioChannel.passTo(channel);
            inputChannel.passTo(new FilterOutputConsumer(ioChannel, index));
        }
        return inputChannel;
    }

    @NotNull
    public static <OUT> Channel.OutputChannel<? extends Selectable<OUT>> toSelectable(@Nullable Channel.OutputChannel<? extends OUT> channel, int index) {
        IOChannel ioChannel = JRoutine.io().buildChannel();
        if (channel != null) {
            channel.passTo(new SelectableOutputConsumer(ioChannel, index));
        }
        return ioChannel;
    }

    @NotNull
    private static IOChannel<List<?>, List<?>> distribute(boolean isFlush, Channel.InputChannel<?> ... channels) {
        int length = channels.length;
        if (length == 0) {
            throw new IllegalArgumentException("the array of channels must not be empty");
        }
        ArrayList channelList = new ArrayList(length);
        for (Channel.InputChannel<?> channel : channels) {
            IOChannel ioChannel = JRoutine.io().buildChannel();
            ioChannel.passTo(channel);
            channelList.add(ioChannel);
        }
        IOChannel ioChannel = JRoutine.io().buildChannel();
        return ioChannel.passTo(new DistributeOutputConsumer(isFlush, channelList));
    }

    @NotNull
    private static <IN> IOChannel<List<? extends IN>, List<? extends IN>> distribute(boolean isFlush, @NotNull List<? extends Channel.InputChannel<? extends IN>> channels) {
        if (channels.isEmpty()) {
            throw new IllegalArgumentException("the list of channels must not be empty");
        }
        ArrayList channelList = new ArrayList(channels.size());
        for (Channel.InputChannel<IN> inputChannel : channels) {
            IOChannel ioChannel = JRoutine.io().buildChannel();
            ioChannel.passTo(inputChannel);
            channelList.add(ioChannel);
        }
        IOChannel ioChannel = JRoutine.io().buildChannel();
        return ioChannel.passTo(new DistributeOutputConsumer(isFlush, channelList));
    }

    @NotNull
    private static <OUT> Channel.OutputChannel<List<? extends OUT>> join(boolean isFlush, @NotNull List<? extends Channel.OutputChannel<? extends OUT>> channels) {
        int size = channels.size();
        if (size == 0) {
            throw new IllegalArgumentException("the list of channels must not be empty");
        }
        IOChannel ioChannel = JRoutine.io().buildChannel();
        JoinOutputConsumer consumer = new JoinOutputConsumer(ioChannel, size, isFlush);
        Channels.merge(channels).passTo(consumer);
        return ioChannel;
    }

    @NotNull
    private static Channel.OutputChannel<List<?>> join(boolean isFlush, Channel.OutputChannel<?> ... channels) {
        int length = channels.length;
        if (length == 0) {
            throw new IllegalArgumentException("the array of channels must not be empty");
        }
        IOChannel ioChannel = JRoutine.io().buildChannel();
        JoinOutputConsumer consumer = new JoinOutputConsumer(ioChannel, length, isFlush);
        Channels.merge(channels).passTo(consumer);
        return ioChannel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SortingMapOutputConsumer<OUT>
    implements OutputConsumer<Selectable<? extends OUT>> {
        private final HashMap<Integer, IOChannel<OUT, OUT>> mChannels;

        private SortingMapOutputConsumer(@NotNull HashMap<Integer, IOChannel<OUT, OUT>> channels) {
            this.mChannels = channels;
        }

        @Override
        public void onComplete() {
            for (IOChannel<OUT, OUT> channel : this.mChannels.values()) {
                channel.close();
            }
        }

        @Override
        public void onError(@Nullable RoutineException error) {
            for (IOChannel<OUT, OUT> channel : this.mChannels.values()) {
                channel.abort(error);
            }
        }

        @Override
        public void onOutput(Selectable<? extends OUT> selectable) {
            IOChannel<OUT, OUT> channel = this.mChannels.get(selectable.index);
            if (channel != null) {
                channel.pass((OUT)selectable.data);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SortingArrayOutputConsumer
    implements OutputConsumer<Selectable<?>> {
        private final ArrayList<IOChannel<?, ?>> mChannelList;
        private final int mSize;
        private final int mStartIndex;

        private SortingArrayOutputConsumer(int startIndex, @NotNull ArrayList<IOChannel<?, ?>> channels) {
            this.mStartIndex = startIndex;
            this.mChannelList = channels;
            this.mSize = channels.size();
        }

        @Override
        public void onComplete() {
            for (IOChannel<?, ?> channel : this.mChannelList) {
                channel.close();
            }
        }

        @Override
        public void onError(@Nullable RoutineException error) {
            for (IOChannel<?, ?> channel : this.mChannelList) {
                channel.abort(error);
            }
        }

        @Override
        public void onOutput(Selectable<?> selectable) {
            int index = selectable.index - this.mStartIndex;
            if (index < 0 || index >= this.mSize) {
                return;
            }
            IOChannel<?, ?> channel = this.mChannelList.get(index);
            if (channel != null) {
                channel.pass(selectable.data);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SelectableOutputConsumer<OUT, IN extends OUT>
    implements OutputConsumer<IN> {
        private final IOChannel<? super Selectable<OUT>, ? super Selectable<OUT>> mChannel;
        private final int mIndex;

        private SelectableOutputConsumer(@NotNull IOChannel<? super Selectable<OUT>, ? super Selectable<OUT>> channel, int index) {
            this.mChannel = channel;
            this.mIndex = index;
        }

        @Override
        public void onComplete() {
            this.mChannel.close();
        }

        @Override
        public void onError(@Nullable RoutineException error) {
            this.mChannel.abort(error);
        }

        @Override
        public void onOutput(IN input) {
            this.mChannel.pass(new Selectable<IN>(input, this.mIndex));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JoinOutputConsumer<OUT>
    implements OutputConsumer<Selectable<OUT>> {
        private final IOChannel<List<? extends OUT>, List<? extends OUT>> mChannel;
        private final boolean mIsFlush;
        private final SimpleQueue<OUT>[] mQueues;

        private JoinOutputConsumer(@NotNull IOChannel<List<? extends OUT>, List<? extends OUT>> channel, int size, boolean isFlush) {
            this.mQueues = new SimpleQueue[size];
            SimpleQueue[] queues = this.mQueues;
            this.mChannel = channel;
            this.mIsFlush = isFlush;
            for (int i = 0; i < size; ++i) {
                queues[i] = new SimpleQueue();
            }
        }

        private void flush() {
            IOChannel<List<OUT>, List<OUT>> channel = this.mChannel;
            SimpleQueue<OUT>[] queues = this.mQueues;
            int length = queues.length;
            ArrayList<OUT> outputs = new ArrayList<OUT>(length);
            while (true) {
                boolean isEmpty = true;
                for (SimpleQueue<OUT> queue : queues) {
                    if (!queue.isEmpty()) {
                        isEmpty = false;
                        outputs.add(queue.removeFirst());
                        continue;
                    }
                    outputs.add(null);
                }
                if (isEmpty) break;
                channel.pass((List<OUT>)outputs);
                outputs.clear();
            }
        }

        @Override
        public void onComplete() {
            if (this.mIsFlush) {
                this.flush();
            }
            this.mChannel.close();
        }

        @Override
        public void onError(@Nullable RoutineException error) {
            this.mChannel.abort(error);
        }

        @Override
        public void onOutput(Selectable<OUT> selectable) {
            int index = selectable.index;
            SimpleQueue<OUT>[] queues = this.mQueues;
            queues[index].add(selectable.data);
            int length = queues.length;
            boolean isFull = true;
            for (SimpleQueue<OUT> queue : queues) {
                if (!queue.isEmpty()) continue;
                isFull = false;
                break;
            }
            if (isFull) {
                ArrayList<OUT> outputs = new ArrayList<OUT>(length);
                for (SimpleQueue<OUT> queue : queues) {
                    outputs.add(queue.removeFirst());
                }
                this.mChannel.pass((List<OUT>)outputs);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilterOutputConsumer<IN>
    implements OutputConsumer<Selectable<IN>> {
        private final IOChannel<? super IN, ? super IN> mChannel;
        private final int mIndex;

        private FilterOutputConsumer(@NotNull IOChannel<? super IN, ? super IN> channel, int index) {
            this.mChannel = channel;
            this.mIndex = index;
        }

        @Override
        public void onComplete() {
            this.mChannel.close();
        }

        @Override
        public void onError(@Nullable RoutineException error) {
            this.mChannel.abort(error);
        }

        @Override
        public void onOutput(Selectable<IN> selectable) {
            if (selectable.index == this.mIndex) {
                this.mChannel.pass(selectable.data);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DistributeOutputConsumer
    implements OutputConsumer<List<?>> {
        private final ArrayList<IOChannel<?, ?>> mChannels;
        private final boolean mIsFlush;

        private DistributeOutputConsumer(boolean isFlush, @NotNull ArrayList<IOChannel<?, ?>> channels) {
            this.mChannels = channels;
            this.mIsFlush = isFlush;
        }

        @Override
        public void onComplete() {
            for (IOChannel<?, ?> channel : this.mChannels) {
                channel.close();
            }
        }

        @Override
        public void onError(@Nullable RoutineException error) {
            for (IOChannel<?, ?> channel : this.mChannels) {
                channel.abort(error);
            }
        }

        @Override
        public void onOutput(List<?> inputs) {
            ArrayList<IOChannel<?, ?>> channels;
            int size;
            int inputSize = inputs.size();
            if (inputSize > (size = (channels = this.mChannels).size())) {
                throw new IllegalArgumentException();
            }
            boolean isFlush = this.mIsFlush;
            for (int i = 0; i < size; ++i) {
                IOChannel<?, ?> channel = channels.get(i);
                if (i < inputSize) {
                    channel.pass(inputs.get(i));
                    continue;
                }
                if (!isFlush) continue;
                channel.pass((Object)null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultSelectableOutputChannel<OUT>
    implements SelectableOutputChannel<OUT>,
    OutputConsumer<Selectable<? extends OUT>> {
        private final HashMap<Integer, IOChannel<OUT, OUT>> mChannels = new HashMap();
        private final Object mMutex = new Object();
        private boolean mIsOutput;

        private DefaultSelectableOutputChannel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Channel.OutputChannel<OUT> index(int index) {
            IOChannel<Object, Object> channel;
            Object object = this.mMutex;
            synchronized (object) {
                HashMap<Integer, IOChannel<OUT, OUT>> channels = this.mChannels;
                channel = channels.get(index);
                if (channel == null) {
                    if (this.mIsOutput) {
                        throw new IllegalStateException();
                    }
                    channel = JRoutine.io().buildChannel();
                    channels.put(index, channel);
                }
            }
            return channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            Object object = this.mMutex;
            synchronized (object) {
                this.mIsOutput = true;
            }
            HashMap<Integer, IOChannel<OUT, OUT>> channels = this.mChannels;
            for (IOChannel<OUT, OUT> channel : channels.values()) {
                channel.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onOutput(Selectable<? extends OUT> selectable) {
            Object object = this.mMutex;
            synchronized (object) {
                this.mIsOutput = true;
            }
            HashMap<Integer, IOChannel<OUT, OUT>> channels = this.mChannels;
            IOChannel<OUT, OUT> channel = channels.get(selectable.index);
            if (channel != null) {
                channel.pass((OUT)selectable.data);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(@Nullable RoutineException error) {
            Object object = this.mMutex;
            synchronized (object) {
                this.mIsOutput = true;
            }
            HashMap<Integer, IOChannel<OUT, OUT>> channels = this.mChannels;
            for (IOChannel<OUT, OUT> channel : channels.values()) {
                channel.abort(error);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Selectable<DATA> {
        public final DATA data;
        public final int index;

        public Selectable(DATA data, int index) {
            this.data = data;
            this.index = index;
        }

        public <TYPE extends DATA> TYPE data() {
            return (TYPE)this.data;
        }

        public int hashCode() {
            int result = this.data != null ? this.data.hashCode() : 0;
            result = 31 * result + this.index;
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Selectable)) {
                return false;
            }
            Selectable that = (Selectable)o;
            return this.index == that.index && !(this.data == null ? that.data != null : !this.data.equals(that.data));
        }

        public String toString() {
            return "Selectable{data=" + this.data + ", index=" + this.index + '}';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SelectableOutputChannel<OUT> {
        @NotNull
        public Channel.OutputChannel<OUT> index(int var1);
    }
}

