/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.core;

import com.github.dm.jrt.builder.ChannelConfiguration;
import com.github.dm.jrt.builder.InvocationConfiguration;
import com.github.dm.jrt.channel.Channel;
import com.github.dm.jrt.channel.IOChannel;
import com.github.dm.jrt.channel.OutputConsumer;
import com.github.dm.jrt.channel.RoutineException;
import com.github.dm.jrt.core.DefaultResultChannel;
import com.github.dm.jrt.log.Logger;
import com.github.dm.jrt.runner.Runners;
import com.github.dm.jrt.util.TimeDuration;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultIOChannel<DATA>
implements IOChannel<DATA, DATA> {
    private final DefaultResultChannel<DATA> mInputChannel;
    private final Channel.OutputChannel<DATA> mOutputChannel;

    DefaultIOChannel(@NotNull ChannelConfiguration configuration) {
        InvocationConfiguration invocationConfiguration = configuration.toOutputChannelConfiguration();
        Logger logger = invocationConfiguration.newLogger(this);
        ChannelAbortHandler abortHandler = new ChannelAbortHandler();
        DefaultResultChannel inputChannel = new DefaultResultChannel(invocationConfiguration, abortHandler, invocationConfiguration.getRunnerOr(Runners.sharedRunner()), logger);
        abortHandler.setChannel(inputChannel);
        this.mInputChannel = inputChannel;
        this.mOutputChannel = inputChannel.getOutput();
        logger.dbg("building I/O channel with configuration: %s", (Object)configuration);
    }

    @Override
    public boolean abort() {
        return this.mInputChannel.abort() || this.mOutputChannel.abort();
    }

    @Override
    public boolean abort(@Nullable Throwable reason) {
        return this.mInputChannel.abort(reason) || this.mOutputChannel.abort(reason);
    }

    @Override
    public boolean isEmpty() {
        return this.mInputChannel.isEmpty() && this.mOutputChannel.isEmpty();
    }

    @Override
    public boolean isOpen() {
        return this.mInputChannel.isOpen();
    }

    @Override
    @NotNull
    public IOChannel<DATA, DATA> after(@NotNull TimeDuration delay) {
        this.mInputChannel.after(delay);
        return this;
    }

    @Override
    @NotNull
    public IOChannel<DATA, DATA> after(long delay, @NotNull TimeUnit timeUnit) {
        this.mInputChannel.after(delay, timeUnit);
        return this;
    }

    @Override
    @NotNull
    public IOChannel<DATA, DATA> now() {
        this.mInputChannel.now();
        return this;
    }

    @Override
    @NotNull
    public IOChannel<DATA, DATA> orderByCall() {
        this.mInputChannel.orderByCall();
        return this;
    }

    @Override
    @NotNull
    public IOChannel<DATA, DATA> orderByChance() {
        this.mInputChannel.orderByChance();
        return this;
    }

    @Override
    @NotNull
    public IOChannel<DATA, DATA> orderByDelay() {
        this.mInputChannel.orderByDelay();
        return this;
    }

    @Override
    @NotNull
    public IOChannel<DATA, DATA> pass(@Nullable Channel.OutputChannel<? extends DATA> channel) {
        this.mInputChannel.pass(channel);
        return this;
    }

    @Override
    @NotNull
    public IOChannel<DATA, DATA> pass(@Nullable Iterable<? extends DATA> inputs) {
        this.mInputChannel.pass(inputs);
        return this;
    }

    @Override
    @NotNull
    public IOChannel<DATA, DATA> pass(@Nullable DATA input) {
        this.mInputChannel.pass((Object)input);
        return this;
    }

    @Override
    @NotNull
    public IOChannel<DATA, DATA> pass(DATA ... inputs) {
        this.mInputChannel.pass(inputs);
        return this;
    }

    @Override
    @NotNull
    public IOChannel<DATA, DATA> afterMax(@NotNull TimeDuration timeout) {
        this.mOutputChannel.afterMax(timeout);
        return this;
    }

    @Override
    @NotNull
    public IOChannel<DATA, DATA> afterMax(long timeout, @NotNull TimeUnit timeUnit) {
        this.mOutputChannel.afterMax(timeout, timeUnit);
        return this;
    }

    @Override
    @NotNull
    public IOChannel<DATA, DATA> allInto(@NotNull Collection<? super DATA> results) {
        this.mOutputChannel.allInto(results);
        return this;
    }

    @Override
    @NotNull
    public IOChannel<DATA, DATA> eventuallyAbort() {
        this.mOutputChannel.eventuallyAbort();
        return this;
    }

    @Override
    @NotNull
    public IOChannel<DATA, DATA> eventuallyAbort(@Nullable Throwable reason) {
        this.mOutputChannel.eventuallyAbort(reason);
        return this;
    }

    @Override
    @NotNull
    public IOChannel<DATA, DATA> eventuallyExit() {
        this.mOutputChannel.eventuallyExit();
        return this;
    }

    @Override
    @NotNull
    public IOChannel<DATA, DATA> eventuallyThrow() {
        this.mOutputChannel.eventuallyThrow();
        return this;
    }

    @Override
    @NotNull
    public IOChannel<DATA, DATA> immediately() {
        this.mOutputChannel.immediately();
        return this;
    }

    @Override
    @NotNull
    public IOChannel<DATA, DATA> passTo(@NotNull OutputConsumer<? super DATA> consumer) {
        this.mOutputChannel.passTo(consumer);
        return this;
    }

    @Override
    @NotNull
    public IOChannel<DATA, DATA> skip(int count) {
        this.mOutputChannel.skip(count);
        return this;
    }

    @Override
    @NotNull
    public Channel.InputChannel<DATA> asInput() {
        return this;
    }

    @Override
    @NotNull
    public Channel.OutputChannel<DATA> asOutput() {
        return this;
    }

    @Override
    @NotNull
    public IOChannel<DATA, DATA> close() {
        this.mInputChannel.close();
        return this;
    }

    @Override
    @NotNull
    public List<DATA> all() {
        return this.mOutputChannel.all();
    }

    @Override
    public boolean checkComplete() {
        return this.mOutputChannel.checkComplete();
    }

    @Override
    public boolean hasNext() {
        return this.mOutputChannel.hasNext();
    }

    @Override
    public DATA next() {
        return this.mOutputChannel.next();
    }

    @Override
    public boolean isBound() {
        return this.mOutputChannel.isBound();
    }

    @Override
    @NotNull
    public List<DATA> next(int count) {
        return this.mOutputChannel.next(count);
    }

    @Override
    @NotNull
    public <IN extends Channel.InputChannel<? super DATA>> IN passTo(@NotNull IN channel) {
        return this.mOutputChannel.passTo(channel);
    }

    @Override
    public Iterator<DATA> iterator() {
        return this.mOutputChannel.iterator();
    }

    @Override
    public void remove() {
        this.mOutputChannel.remove();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChannelAbortHandler
    implements DefaultResultChannel.AbortHandler {
        private DefaultResultChannel<?> mChannel;

        private ChannelAbortHandler() {
        }

        @Override
        public void onAbort(@Nullable RoutineException reason, long delay, @NotNull TimeUnit timeUnit) {
            this.mChannel.close(reason);
        }

        private void setChannel(@NotNull DefaultResultChannel<?> channel) {
            this.mChannel = channel;
        }
    }
}

