/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.core;

import com.github.dm.jrt.builder.InvocationConfiguration;
import com.github.dm.jrt.channel.AbortException;
import com.github.dm.jrt.channel.Channel;
import com.github.dm.jrt.channel.InputDeadlockException;
import com.github.dm.jrt.channel.InputTimeoutException;
import com.github.dm.jrt.channel.InvocationChannel;
import com.github.dm.jrt.channel.OutputConsumer;
import com.github.dm.jrt.channel.RoutineException;
import com.github.dm.jrt.core.DefaultResultChannel;
import com.github.dm.jrt.core.InvocationExecution;
import com.github.dm.jrt.core.InvocationManager;
import com.github.dm.jrt.core.NestedQueue;
import com.github.dm.jrt.invocation.InvocationInterruptedException;
import com.github.dm.jrt.log.Logger;
import com.github.dm.jrt.runner.Execution;
import com.github.dm.jrt.runner.Runner;
import com.github.dm.jrt.runner.TemplateExecution;
import com.github.dm.jrt.util.TimeDuration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultInvocationChannel<IN, OUT>
implements InvocationChannel<IN, OUT> {
    private final ArrayList<Channel.OutputChannel<?>> mBoundChannels = new ArrayList();
    private final InvocationExecution<IN, OUT> mExecution;
    private final TimeDuration.Check mHasInputs;
    private final NestedQueue<IN> mInputQueue;
    private final TimeDuration mInputTimeout;
    private final Logger mLogger;
    private final int mMaxInput;
    private final Object mMutex = new Object();
    private final DefaultResultChannel<OUT> mResultChanel;
    private final Runner mRunner;
    private RoutineException mAbortException;
    private int mInputCount;
    private TimeDuration mInputDelay = TimeDuration.ZERO;
    private InvocationConfiguration.OrderType mInputOrder;
    private boolean mIsConsuming;
    private boolean mIsPendingExecution;
    private int mPendingExecutionCount;
    private InputChannelState mState;

    DefaultInvocationChannel(@NotNull InvocationConfiguration configuration, @NotNull InvocationManager<IN, OUT> manager, @NotNull Runner runner, @NotNull Logger logger) {
        this.mLogger = logger.subContextLogger(this);
        this.mRunner = runner;
        this.mInputOrder = configuration.getInputOrderTypeOr(InvocationConfiguration.OrderType.BY_CHANCE);
        this.mMaxInput = configuration.getInputMaxSizeOr(Integer.MAX_VALUE);
        this.mInputTimeout = configuration.getInputTimeoutOr(TimeDuration.ZERO);
        this.mInputQueue = new NestedQueue<IN>(){

            @Override
            public void close() {
            }
        };
        final int maxInputSize = this.mMaxInput;
        this.mHasInputs = new TimeDuration.Check(){

            public boolean isTrue() {
                return DefaultInvocationChannel.this.mInputCount <= maxInputSize;
            }
        };
        this.mResultChanel = new DefaultResultChannel(configuration, new DefaultResultChannel.AbortHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onAbort(@Nullable RoutineException reason, long delay, @NotNull TimeUnit timeUnit) {
                Execution execution;
                Object object = DefaultInvocationChannel.this.mMutex;
                synchronized (object) {
                    execution = DefaultInvocationChannel.this.mState.onHandlerAbort(reason);
                }
                if (execution != null) {
                    DefaultInvocationChannel.this.mRunner.run(execution, delay, timeUnit);
                }
            }
        }, runner, logger);
        this.mExecution = new InvocationExecution<IN, OUT>(manager, new DefaultInputIterator(), this.mResultChanel, logger);
        this.mState = new InputChannelState();
    }

    @Override
    public boolean abort() {
        return this.abort(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean abort(@Nullable Throwable reason) {
        Execution execution;
        TimeDuration delay;
        Object object = this.mMutex;
        synchronized (object) {
            delay = this.mInputDelay;
            execution = this.mState.abortInvocation(reason);
        }
        if (execution != null) {
            this.mRunner.run(execution, delay.time, delay.unit);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.mMutex;
        synchronized (object) {
            return this.mInputQueue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        Object object = this.mMutex;
        synchronized (object) {
            return this.mState.isChannelOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public InvocationChannel<IN, OUT> after(@NotNull TimeDuration delay) {
        Object object = this.mMutex;
        synchronized (object) {
            this.mState.after(delay);
        }
        return this;
    }

    @Override
    @NotNull
    public InvocationChannel<IN, OUT> after(long delay, @NotNull TimeUnit timeUnit) {
        return this.after(TimeDuration.fromUnit(delay, timeUnit));
    }

    @Override
    @NotNull
    public InvocationChannel<IN, OUT> now() {
        return this.after(TimeDuration.ZERO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public InvocationChannel<IN, OUT> orderByCall() {
        Object object = this.mMutex;
        synchronized (object) {
            this.mState.orderBy(InvocationConfiguration.OrderType.BY_CALL);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public InvocationChannel<IN, OUT> orderByChance() {
        Object object = this.mMutex;
        synchronized (object) {
            this.mState.orderBy(InvocationConfiguration.OrderType.BY_CHANCE);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public InvocationChannel<IN, OUT> orderByDelay() {
        Object object = this.mMutex;
        synchronized (object) {
            this.mState.orderBy(InvocationConfiguration.OrderType.BY_DELAY);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public InvocationChannel<IN, OUT> pass(@Nullable Channel.OutputChannel<? extends IN> channel) {
        OutputConsumer consumer;
        Object object = this.mMutex;
        synchronized (object) {
            consumer = this.mState.pass(channel);
        }
        if (consumer != null && channel != null) {
            channel.passTo(consumer);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public InvocationChannel<IN, OUT> pass(@Nullable Iterable<? extends IN> inputs) {
        Execution execution;
        TimeDuration delay;
        Object object = this.mMutex;
        synchronized (object) {
            delay = this.mInputDelay;
            execution = this.mState.pass(inputs);
        }
        if (execution != null) {
            this.mRunner.run(execution, delay.time, delay.unit);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public InvocationChannel<IN, OUT> pass(@Nullable IN input) {
        Execution execution;
        TimeDuration delay;
        Object object = this.mMutex;
        synchronized (object) {
            delay = this.mInputDelay;
            execution = this.mState.pass(input);
        }
        if (execution != null) {
            this.mRunner.run(execution, delay.time, delay.unit);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public InvocationChannel<IN, OUT> pass(IN ... inputs) {
        Execution execution;
        TimeDuration delay;
        Object object = this.mMutex;
        synchronized (object) {
            delay = this.mInputDelay;
            execution = this.mState.pass(inputs);
        }
        if (execution != null) {
            this.mRunner.run(execution, delay.time, delay.unit);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Channel.OutputChannel<OUT> result() {
        Channel.OutputChannel result;
        Execution execution;
        TimeDuration delay;
        Object object = this.mMutex;
        synchronized (object) {
            InputChannelState state = this.mState;
            delay = this.mInputDelay;
            execution = state.onResult();
            result = state.getOutputChannel();
        }
        if (execution != null) {
            this.mRunner.run(execution, delay.time, delay.unit);
        }
        return result;
    }

    private void internalAbort(@Nullable RoutineException abortException) {
        this.mInputQueue.clear();
        this.mAbortException = abortException;
        this.mRunner.cancel(this.mExecution);
    }

    private void waitInputs(int count) {
        if (this.mInputTimeout.isZero()) {
            this.mInputCount -= count;
            throw new InputTimeoutException("timeout while waiting for room in the input channel");
        }
        if (this.mRunner.isExecutionThread()) {
            this.mInputCount -= count;
            throw new InputDeadlockException("cannot wait on the invocation runner thread: " + Thread.currentThread() + "\nTry increasing the timeout or the max number of inputs");
        }
        try {
            if (!this.mInputTimeout.waitTrue(this.mMutex, this.mHasInputs)) {
                this.mInputCount -= count;
                throw new InputTimeoutException("timeout while waiting for room in the input channel");
            }
        }
        catch (InterruptedException e) {
            this.mInputCount -= count;
            throw new InvocationInterruptedException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultChannelState
    extends OutputChannelState {
        private final Logger mSubLogger;

        private ResultChannelState() {
            this.mSubLogger = DefaultInvocationChannel.this.mLogger.subContextLogger(this);
        }

        @NotNull
        private IllegalStateException exception() {
            this.mSubLogger.dbg("consumer invalid call on closed channel");
            return new IllegalStateException("the input channel is closed");
        }

        @Override
        @Nullable
        Execution onConsumerOutput(IN input, @NotNull NestedQueue<IN> queue, @NotNull TimeDuration delay, @NotNull InvocationConfiguration.OrderType orderType) {
            throw this.exception();
        }

        @Override
        @Nullable
        Execution delayedAbortInvocation(@Nullable RoutineException reason) {
            this.mSubLogger.dbg(reason, "avoiding aborting since channel is closed");
            return null;
        }

        @Override
        public boolean onConsumeComplete() {
            DefaultInvocationChannel.this.mIsConsuming = false;
            return false;
        }

        @Override
        @Nullable
        Execution delayedInput(@NotNull NestedQueue<IN> queue, @Nullable IN input) {
            this.mSubLogger.dbg("avoiding delayed input execution since channel is closed: %s", input);
            return null;
        }

        @Override
        @Nullable
        Execution delayedInputs(@NotNull NestedQueue<IN> queue, List<IN> inputs) {
            this.mSubLogger.dbg("avoiding delayed input execution since channel is closed: %s", (Object)inputs);
            return null;
        }

        @Override
        public boolean hasInput() {
            return false;
        }

        @Override
        public void onConsumeStart() {
            this.mSubLogger.wrn("avoiding consuming input since invocation is complete [#%d]", (Object)DefaultInvocationChannel.this.mPendingExecutionCount);
        }

        @Override
        @Nullable
        Execution onHandlerAbort(@Nullable RoutineException reason) {
            this.mSubLogger.dbg("avoiding aborting result channel since invocation is complete");
            return new AbortResultExecution(reason);
        }

        @Override
        @Nullable
        Execution onConsumerComplete(@NotNull NestedQueue<IN> queue) {
            throw this.exception();
        }

        @Override
        @Nullable
        Execution onConsumerError(@Nullable RoutineException error) {
            this.mSubLogger.wrn("avoiding aborting consumer since channel is closed");
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OutputChannelState
    extends InputChannelState {
        private final Logger mSubLogger;

        private OutputChannelState() {
            this.mSubLogger = DefaultInvocationChannel.this.mLogger.subContextLogger(this);
        }

        @Override
        @Nullable
        Execution abortInvocation(@Nullable Throwable reason) {
            this.mSubLogger.dbg(reason, "avoiding aborting since channel is closed");
            return null;
        }

        @Override
        void after(@NotNull TimeDuration delay) {
            throw this.exception();
        }

        @Override
        @Nullable
        Execution delayedAbortInvocation(@Nullable RoutineException reason) {
            if (DefaultInvocationChannel.this.mPendingExecutionCount <= 0 && !DefaultInvocationChannel.this.mIsConsuming) {
                this.mSubLogger.dbg(reason, "avoiding aborting since channel is closed");
                return null;
            }
            return super.delayedAbortInvocation(reason);
        }

        @NotNull
        private IllegalStateException exception() {
            this.mSubLogger.err("invalid call on closed channel");
            return new IllegalStateException("the input channel is closed");
        }

        @Override
        void orderBy(@NotNull InvocationConfiguration.OrderType orderType) {
            throw this.exception();
        }

        @Override
        boolean isChannelOpen() {
            return false;
        }

        @Override
        @Nullable
        OutputConsumer<IN> pass(@Nullable Channel.OutputChannel<? extends IN> channel) {
            throw this.exception();
        }

        @Override
        @Nullable
        Execution pass(@Nullable Iterable<? extends IN> inputs) {
            throw this.exception();
        }

        @Override
        @Nullable
        Execution pass(@Nullable IN input) {
            throw this.exception();
        }

        @Override
        @Nullable
        Execution pass(IN ... inputs) {
            throw this.exception();
        }

        @Override
        @Nullable
        Execution onResult() {
            return null;
        }

        @Override
        @NotNull
        Channel.OutputChannel<OUT> getOutputChannel() {
            throw this.exception();
        }

        @Override
        public boolean onConsumeComplete() {
            DefaultInvocationChannel.this.mIsConsuming = false;
            return DefaultInvocationChannel.this.mPendingExecutionCount <= 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InputChannelState
    implements InvocationExecution.InputIterator<IN> {
        private final Logger mSubLogger;

        private InputChannelState() {
            this.mSubLogger = DefaultInvocationChannel.this.mLogger.subContextLogger(this);
        }

        @Nullable
        Execution abortInvocation(@Nullable Throwable reason) {
            RoutineException abortException = AbortException.wrapIfNeeded(reason);
            if (DefaultInvocationChannel.this.mInputDelay.isZero()) {
                this.mSubLogger.dbg(reason, "aborting channel");
                DefaultInvocationChannel.this.internalAbort(abortException);
                DefaultInvocationChannel.this.mState = new AbortedChannelState();
                return DefaultInvocationChannel.this.mExecution.abort();
            }
            return new DelayedAbortExecution(abortException);
        }

        void after(@NotNull TimeDuration delay) {
            if (delay == null) {
                DefaultInvocationChannel.this.mLogger.err("invalid null delay");
                throw new NullPointerException("the input delay must not be null");
            }
            DefaultInvocationChannel.this.mInputDelay = delay;
        }

        @Nullable
        Execution delayedAbortInvocation(@Nullable RoutineException reason) {
            this.mSubLogger.dbg(reason, "aborting channel");
            DefaultInvocationChannel.this.internalAbort(reason);
            DefaultInvocationChannel.this.mState = new AbortedChannelState();
            return DefaultInvocationChannel.this.mExecution.abort();
        }

        @Nullable
        Execution delayedInput(@NotNull NestedQueue<IN> queue, @Nullable IN input) {
            this.mSubLogger.dbg("delayed input execution: %s", input);
            queue.add(input);
            queue.close();
            return DefaultInvocationChannel.this.mExecution;
        }

        @Nullable
        Execution delayedInputs(@NotNull NestedQueue<IN> queue, List<IN> inputs) {
            this.mSubLogger.dbg("delayed input execution: %s", (Object)inputs);
            queue.addAll(inputs);
            queue.close();
            return DefaultInvocationChannel.this.mExecution;
        }

        @NotNull
        Channel.OutputChannel<OUT> getOutputChannel() {
            DefaultInvocationChannel.this.mState = new OutputChannelState();
            return DefaultInvocationChannel.this.mResultChanel.getOutput();
        }

        boolean isChannelOpen() {
            return true;
        }

        @Nullable
        Execution onConsumerComplete(@NotNull NestedQueue<IN> queue) {
            this.mSubLogger.dbg("closing consumer");
            queue.close();
            if (!DefaultInvocationChannel.this.mIsPendingExecution && !DefaultInvocationChannel.this.mIsConsuming) {
                DefaultInvocationChannel.this.mIsPendingExecution = true;
                return DefaultInvocationChannel.this.mExecution;
            }
            --DefaultInvocationChannel.this.mPendingExecutionCount;
            return null;
        }

        @Nullable
        Execution onConsumerError(@Nullable RoutineException error) {
            this.mSubLogger.dbg("aborting consumer");
            DefaultInvocationChannel.this.mAbortException = error;
            DefaultInvocationChannel.this.mState = new ExceptionChannelState();
            DefaultInvocationChannel.this.mRunner.cancel(DefaultInvocationChannel.this.mExecution);
            return DefaultInvocationChannel.this.mExecution.abort();
        }

        @Nullable
        Execution onConsumerOutput(IN input, @NotNull NestedQueue<IN> queue, @NotNull TimeDuration delay, @NotNull InvocationConfiguration.OrderType orderType) {
            this.mSubLogger.dbg("consumer input [#%d+1]: %s [%s]", (Object)DefaultInvocationChannel.this.mInputCount, input, (Object)delay);
            ++DefaultInvocationChannel.this.mInputCount;
            if (!DefaultInvocationChannel.this.mHasInputs.isTrue()) {
                DefaultInvocationChannel.this.waitInputs(1);
                if (DefaultInvocationChannel.this.mState != this) {
                    --DefaultInvocationChannel.this.mInputCount;
                    return DefaultInvocationChannel.this.mState.onConsumerOutput(input, queue, delay, orderType);
                }
            }
            if (delay.isZero()) {
                queue.add(input);
                if (!DefaultInvocationChannel.this.mIsPendingExecution) {
                    ++DefaultInvocationChannel.this.mPendingExecutionCount;
                    DefaultInvocationChannel.this.mIsPendingExecution = true;
                    return DefaultInvocationChannel.this.mExecution;
                }
                return null;
            }
            ++DefaultInvocationChannel.this.mPendingExecutionCount;
            return new DelayedInputExecution(orderType != InvocationConfiguration.OrderType.BY_CHANCE ? queue.addNested() : queue, input);
        }

        @Nullable
        Execution onHandlerAbort(@Nullable RoutineException reason) {
            this.mSubLogger.dbg("aborting result channel");
            DefaultInvocationChannel.this.internalAbort(reason);
            DefaultInvocationChannel.this.mState = new ExceptionChannelState();
            return DefaultInvocationChannel.this.mExecution.abort();
        }

        @Nullable
        Execution onResult() {
            this.mSubLogger.dbg("closing input channel");
            if (!DefaultInvocationChannel.this.mIsPendingExecution && !DefaultInvocationChannel.this.mIsConsuming) {
                ++DefaultInvocationChannel.this.mPendingExecutionCount;
                DefaultInvocationChannel.this.mIsPendingExecution = true;
                return DefaultInvocationChannel.this.mExecution;
            }
            return null;
        }

        void orderBy(@NotNull InvocationConfiguration.OrderType orderType) {
            DefaultInvocationChannel.this.mInputOrder = orderType;
        }

        @Nullable
        OutputConsumer<IN> pass(@Nullable Channel.OutputChannel<? extends IN> channel) {
            if (channel == null) {
                this.mSubLogger.wrn("passing null channel");
                return null;
            }
            DefaultInvocationChannel.this.mBoundChannels.add(channel);
            ++DefaultInvocationChannel.this.mPendingExecutionCount;
            this.mSubLogger.dbg("passing channel: %s", (Object)channel);
            return new DefaultOutputConsumer();
        }

        @Nullable
        Execution pass(@Nullable Iterable<? extends IN> inputs) {
            if (inputs == null) {
                this.mSubLogger.wrn("passing null iterable");
                return null;
            }
            ArrayList list = new ArrayList();
            for (Object input : inputs) {
                list.add(input);
            }
            int size = list.size();
            if (size > DefaultInvocationChannel.this.mMaxInput) {
                throw new InputTimeoutException("inputs exceed maximum channel size [" + size + "/" + DefaultInvocationChannel.this.mMaxInput + "]");
            }
            TimeDuration delay = DefaultInvocationChannel.this.mInputDelay;
            this.mSubLogger.dbg("passing iterable [#%d+%d]: %s [%s]", (Object)DefaultInvocationChannel.this.mInputCount, (Object)size, (Object)inputs, (Object)delay);
            DefaultInvocationChannel.this.mInputCount += size;
            if (!DefaultInvocationChannel.this.mHasInputs.isTrue()) {
                DefaultInvocationChannel.this.waitInputs(size);
                if (DefaultInvocationChannel.this.mState != this) {
                    DefaultInvocationChannel.this.mInputCount -= size;
                    return DefaultInvocationChannel.this.mState.pass((IN)inputs);
                }
            }
            if (delay.isZero()) {
                DefaultInvocationChannel.this.mInputQueue.addAll(list);
                if (!DefaultInvocationChannel.this.mIsPendingExecution) {
                    ++DefaultInvocationChannel.this.mPendingExecutionCount;
                    DefaultInvocationChannel.this.mIsPendingExecution = true;
                    return DefaultInvocationChannel.this.mExecution;
                }
                return null;
            }
            ++DefaultInvocationChannel.this.mPendingExecutionCount;
            return new DelayedListInputExecution(DefaultInvocationChannel.this.mInputOrder != InvocationConfiguration.OrderType.BY_CHANCE ? DefaultInvocationChannel.this.mInputQueue.addNested() : DefaultInvocationChannel.this.mInputQueue, list);
        }

        @Nullable
        Execution pass(@Nullable IN input) {
            TimeDuration delay = DefaultInvocationChannel.this.mInputDelay;
            this.mSubLogger.dbg("passing input [#%d+1]: %s [%s]", (Object)DefaultInvocationChannel.this.mInputCount, input, (Object)delay);
            ++DefaultInvocationChannel.this.mInputCount;
            if (!DefaultInvocationChannel.this.mHasInputs.isTrue()) {
                DefaultInvocationChannel.this.waitInputs(1);
                if (DefaultInvocationChannel.this.mState != this) {
                    --DefaultInvocationChannel.this.mInputCount;
                    return DefaultInvocationChannel.this.mState.pass((IN)input);
                }
            }
            if (delay.isZero()) {
                DefaultInvocationChannel.this.mInputQueue.add(input);
                if (!DefaultInvocationChannel.this.mIsPendingExecution) {
                    ++DefaultInvocationChannel.this.mPendingExecutionCount;
                    DefaultInvocationChannel.this.mIsPendingExecution = true;
                    return DefaultInvocationChannel.this.mExecution;
                }
                return null;
            }
            ++DefaultInvocationChannel.this.mPendingExecutionCount;
            return new DelayedInputExecution(DefaultInvocationChannel.this.mInputOrder != InvocationConfiguration.OrderType.BY_CHANCE ? DefaultInvocationChannel.this.mInputQueue.addNested() : DefaultInvocationChannel.this.mInputQueue, input);
        }

        @Nullable
        Execution pass(IN ... inputs) {
            if (inputs == null) {
                this.mSubLogger.wrn("passing null input array");
                return null;
            }
            int size = inputs.length;
            if (size > DefaultInvocationChannel.this.mMaxInput) {
                throw new InputTimeoutException("inputs exceed maximum channel size [" + size + "/" + DefaultInvocationChannel.this.mMaxInput + "]");
            }
            TimeDuration delay = DefaultInvocationChannel.this.mInputDelay;
            this.mSubLogger.dbg("passing array [#%d+%d]: %s [%s]", (Object)DefaultInvocationChannel.this.mInputCount, (Object)size, (Object)inputs, (Object)delay);
            DefaultInvocationChannel.this.mInputCount += size;
            if (!DefaultInvocationChannel.this.mHasInputs.isTrue()) {
                DefaultInvocationChannel.this.waitInputs(size);
                if (DefaultInvocationChannel.this.mState != this) {
                    DefaultInvocationChannel.this.mInputCount -= size;
                    return DefaultInvocationChannel.this.mState.pass(inputs);
                }
            }
            ArrayList list = new ArrayList(size);
            Collections.addAll(list, inputs);
            if (delay.isZero()) {
                DefaultInvocationChannel.this.mInputQueue.addAll(list);
                if (!DefaultInvocationChannel.this.mIsPendingExecution) {
                    ++DefaultInvocationChannel.this.mPendingExecutionCount;
                    DefaultInvocationChannel.this.mIsPendingExecution = true;
                    return DefaultInvocationChannel.this.mExecution;
                }
                return null;
            }
            ++DefaultInvocationChannel.this.mPendingExecutionCount;
            return new DelayedListInputExecution(DefaultInvocationChannel.this.mInputOrder != InvocationConfiguration.OrderType.BY_CHANCE ? DefaultInvocationChannel.this.mInputQueue.addNested() : DefaultInvocationChannel.this.mInputQueue, list);
        }

        @Override
        @Nullable
        public RoutineException getAbortException() {
            return DefaultInvocationChannel.this.mAbortException;
        }

        @Override
        public boolean hasInput() {
            return !DefaultInvocationChannel.this.mInputQueue.isEmpty();
        }

        @Override
        public boolean isAborting() {
            return false;
        }

        @Override
        @Nullable
        public IN nextInput() {
            Object input = DefaultInvocationChannel.this.mInputQueue.removeFirst();
            this.mSubLogger.dbg("reading input [#%d]: %s", (Object)DefaultInvocationChannel.this.mInputCount, input);
            int maxInput = DefaultInvocationChannel.this.mMaxInput;
            int prevInputCount = DefaultInvocationChannel.this.mInputCount;
            if (--DefaultInvocationChannel.this.mInputCount <= maxInput && prevInputCount > maxInput) {
                DefaultInvocationChannel.this.mMutex.notify();
            }
            return input;
        }

        @Override
        public void onAbortComplete() {
        }

        @Override
        public boolean onConsumeComplete() {
            DefaultInvocationChannel.this.mIsConsuming = false;
            return false;
        }

        @Override
        public void onConsumeStart() {
            this.mSubLogger.dbg("consuming input [#%d]", (Object)DefaultInvocationChannel.this.mPendingExecutionCount);
            --DefaultInvocationChannel.this.mPendingExecutionCount;
            DefaultInvocationChannel.this.mIsPendingExecution = false;
            DefaultInvocationChannel.this.mIsConsuming = true;
        }

        @Override
        public void onInvocationComplete() {
            DefaultInvocationChannel.this.mState = new ResultChannelState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExceptionChannelState
    extends ResultChannelState {
        private final Logger mSubLogger;

        private ExceptionChannelState() {
            this.mSubLogger = DefaultInvocationChannel.this.mLogger.subContextLogger(this);
        }

        @Override
        void after(@NotNull TimeDuration delay) {
            throw this.exception();
        }

        @Override
        @Nullable
        Execution onConsumerOutput(IN input, @NotNull NestedQueue<IN> queue, @NotNull TimeDuration delay, @NotNull InvocationConfiguration.OrderType orderType) {
            throw this.consumerException();
        }

        @Override
        @Nullable
        Execution onHandlerAbort(@Nullable RoutineException reason) {
            this.mSubLogger.wrn("avoiding aborting result channel since invocation is aborted");
            return null;
        }

        @Override
        @Nullable
        Execution onConsumerComplete(@NotNull NestedQueue<IN> queue) {
            throw this.consumerException();
        }

        @NotNull
        private RoutineException consumerException() {
            RoutineException abortException = DefaultInvocationChannel.this.mAbortException;
            this.mSubLogger.dbg(abortException, "consumer abort exception");
            return abortException;
        }

        @NotNull
        private RoutineException exception() {
            RoutineException abortException = DefaultInvocationChannel.this.mAbortException;
            this.mSubLogger.dbg(abortException, "abort exception");
            throw abortException;
        }

        @Override
        void orderBy(@NotNull InvocationConfiguration.OrderType orderType) {
            throw this.exception();
        }

        @Override
        public boolean isAborting() {
            return true;
        }

        @Override
        public void onInvocationComplete() {
        }

        @Override
        @Nullable
        OutputConsumer<IN> pass(@Nullable Channel.OutputChannel<? extends IN> channel) {
            throw this.exception();
        }

        @Override
        @Nullable
        Execution pass(@Nullable Iterable<? extends IN> inputs) {
            throw this.exception();
        }

        @Override
        @Nullable
        Execution pass(@Nullable IN input) {
            throw this.exception();
        }

        @Override
        @Nullable
        Execution pass(IN ... inputs) {
            throw this.exception();
        }

        @Override
        @NotNull
        Channel.OutputChannel<OUT> getOutputChannel() {
            DefaultInvocationChannel.this.mState = new AbortedChannelState();
            Channel.OutputChannel outputChannel = DefaultInvocationChannel.this.mResultChanel.getOutput();
            outputChannel.abort(DefaultInvocationChannel.this.mAbortException);
            return outputChannel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DelayedListInputExecution
    extends TemplateExecution {
        private final ArrayList<IN> mInputs;
        private final NestedQueue<IN> mQueue;

        private DelayedListInputExecution(NestedQueue<IN> queue, ArrayList<IN> inputs) {
            this.mInputs = inputs;
            this.mQueue = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Execution execution;
            Object object = DefaultInvocationChannel.this.mMutex;
            synchronized (object) {
                execution = DefaultInvocationChannel.this.mState.delayedInputs(this.mQueue, this.mInputs);
            }
            if (execution != null) {
                execution.run();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DelayedInputExecution
    extends TemplateExecution {
        private final IN mInput;
        private final NestedQueue<IN> mQueue;

        private DelayedInputExecution(@Nullable NestedQueue<IN> queue, IN input) {
            this.mQueue = queue;
            this.mInput = input;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Execution execution;
            Object object = DefaultInvocationChannel.this.mMutex;
            synchronized (object) {
                execution = DefaultInvocationChannel.this.mState.delayedInput(this.mQueue, this.mInput);
            }
            if (execution != null) {
                execution.run();
            }
        }
    }

    private class DelayedAbortExecution
    extends TemplateExecution {
        private final RoutineException mAbortException;

        private DelayedAbortExecution(RoutineException reason) {
            this.mAbortException = reason;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Execution execution;
            Object object = DefaultInvocationChannel.this.mMutex;
            synchronized (object) {
                execution = DefaultInvocationChannel.this.mState.delayedAbortInvocation(this.mAbortException);
            }
            if (execution != null) {
                execution.run();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultOutputConsumer
    implements OutputConsumer<IN> {
        private final TimeDuration mDelay;
        private final InvocationConfiguration.OrderType mOrderType;
        private final NestedQueue<IN> mQueue;

        private DefaultOutputConsumer() {
            TimeDuration delay = this.mDelay = DefaultInvocationChannel.this.mInputDelay;
            InvocationConfiguration.OrderType order = this.mOrderType = DefaultInvocationChannel.this.mInputOrder;
            this.mQueue = order == InvocationConfiguration.OrderType.BY_CALL || order == InvocationConfiguration.OrderType.BY_DELAY && delay.isZero() ? DefaultInvocationChannel.this.mInputQueue.addNested() : DefaultInvocationChannel.this.mInputQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            Execution execution;
            Object object = DefaultInvocationChannel.this.mMutex;
            synchronized (object) {
                execution = DefaultInvocationChannel.this.mState.onConsumerComplete(this.mQueue);
            }
            if (execution != null) {
                DefaultInvocationChannel.this.mRunner.run(execution, 0L, TimeUnit.MILLISECONDS);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(@Nullable RoutineException error) {
            Execution execution;
            Object object = DefaultInvocationChannel.this.mMutex;
            synchronized (object) {
                execution = DefaultInvocationChannel.this.mState.onConsumerError(error);
            }
            if (execution != null) {
                TimeDuration delay = this.mDelay;
                DefaultInvocationChannel.this.mRunner.run(execution, delay.time, delay.unit);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onOutput(IN output) {
            Execution execution;
            TimeDuration delay = this.mDelay;
            Object object = DefaultInvocationChannel.this.mMutex;
            synchronized (object) {
                execution = DefaultInvocationChannel.this.mState.onConsumerOutput(output, this.mQueue, delay, this.mOrderType);
            }
            if (execution != null) {
                DefaultInvocationChannel.this.mRunner.run(execution, delay.time, delay.unit);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultInputIterator
    implements InvocationExecution.InputIterator<IN> {
        private DefaultInputIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public RoutineException getAbortException() {
            Object object = DefaultInvocationChannel.this.mMutex;
            synchronized (object) {
                return DefaultInvocationChannel.this.mState.getAbortException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasInput() {
            Object object = DefaultInvocationChannel.this.mMutex;
            synchronized (object) {
                return DefaultInvocationChannel.this.mState.hasInput();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isAborting() {
            Object object = DefaultInvocationChannel.this.mMutex;
            synchronized (object) {
                return DefaultInvocationChannel.this.mState.isAborting();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public IN nextInput() {
            Object object = DefaultInvocationChannel.this.mMutex;
            synchronized (object) {
                return DefaultInvocationChannel.this.mState.nextInput();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAbortComplete() {
            ArrayList channels;
            RoutineException abortException;
            Object object = DefaultInvocationChannel.this.mMutex;
            synchronized (object) {
                abortException = DefaultInvocationChannel.this.mAbortException;
                DefaultInvocationChannel.this.mLogger.dbg((Throwable)abortException, "aborting bound channels [%d]", (Object)DefaultInvocationChannel.this.mBoundChannels.size());
                channels = new ArrayList(DefaultInvocationChannel.this.mBoundChannels);
                DefaultInvocationChannel.this.mBoundChannels.clear();
            }
            for (Channel.OutputChannel channel : channels) {
                channel.abort(abortException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onConsumeComplete() {
            Object object = DefaultInvocationChannel.this.mMutex;
            synchronized (object) {
                return DefaultInvocationChannel.this.mState.onConsumeComplete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConsumeStart() {
            Object object = DefaultInvocationChannel.this.mMutex;
            synchronized (object) {
                DefaultInvocationChannel.this.mState.onConsumeStart();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onInvocationComplete() {
            Object object = DefaultInvocationChannel.this.mMutex;
            synchronized (object) {
                DefaultInvocationChannel.this.mState.onInvocationComplete();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AbortedChannelState
    extends ExceptionChannelState {
        private AbortedChannelState() {
        }

        @Override
        @NotNull
        Channel.OutputChannel<OUT> getOutputChannel() {
            throw ((ExceptionChannelState)this).exception();
        }
    }

    private class AbortResultExecution
    extends TemplateExecution {
        private final Throwable mAbortException;

        private AbortResultExecution(Throwable reason) {
            this.mAbortException = reason;
        }

        public void run() {
            DefaultInvocationChannel.this.mResultChanel.close(this.mAbortException);
        }
    }
}

