/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.core;

import com.github.dm.jrt.annotation.Input;
import com.github.dm.jrt.annotation.Output;
import com.github.dm.jrt.builder.InvocationConfiguration;
import com.github.dm.jrt.builder.ObjectRoutineBuilder;
import com.github.dm.jrt.builder.ProxyConfiguration;
import com.github.dm.jrt.channel.ResultChannel;
import com.github.dm.jrt.core.DefaultRoutine;
import com.github.dm.jrt.core.InvocationTarget;
import com.github.dm.jrt.core.RoutineBuilders;
import com.github.dm.jrt.invocation.FunctionInvocation;
import com.github.dm.jrt.invocation.Invocation;
import com.github.dm.jrt.invocation.InvocationFactory;
import com.github.dm.jrt.routine.Routine;
import com.github.dm.jrt.util.ClassToken;
import com.github.dm.jrt.util.Mutex;
import com.github.dm.jrt.util.Reflection;
import com.github.dm.jrt.util.WeakIdentityHashMap;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultObjectRoutineBuilder
implements ObjectRoutineBuilder,
InvocationConfiguration.Configurable<ObjectRoutineBuilder>,
ProxyConfiguration.Configurable<ObjectRoutineBuilder> {
    private static final WeakIdentityHashMap<Object, HashMap<RoutineInfo, Routine<?, ?>>> sRoutines = new WeakIdentityHashMap();
    private final InvocationTarget<?> mTarget;
    private InvocationConfiguration mInvocationConfiguration = InvocationConfiguration.DEFAULT_CONFIGURATION;
    private ProxyConfiguration mProxyConfiguration = ProxyConfiguration.DEFAULT_CONFIGURATION;

    DefaultObjectRoutineBuilder(@NotNull InvocationTarget<?> target) {
        Class<?> targetClass = target.getTargetClass();
        if (targetClass.isInterface()) {
            throw new IllegalArgumentException("the target class must not be an interface: " + targetClass.getName());
        }
        this.mTarget = target;
    }

    @Override
    @NotNull
    public <IN, OUT> Routine<IN, OUT> aliasMethod(@NotNull String name) {
        Method method = RoutineBuilders.getAnnotatedMethod(this.mTarget.getTargetClass(), name);
        if (method == null) {
            throw new IllegalArgumentException("no annotated method with alias '" + name + "' has been found");
        }
        return this.method(method);
    }

    @Override
    @NotNull
    public <TYPE> TYPE buildProxy(@NotNull ClassToken<TYPE> itf) {
        return itf.cast(this.buildProxy(itf.getRawClass()));
    }

    @Override
    @NotNull
    public <TYPE> TYPE buildProxy(@NotNull Class<TYPE> itf) {
        if (!itf.isInterface()) {
            throw new IllegalArgumentException("the specified class is not an interface: " + itf.getName());
        }
        Object proxy = Proxy.newProxyInstance(itf.getClassLoader(), new Class[]{itf}, (InvocationHandler)new ProxyInvocationHandler());
        return itf.cast(proxy);
    }

    @Override
    @NotNull
    public <IN, OUT> Routine<IN, OUT> method(@NotNull String name, Class<?> ... parameterTypes) {
        return this.method(Reflection.findMethod(this.mTarget.getTargetClass(), name, parameterTypes));
    }

    @Override
    @NotNull
    public <IN, OUT> Routine<IN, OUT> method(@NotNull Method method) {
        return this.getRoutine(RoutineBuilders.configurationWithAnnotations(this.mInvocationConfiguration, method), RoutineBuilders.configurationWithAnnotations(this.mProxyConfiguration, method), method, null, null);
    }

    @Override
    @NotNull
    public InvocationConfiguration.Builder<? extends ObjectRoutineBuilder> invocations() {
        InvocationConfiguration configuration = this.mInvocationConfiguration;
        return new InvocationConfiguration.Builder<ObjectRoutineBuilder>(this, configuration);
    }

    @Override
    @NotNull
    public ProxyConfiguration.Builder<? extends ObjectRoutineBuilder> proxies() {
        ProxyConfiguration configuration = this.mProxyConfiguration;
        return new ProxyConfiguration.Builder<ObjectRoutineBuilder>(this, configuration);
    }

    @Override
    @NotNull
    public ObjectRoutineBuilder setConfiguration(@NotNull ProxyConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("the proxy configuration must not be null");
        }
        this.mProxyConfiguration = configuration;
        return this;
    }

    @Override
    @NotNull
    public ObjectRoutineBuilder setConfiguration(@NotNull InvocationConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("the invocation configuration must not be null");
        }
        this.mInvocationConfiguration = configuration;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private <IN, OUT> Routine<IN, OUT> getRoutine(@NotNull InvocationConfiguration invocationConfiguration, @NotNull ProxyConfiguration proxyConfiguration, @NotNull Method method, @Nullable Input.InputMode inputMode, @Nullable Output.OutputMode outputMode) {
        InvocationTarget<?> target = this.mTarget;
        Object targetInstance = target.getTarget();
        if (targetInstance == null) {
            throw new IllegalStateException("the target object has been destroyed");
        }
        WeakIdentityHashMap<Object, HashMap<RoutineInfo, Routine<?, ?>>> weakIdentityHashMap = sRoutines;
        synchronized (weakIdentityHashMap) {
            RoutineInfo routineInfo;
            Routine<Object, Object> routine;
            WeakIdentityHashMap<Object, HashMap<RoutineInfo, Routine<?, ?>>> routines = sRoutines;
            HashMap<RoutineInfo, Routine<Object, Object>> routineMap = routines.get(targetInstance);
            if (routineMap == null) {
                routineMap = new HashMap();
                routines.put(targetInstance, routineMap);
            }
            if ((routine = routineMap.get(routineInfo = new RoutineInfo(invocationConfiguration, proxyConfiguration, method, inputMode, outputMode))) == null) {
                MethodInvocationFactory factory = new MethodInvocationFactory(proxyConfiguration, target, method, inputMode, outputMode);
                routine = new DefaultRoutine<Object, Object>(invocationConfiguration, factory);
                routineMap.put(routineInfo, routine);
            }
            return routine;
        }
    }

    private class ProxyInvocationHandler
    implements InvocationHandler {
        private final InvocationConfiguration mInvocationConfiguration;
        private final ProxyConfiguration mProxyConfiguration;

        private ProxyInvocationHandler() {
            this.mInvocationConfiguration = DefaultObjectRoutineBuilder.this.mInvocationConfiguration;
            this.mProxyConfiguration = DefaultObjectRoutineBuilder.this.mProxyConfiguration;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            RoutineBuilders.MethodInfo methodInfo = RoutineBuilders.getTargetMethodInfo(DefaultObjectRoutineBuilder.this.mTarget.getTargetClass(), method);
            Input.InputMode inputMode = methodInfo.inputMode;
            Output.OutputMode outputMode = methodInfo.outputMode;
            Routine routine = DefaultObjectRoutineBuilder.this.getRoutine(RoutineBuilders.configurationWithAnnotations(this.mInvocationConfiguration, method), RoutineBuilders.configurationWithAnnotations(this.mProxyConfiguration, method), methodInfo.method, inputMode, outputMode);
            return RoutineBuilders.invokeRoutine(routine, method, Reflection.asArgs(args), methodInfo.invocationMode, inputMode, outputMode);
        }
    }

    private static final class RoutineInfo {
        private final Input.InputMode mInputMode;
        private final InvocationConfiguration mInvocationConfiguration;
        private final Method mMethod;
        private final Output.OutputMode mOutputMode;
        private final ProxyConfiguration mProxyConfiguration;

        private RoutineInfo(@NotNull InvocationConfiguration invocationConfiguration, @NotNull ProxyConfiguration proxyConfiguration, @NotNull Method method, @Nullable Input.InputMode inputMode, @Nullable Output.OutputMode outputMode) {
            this.mInvocationConfiguration = invocationConfiguration;
            this.mProxyConfiguration = proxyConfiguration;
            this.mMethod = method;
            this.mInputMode = inputMode;
            this.mOutputMode = outputMode;
        }

        public int hashCode() {
            int result = this.mInputMode != null ? this.mInputMode.hashCode() : 0;
            result = 31 * result + this.mInvocationConfiguration.hashCode();
            result = 31 * result + this.mMethod.hashCode();
            result = 31 * result + (this.mOutputMode != null ? this.mOutputMode.hashCode() : 0);
            result = 31 * result + this.mProxyConfiguration.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RoutineInfo)) {
                return false;
            }
            RoutineInfo that = (RoutineInfo)o;
            return this.mInputMode == that.mInputMode && this.mInvocationConfiguration.equals(that.mInvocationConfiguration) && this.mMethod.equals(that.mMethod) && this.mOutputMode == that.mOutputMode && this.mProxyConfiguration.equals(that.mProxyConfiguration);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodInvocationFactory
    extends InvocationFactory<Object, Object> {
        private final Input.InputMode mInputMode;
        private final Method mMethod;
        private final Output.OutputMode mOutputMode;
        private final ProxyConfiguration mProxyConfiguration;
        private final InvocationTarget<?> mTarget;

        private MethodInvocationFactory(@NotNull ProxyConfiguration proxyConfiguration, @NotNull InvocationTarget<?> target, @NotNull Method method, @Nullable Input.InputMode inputMode, @Nullable Output.OutputMode outputMode) {
            this.mProxyConfiguration = proxyConfiguration;
            this.mTarget = target;
            this.mMethod = method;
            this.mInputMode = inputMode;
            this.mOutputMode = outputMode;
        }

        @Override
        @NotNull
        public Invocation<Object, Object> newInvocation() {
            return new MethodFunctionInvocation(this.mProxyConfiguration, this.mTarget, this.mMethod, this.mInputMode, this.mOutputMode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodFunctionInvocation
    extends FunctionInvocation<Object, Object> {
        private final Input.InputMode mInputMode;
        private final Method mMethod;
        private final Mutex mMutex;
        private final Output.OutputMode mOutputMode;
        private final InvocationTarget<?> mTarget;

        private MethodFunctionInvocation(@NotNull ProxyConfiguration proxyConfiguration, @NotNull InvocationTarget<?> target, @NotNull Method method, @Nullable Input.InputMode inputMode, @Nullable Output.OutputMode outputMode) {
            Object mutexTarget = Modifier.isStatic(method.getModifiers()) ? target.getTargetClass() : target.getTarget();
            this.mMutex = RoutineBuilders.getSharedMutex(mutexTarget, proxyConfiguration.getSharedFieldsOr(null));
            this.mTarget = target;
            this.mMethod = method;
            this.mInputMode = inputMode;
            this.mOutputMode = outputMode;
        }

        @Override
        protected void onCall(@NotNull List<?> objects, @NotNull ResultChannel<Object> result) {
            Object target = this.mTarget.getTarget();
            if (target == null) {
                throw new IllegalStateException("the target object has been destroyed");
            }
            RoutineBuilders.callFromInvocation(this.mMutex, target, this.mMethod, objects, result, this.mInputMode, this.mOutputMode);
        }
    }
}

