/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.core;

import com.github.dm.jrt.builder.InvocationConfiguration;
import com.github.dm.jrt.channel.AbortException;
import com.github.dm.jrt.channel.Channel;
import com.github.dm.jrt.channel.ExecutionDeadlockException;
import com.github.dm.jrt.channel.ExecutionTimeoutException;
import com.github.dm.jrt.channel.OutputConsumer;
import com.github.dm.jrt.channel.OutputDeadlockException;
import com.github.dm.jrt.channel.OutputTimeoutException;
import com.github.dm.jrt.channel.ResultChannel;
import com.github.dm.jrt.channel.RoutineException;
import com.github.dm.jrt.core.NestedQueue;
import com.github.dm.jrt.core.RoutineExceptionWrapper;
import com.github.dm.jrt.invocation.InvocationDeadlockException;
import com.github.dm.jrt.invocation.InvocationException;
import com.github.dm.jrt.invocation.InvocationInterruptedException;
import com.github.dm.jrt.log.Logger;
import com.github.dm.jrt.runner.Execution;
import com.github.dm.jrt.runner.Runner;
import com.github.dm.jrt.runner.TemplateExecution;
import com.github.dm.jrt.util.Time;
import com.github.dm.jrt.util.TimeDuration;
import com.github.dm.jrt.util.WeakIdentityHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultResultChannel<OUT>
implements ResultChannel<OUT> {
    private static final String INVOCATION_DEADLOCK_MESSAGE = "cannot wait while no invocation instance is available\nTry increasing the max number of instances";
    private static final WeakIdentityHashMap<OutputConsumer<?>, Object> sConsumerMutexes = new WeakIdentityHashMap();
    private final ArrayList<Channel.OutputChannel<?>> mBoundChannels = new ArrayList();
    private final TimeDuration mExecutionTimeout;
    private final Object mFlushMutex = new Object();
    private final AbortHandler mHandler;
    private final TimeDuration.Check mHasOutputs;
    private final Logger mLogger;
    private final int mMaxOutput;
    private final Object mMutex = new Object();
    private final NestedQueue<Object> mOutputQueue;
    private final TimeDuration mOutputTimeout;
    private final Runner mRunner;
    private final InvocationConfiguration.TimeoutActionType mTimeoutActionType;
    private RoutineException mAbortException;
    private Object mConsumerMutex;
    private boolean mIsWaitingInvocation;
    private OutputConsumer<? super OUT> mOutputConsumer;
    private int mOutputCount;
    private TimeDuration.Check mOutputHasNext;
    private TimeDuration.Check mOutputNotEmpty;
    private int mPendingOutputCount;
    private TimeDuration mResultDelay = TimeDuration.ZERO;
    private InvocationConfiguration.OrderType mResultOrder;
    private OutputChannelState mState;

    DefaultResultChannel(@NotNull InvocationConfiguration configuration, @NotNull AbortHandler handler, @NotNull Runner runner, @NotNull Logger logger) {
        if (handler == null) {
            throw new NullPointerException("the abort handler must not be null");
        }
        if (runner == null) {
            throw new NullPointerException("the runner instance must not be null");
        }
        this.mLogger = logger.subContextLogger(this);
        this.mHandler = handler;
        this.mRunner = runner;
        this.mResultOrder = configuration.getOutputOrderTypeOr(InvocationConfiguration.OrderType.BY_CHANCE);
        this.mExecutionTimeout = configuration.getReadTimeoutOr(TimeDuration.ZERO);
        this.mTimeoutActionType = configuration.getReadTimeoutActionOr(InvocationConfiguration.TimeoutActionType.THROW);
        this.mMaxOutput = configuration.getOutputMaxSizeOr(Integer.MAX_VALUE);
        this.mOutputTimeout = configuration.getOutputTimeoutOr(TimeDuration.ZERO);
        this.mOutputQueue = new NestedQueue<Object>(){

            @Override
            public void close() {
            }
        };
        final int maxOutputSize = this.mMaxOutput;
        this.mHasOutputs = new TimeDuration.Check(){

            public boolean isTrue() {
                return DefaultResultChannel.this.mOutputCount <= maxOutputSize || DefaultResultChannel.this.mIsWaitingInvocation;
            }
        };
        this.mState = new OutputChannelState();
    }

    @NotNull
    private static String getExecutionDeadlockMessage() {
        return "cannot wait on the invocation runner thread: " + Thread.currentThread() + "\nTry binding the output channel or employing a different runner";
    }

    @NotNull
    private static String getInvocationDeadlockMessage() {
        return INVOCATION_DEADLOCK_MESSAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Object getMutex(@NotNull OutputConsumer<?> consumer) {
        WeakIdentityHashMap<OutputConsumer<?>, Object> weakIdentityHashMap = sConsumerMutexes;
        synchronized (weakIdentityHashMap) {
            WeakIdentityHashMap<OutputConsumer<?>, Object> consumerMutexes = sConsumerMutexes;
            Object mutex = consumerMutexes.get(consumer);
            if (mutex == null) {
                mutex = new Object();
                consumerMutexes.put(consumer, mutex);
            }
            return mutex;
        }
    }

    @Override
    public boolean abort() {
        return this.abort(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ResultChannel<OUT> after(@NotNull TimeDuration delay) {
        Object object = this.mMutex;
        synchronized (object) {
            this.mState.after(delay);
        }
        return this;
    }

    @Override
    @NotNull
    public ResultChannel<OUT> after(long delay, @NotNull TimeUnit timeUnit) {
        return this.after(TimeDuration.fromUnit(delay, timeUnit));
    }

    @Override
    @NotNull
    public ResultChannel<OUT> now() {
        return this.after(TimeDuration.ZERO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ResultChannel<OUT> orderByCall() {
        Object object = this.mMutex;
        synchronized (object) {
            this.mState.orderBy(InvocationConfiguration.OrderType.BY_CALL);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ResultChannel<OUT> orderByChance() {
        Object object = this.mMutex;
        synchronized (object) {
            this.mState.orderBy(InvocationConfiguration.OrderType.BY_CHANCE);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ResultChannel<OUT> orderByDelay() {
        Object object = this.mMutex;
        synchronized (object) {
            this.mState.orderBy(InvocationConfiguration.OrderType.BY_DELAY);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ResultChannel<OUT> pass(@Nullable Channel.OutputChannel<? extends OUT> channel) {
        OutputConsumer consumer;
        Object object = this.mMutex;
        synchronized (object) {
            consumer = this.mState.pass(channel);
        }
        if (consumer != null && channel != null) {
            channel.passTo(consumer);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ResultChannel<OUT> pass(@Nullable Iterable<? extends OUT> outputs) {
        Execution execution;
        TimeDuration delay;
        Object object = this.mMutex;
        synchronized (object) {
            delay = this.mResultDelay;
            execution = this.mState.pass(outputs);
        }
        if (delay.isZero()) {
            this.flushOutput(false);
        } else if (execution != null) {
            this.mRunner.run(execution, delay.time, delay.unit);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ResultChannel<OUT> pass(@Nullable OUT output) {
        Execution execution;
        TimeDuration delay;
        Object object = this.mMutex;
        synchronized (object) {
            delay = this.mResultDelay;
            execution = this.mState.pass(output);
        }
        if (delay.isZero()) {
            this.flushOutput(false);
        } else if (execution != null) {
            this.mRunner.run(execution, delay.time, delay.unit);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ResultChannel<OUT> pass(OUT ... outputs) {
        Execution execution;
        TimeDuration delay;
        Object object = this.mMutex;
        synchronized (object) {
            delay = this.mResultDelay;
            execution = this.mState.pass(outputs);
        }
        if (delay.isZero()) {
            this.flushOutput(false);
        } else if (execution != null) {
            this.mRunner.run(execution, delay.time, delay.unit);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abortImmediately(@Nullable Throwable reason) {
        RoutineException abortException = InvocationException.wrapIfNeeded(reason);
        Object object = this.mMutex;
        synchronized (object) {
            abortException = this.mState.abortInvocation(abortException, TimeDuration.ZERO);
        }
        if (abortException != null) {
            this.mHandler.onAbort(abortException, 0L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(@Nullable Throwable throwable) {
        ArrayList channels;
        RoutineException abortException = InvocationException.wrapIfNeeded(throwable);
        Object object = this.mMutex;
        synchronized (object) {
            this.mLogger.dbg(throwable, "aborting result channel");
            channels = new ArrayList(this.mBoundChannels);
            this.mBoundChannels.clear();
            this.mOutputQueue.add(RoutineExceptionWrapper.wrap(throwable));
            this.mPendingOutputCount = 0;
            if (this.mAbortException == null) {
                this.mAbortException = abortException;
            }
            this.mState = new AbortChannelState();
            this.mMutex.notifyAll();
        }
        for (Channel.OutputChannel<?> channel : channels) {
            channel.abort(abortException);
        }
        this.flushOutput(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        boolean needsFlush;
        Object object = this.mMutex;
        synchronized (object) {
            needsFlush = this.mState.closeResultChannel();
        }
        if (needsFlush) {
            this.flushOutput(false);
        }
    }

    @NotNull
    Channel.OutputChannel<OUT> getOutput() {
        InvocationConfiguration.TimeoutActionType action = this.mTimeoutActionType;
        Channel.OutputChannel outputChannel = new DefaultOutputChannel().afterMax(this.mExecutionTimeout);
        if (action == InvocationConfiguration.TimeoutActionType.EXIT) {
            outputChannel.eventuallyExit();
        } else if (action == InvocationConfiguration.TimeoutActionType.ABORT) {
            outputChannel.eventuallyAbort();
        }
        return outputChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startWaitingInvocation() {
        Object object = this.mMutex;
        synchronized (object) {
            this.mIsWaitingInvocation = true;
            this.mMutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopWaitingInvocation() {
        Object object = this.mMutex;
        synchronized (object) {
            this.mIsWaitingInvocation = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConsumer(@NotNull OutputChannelState state, @NotNull OutputConsumer<? super OUT> consumer) {
        state.closeConsumer(consumer);
        Object object = this.mMutex;
        synchronized (object) {
            OutputChannelState currentState = this.mState;
            if (currentState.isReadyToComplete()) {
                this.mState = currentState.toDoneState();
                this.mMutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushOutput(boolean forceClose) {
        RoutineException abortException = null;
        Object object = this.mFlushMutex;
        synchronized (object) {
            ArrayList outputs;
            OutputConsumer consumer;
            boolean isFinal;
            OutputChannelState state;
            Logger logger = this.mLogger;
            Object object2 = this.mMutex;
            synchronized (object2) {
                state = this.mState;
                isFinal = state.isReadyToComplete();
                consumer = this.mOutputConsumer;
                if (consumer == null) {
                    logger.dbg("avoiding flushing output since channel is not bound");
                    if (isFinal) {
                        this.mState = state.toDoneState();
                    }
                    this.mMutex.notifyAll();
                    return;
                }
                outputs = new ArrayList();
                this.mOutputQueue.drainTo(outputs);
                this.mOutputCount = 0;
                this.mMutex.notifyAll();
            }
            object2 = this.mConsumerMutex;
            synchronized (object2) {
                block25: {
                    try {
                        for (Object output : outputs) {
                            if (output instanceof RoutineExceptionWrapper) {
                                try {
                                    logger.dbg("aborting consumer (%s): %s", (Object)consumer, output);
                                    consumer.onError(((RoutineExceptionWrapper)output).raise());
                                }
                                catch (Throwable t) {
                                    InvocationInterruptedException.throwIfInterrupt(t);
                                    logger.err(t, "ignoring consumer exception (%s)", (Object)consumer);
                                }
                                break;
                            }
                            logger.dbg("output consumer (%s): %s", (Object)consumer, output);
                            consumer.onOutput(output);
                        }
                        if (forceClose || isFinal) {
                            this.closeConsumer(state, consumer);
                        }
                    }
                    catch (InvocationInterruptedException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        OutputChannelState finalState;
                        boolean isClose = false;
                        Object object3 = this.mMutex;
                        synchronized (object3) {
                            finalState = this.mState;
                            logger.wrn(t, "consumer exception (%s)", (Object)consumer);
                            if (forceClose || finalState.isReadyToComplete()) {
                                isClose = true;
                            } else {
                                abortException = finalState.abortConsumer(t);
                            }
                        }
                        if (!isClose) break block25;
                        this.closeConsumer(finalState, consumer);
                    }
                }
            }
        }
        if (abortException != null) {
            this.mHandler.onAbort(abortException, 0L, TimeUnit.MILLISECONDS);
        }
    }

    private void internalAbort(@Nullable RoutineException abortException) {
        this.mOutputQueue.clear();
        this.mPendingOutputCount = 0;
        this.mAbortException = abortException;
        this.mState = new ExceptionChannelState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNextAvailable(@NotNull TimeDuration timeout, @NotNull InvocationConfiguration.TimeoutActionType timeoutAction, @Nullable Throwable timeoutException) {
        boolean isAbort = false;
        Object object = this.mMutex;
        synchronized (object) {
            this.verifyBound();
            Logger logger = this.mLogger;
            final NestedQueue<Object> outputQueue = this.mOutputQueue;
            boolean isDone = this.mState.isDone();
            if (timeout.isZero() || isDone) {
                if (outputQueue.isEmpty() && !isDone) {
                    logger.wrn("has output timeout: [%s] => [%s]", (Object)timeout, (Object)timeoutAction);
                    if (timeoutAction == InvocationConfiguration.TimeoutActionType.THROW) {
                        throw new ExecutionTimeoutException("timeout while waiting to know if more outputs are coming");
                    }
                    isAbort = timeoutAction == InvocationConfiguration.TimeoutActionType.ABORT;
                }
            } else {
                boolean isTimeout;
                if (!outputQueue.isEmpty()) {
                    logger.dbg("has output: true [%s]", (Object)timeout);
                    return true;
                }
                if (this.mRunner.isExecutionThread()) {
                    throw new ExecutionDeadlockException(DefaultResultChannel.getExecutionDeadlockMessage());
                }
                if (this.mIsWaitingInvocation) {
                    throw new InvocationDeadlockException(DefaultResultChannel.getInvocationDeadlockMessage());
                }
                if (this.mOutputHasNext == null) {
                    this.mOutputHasNext = new TimeDuration.Check(){

                        public boolean isTrue() {
                            return !outputQueue.isEmpty() || DefaultResultChannel.this.mState.isDone() || DefaultResultChannel.this.mIsWaitingInvocation;
                        }
                    };
                }
                try {
                    isTimeout = !timeout.waitTrue(this.mMutex, this.mOutputHasNext);
                }
                catch (InterruptedException e) {
                    throw new InvocationInterruptedException(e);
                }
                if (this.mIsWaitingInvocation) {
                    throw new InvocationDeadlockException(DefaultResultChannel.getInvocationDeadlockMessage());
                }
                if (isTimeout) {
                    logger.wrn("has output timeout: [%s] => [%s]", (Object)timeout, (Object)timeoutAction);
                    if (timeoutAction == InvocationConfiguration.TimeoutActionType.THROW) {
                        throw new ExecutionTimeoutException("timeout while waiting to know if more outputs are coming");
                    }
                    boolean bl = isAbort = timeoutAction == InvocationConfiguration.TimeoutActionType.ABORT;
                }
            }
            if (!isAbort) {
                boolean hasNext = !outputQueue.isEmpty();
                logger.dbg("has output: %s [%s]", (Object)hasNext, (Object)timeout);
                return hasNext;
            }
        }
        this.abort(timeoutException);
        throw AbortException.wrapIfNeeded(timeoutException);
    }

    @Nullable
    private OUT nextOutput(@NotNull TimeDuration timeout) {
        Object result = this.mOutputQueue.removeFirst();
        this.mLogger.dbg("reading output [#%d]: %s [%s]", (Object)this.mOutputCount, result, (Object)timeout);
        if (result instanceof RoutineExceptionWrapper) {
            this.mOutputQueue.add(result);
            throw ((RoutineExceptionWrapper)result).raise();
        }
        int maxOutput = this.mMaxOutput;
        int prevOutputCount = this.mOutputCount--;
        if (this.mOutputCount <= maxOutput && prevOutputCount > maxOutput) {
            this.mMutex.notifyAll();
        }
        return (OUT)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private OUT readNext(@NotNull TimeDuration timeout, @NotNull InvocationConfiguration.TimeoutActionType timeoutAction, @Nullable Throwable timeoutException) {
        boolean isAbort = false;
        try {
            Object object = this.mMutex;
            synchronized (object) {
                isAbort = timeoutAction == InvocationConfiguration.TimeoutActionType.ABORT;
                return this.readQueue(timeout, timeoutAction);
            }
        }
        catch (NoSuchElementException e) {
            if (isAbort) {
                this.abort(timeoutException);
                throw AbortException.wrapIfNeeded(timeoutException);
            }
            throw e;
        }
    }

    @Nullable
    private OUT readQueue(@NotNull TimeDuration timeout, @NotNull InvocationConfiguration.TimeoutActionType action) {
        boolean isTimeout;
        this.verifyBound();
        Logger logger = this.mLogger;
        final NestedQueue<Object> outputQueue = this.mOutputQueue;
        if (timeout.isZero() || !outputQueue.isEmpty()) {
            if (outputQueue.isEmpty()) {
                logger.wrn("reading output timeout: [%s] => [%s]", (Object)timeout, (Object)action);
                if (action == InvocationConfiguration.TimeoutActionType.THROW) {
                    throw new ExecutionTimeoutException("timeout while waiting for outputs");
                }
            }
            return this.nextOutput(timeout);
        }
        if (this.mRunner.isExecutionThread()) {
            throw new ExecutionDeadlockException(DefaultResultChannel.getExecutionDeadlockMessage());
        }
        if (this.mIsWaitingInvocation) {
            throw new InvocationDeadlockException(DefaultResultChannel.getInvocationDeadlockMessage());
        }
        if (this.mOutputNotEmpty == null) {
            this.mOutputNotEmpty = new TimeDuration.Check(){

                public boolean isTrue() {
                    return !outputQueue.isEmpty() || DefaultResultChannel.this.mState.isDone() || DefaultResultChannel.this.mIsWaitingInvocation;
                }
            };
        }
        try {
            isTimeout = !timeout.waitTrue(this.mMutex, this.mOutputNotEmpty);
        }
        catch (InterruptedException e) {
            throw new InvocationInterruptedException(e);
        }
        if (this.mIsWaitingInvocation) {
            throw new InvocationDeadlockException(DefaultResultChannel.getInvocationDeadlockMessage());
        }
        if (isTimeout) {
            logger.wrn("reading output timeout: [%s] => [%s]", (Object)timeout, (Object)action);
            if (action == InvocationConfiguration.TimeoutActionType.THROW) {
                throw new ExecutionTimeoutException("timeout while waiting for outputs");
            }
        }
        return this.nextOutput(timeout);
    }

    private void verifyBound() {
        if (this.mOutputConsumer != null) {
            this.mLogger.err("invalid call on bound channel");
            throw new IllegalStateException("the channel is already bound");
        }
    }

    private void waitOutputs(int count, @NotNull TimeDuration delay) {
        if (this.mOutputTimeout.isZero()) {
            this.mOutputCount -= count;
            throw new OutputTimeoutException("timeout while waiting for room in the output channel");
        }
        if (!delay.isZero() && this.mRunner.isExecutionThread()) {
            this.mOutputCount -= count;
            throw new OutputDeadlockException("cannot wait on the invocation runner thread: " + Thread.currentThread() + "\nTry increasing the timeout or the max number of outputs");
        }
        try {
            if (!this.mOutputTimeout.waitTrue(this.mMutex, this.mHasOutputs)) {
                this.mOutputCount -= count;
                throw new OutputTimeoutException("timeout while waiting for room in the output channel");
            }
        }
        catch (InterruptedException e) {
            this.mOutputCount -= count;
            throw new InvocationInterruptedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean abort(@Nullable Throwable reason) {
        RoutineException abortException;
        TimeDuration delay;
        Object object = this.mMutex;
        synchronized (object) {
            delay = this.mResultDelay;
            abortException = this.mState.abortInvocation(reason, delay);
        }
        if (abortException != null) {
            if (delay.isZero()) {
                this.mHandler.onAbort(abortException, 0L, TimeUnit.MILLISECONDS);
            } else {
                this.mRunner.run(new DelayedAbortExecution(abortException), delay.time, delay.unit);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.mMutex;
        synchronized (object) {
            return this.mOutputQueue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        Object object = this.mMutex;
        synchronized (object) {
            return this.mState.isOpen();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultChannelState
    extends OutputChannelState {
        private final Logger mSubLogger;

        private ResultChannelState() {
            this.mSubLogger = DefaultResultChannel.this.mLogger.subContextLogger(this);
        }

        @NotNull
        private IllegalStateException exception() {
            this.mSubLogger.err("invalid call on closed channel");
            return new IllegalStateException("the channel is closed");
        }

        @Override
        void after(@NotNull TimeDuration delay) {
            throw this.exception();
        }

        @Override
        boolean closeResultChannel() {
            this.mSubLogger.dbg("avoiding closing result channel since already closed");
            return false;
        }

        @Override
        boolean delayedOutput(@NotNull NestedQueue<Object> queue, @Nullable OUT output) {
            this.mSubLogger.dbg("delayed output execution: %s", output);
            if (--DefaultResultChannel.this.mPendingOutputCount == 0) {
                DefaultResultChannel.this.mState = new FlushChannelState();
            }
            queue.add(output);
            queue.close();
            return true;
        }

        @Override
        boolean delayedOutputs(@NotNull NestedQueue<Object> queue, List<OUT> outputs) {
            this.mSubLogger.dbg("delayed output execution: %s", (Object)outputs);
            if (--DefaultResultChannel.this.mPendingOutputCount == 0) {
                DefaultResultChannel.this.mState = new FlushChannelState();
            }
            queue.addAll(outputs);
            queue.close();
            return true;
        }

        @Override
        void orderBy(@NotNull InvocationConfiguration.OrderType orderType) {
            throw this.exception();
        }

        @Override
        boolean isOpen() {
            return false;
        }

        @Override
        boolean onConsumerComplete(@NotNull NestedQueue<Object> queue) {
            queue.close();
            if (--DefaultResultChannel.this.mPendingOutputCount == 0) {
                DefaultResultChannel.this.mState = new FlushChannelState();
                return true;
            }
            DefaultResultChannel.this.mMutex.notifyAll();
            return false;
        }

        @Override
        @Nullable
        OutputConsumer<OUT> pass(@Nullable Channel.OutputChannel<? extends OUT> channel) {
            throw this.exception();
        }

        @Override
        @Nullable
        Execution pass(@Nullable Iterable<? extends OUT> outputs) {
            throw this.exception();
        }

        @Override
        @Nullable
        Execution pass(@Nullable OUT output) {
            throw this.exception();
        }

        @Override
        @Nullable
        Execution pass(OUT ... outputs) {
            throw this.exception();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OutputChannelState {
        private final Logger mSubLogger;

        private OutputChannelState() {
            this.mSubLogger = DefaultResultChannel.this.mLogger.subContextLogger(this);
        }

        @Nullable
        RoutineException abortConsumer(@NotNull Throwable reason) {
            RoutineException abortException = InvocationException.wrapIfNeeded(reason);
            this.mSubLogger.wrn(reason, "aborting on consumer exception (%s)", (Object)DefaultResultChannel.this.mOutputConsumer);
            DefaultResultChannel.this.internalAbort(abortException);
            return abortException;
        }

        @Nullable
        RoutineException abortInvocation(@Nullable Throwable reason, @NotNull TimeDuration delay) {
            RoutineException abortException = AbortException.wrapIfNeeded(reason);
            if (delay.isZero()) {
                this.mSubLogger.dbg(reason, "aborting channel");
                DefaultResultChannel.this.internalAbort(abortException);
            }
            return abortException;
        }

        @Nullable
        RoutineException abortOutputChannel(@Nullable Throwable reason) {
            RoutineException abortException = AbortException.wrapIfNeeded(reason);
            this.mSubLogger.dbg(reason, "aborting output");
            DefaultResultChannel.this.internalAbort(abortException);
            return abortException;
        }

        void after(@NotNull TimeDuration delay) {
            if (delay == null) {
                this.mSubLogger.err("invalid null delay");
                throw new NullPointerException("the input delay must not be null");
            }
            DefaultResultChannel.this.mResultDelay = delay;
        }

        void closeConsumer(@NotNull OutputConsumer<? super OUT> consumer) {
            Logger logger = this.mSubLogger;
            try {
                logger.dbg("closing consumer (%s)", (Object)consumer);
                consumer.onComplete();
            }
            catch (Throwable t) {
                InvocationInterruptedException.throwIfInterrupt(t);
                logger.err(t, "ignoring consumer exception (%s)", (Object)consumer);
            }
        }

        boolean closeResultChannel() {
            this.mSubLogger.dbg("closing result channel [#%d]", (Object)DefaultResultChannel.this.mPendingOutputCount);
            if (DefaultResultChannel.this.mPendingOutputCount > 0) {
                DefaultResultChannel.this.mState = new ResultChannelState();
            } else {
                DefaultResultChannel.this.mState = new FlushChannelState();
            }
            return true;
        }

        @Nullable
        RoutineException delayedAbortInvocation(@Nullable RoutineException reason) {
            this.mSubLogger.dbg(reason, "aborting channel");
            DefaultResultChannel.this.internalAbort(reason);
            return reason;
        }

        boolean delayedOutput(@NotNull NestedQueue<Object> queue, @Nullable OUT output) {
            this.mSubLogger.dbg("delayed output execution: %s", output);
            --DefaultResultChannel.this.mPendingOutputCount;
            queue.add(output);
            queue.close();
            return true;
        }

        boolean delayedOutputs(@NotNull NestedQueue<Object> queue, List<OUT> outputs) {
            this.mSubLogger.dbg("delayed output execution: %s", (Object)outputs);
            --DefaultResultChannel.this.mPendingOutputCount;
            queue.addAll(outputs);
            queue.close();
            return true;
        }

        boolean isDone() {
            return false;
        }

        boolean isOpen() {
            return true;
        }

        boolean isReadyToComplete() {
            return false;
        }

        boolean onConsumerComplete(@NotNull NestedQueue<Object> queue) {
            queue.close();
            --DefaultResultChannel.this.mPendingOutputCount;
            DefaultResultChannel.this.mMutex.notifyAll();
            return false;
        }

        boolean onConsumerError(@Nullable RoutineException error) {
            this.mSubLogger.dbg(error, "aborting output");
            DefaultResultChannel.this.internalAbort(error);
            return true;
        }

        @Nullable
        Execution onConsumerOutput(@NotNull NestedQueue<Object> queue, OUT output, @NotNull TimeDuration delay, InvocationConfiguration.OrderType orderType) {
            this.mSubLogger.dbg("consumer output [#%d+1]: %s [%s]", (Object)DefaultResultChannel.this.mOutputCount, output, (Object)delay);
            ++DefaultResultChannel.this.mOutputCount;
            if (!DefaultResultChannel.this.mHasOutputs.isTrue()) {
                DefaultResultChannel.this.waitOutputs(1, delay);
                if (DefaultResultChannel.this.mState != this) {
                    --DefaultResultChannel.this.mOutputCount;
                    return DefaultResultChannel.this.mState.onConsumerOutput(queue, output, delay, orderType);
                }
            }
            if (delay.isZero()) {
                queue.add(output);
                return null;
            }
            ++DefaultResultChannel.this.mPendingOutputCount;
            return new DelayedOutputExecution(orderType != InvocationConfiguration.OrderType.BY_CHANCE ? queue.addNested() : queue, output);
        }

        void orderBy(@NotNull InvocationConfiguration.OrderType orderType) {
            DefaultResultChannel.this.mResultOrder = orderType;
        }

        @Nullable
        OutputConsumer<OUT> pass(@Nullable Channel.OutputChannel<? extends OUT> channel) {
            if (channel == null) {
                this.mSubLogger.wrn("passing null channel");
                return null;
            }
            DefaultResultChannel.this.mBoundChannels.add(channel);
            ++DefaultResultChannel.this.mPendingOutputCount;
            this.mSubLogger.dbg("passing channel: %s", (Object)channel);
            return new DefaultOutputConsumer();
        }

        @Nullable
        Execution pass(@Nullable Iterable<? extends OUT> outputs) {
            if (outputs == null) {
                this.mSubLogger.wrn("passing null iterable");
                return null;
            }
            ArrayList list = new ArrayList();
            for (Object output : outputs) {
                list.add(output);
            }
            int size = list.size();
            if (size > DefaultResultChannel.this.mMaxOutput) {
                throw new OutputTimeoutException("outputs exceed maximum channel size [" + size + "/" + DefaultResultChannel.this.mMaxOutput + "]");
            }
            TimeDuration delay = DefaultResultChannel.this.mResultDelay;
            this.mSubLogger.dbg("passing iterable [#%d+%d]: %s [%s]", (Object)DefaultResultChannel.this.mOutputCount, (Object)size, (Object)outputs, (Object)delay);
            DefaultResultChannel.this.mOutputCount += size;
            if (!DefaultResultChannel.this.mHasOutputs.isTrue()) {
                DefaultResultChannel.this.waitOutputs(size, delay);
                if (DefaultResultChannel.this.mState != this) {
                    DefaultResultChannel.this.mOutputCount -= size;
                    return DefaultResultChannel.this.mState.pass((OUT)outputs);
                }
            }
            if (delay.isZero()) {
                DefaultResultChannel.this.mOutputQueue.addAll(list);
                return null;
            }
            ++DefaultResultChannel.this.mPendingOutputCount;
            return new DelayedListOutputExecution(DefaultResultChannel.this.mResultOrder != InvocationConfiguration.OrderType.BY_CHANCE ? DefaultResultChannel.this.mOutputQueue.addNested() : DefaultResultChannel.this.mOutputQueue, list);
        }

        @Nullable
        Execution pass(@Nullable OUT output) {
            TimeDuration delay = DefaultResultChannel.this.mResultDelay;
            this.mSubLogger.dbg("passing output [#%d+1]: %s [%s]", (Object)DefaultResultChannel.this.mOutputCount, output, (Object)delay);
            ++DefaultResultChannel.this.mOutputCount;
            if (!DefaultResultChannel.this.mHasOutputs.isTrue()) {
                DefaultResultChannel.this.waitOutputs(1, delay);
                if (DefaultResultChannel.this.mState != this) {
                    --DefaultResultChannel.this.mOutputCount;
                    return DefaultResultChannel.this.mState.pass((OUT)output);
                }
            }
            if (delay.isZero()) {
                DefaultResultChannel.this.mOutputQueue.add(output);
                return null;
            }
            ++DefaultResultChannel.this.mPendingOutputCount;
            return new DelayedOutputExecution(DefaultResultChannel.this.mResultOrder != InvocationConfiguration.OrderType.BY_CHANCE ? DefaultResultChannel.this.mOutputQueue.addNested() : DefaultResultChannel.this.mOutputQueue, output);
        }

        @Nullable
        Execution pass(OUT ... outputs) {
            if (outputs == null) {
                this.mSubLogger.wrn("passing null output array");
                return null;
            }
            int size = outputs.length;
            if (size > DefaultResultChannel.this.mMaxOutput) {
                throw new OutputTimeoutException("outputs exceed maximum channel size [" + size + "/" + DefaultResultChannel.this.mMaxOutput + "]");
            }
            TimeDuration delay = DefaultResultChannel.this.mResultDelay;
            this.mSubLogger.dbg("passing array [#%d+%d]: %s [%s]", (Object)DefaultResultChannel.this.mOutputCount, (Object)size, (Object)outputs, (Object)delay);
            DefaultResultChannel.this.mOutputCount += size;
            if (!DefaultResultChannel.this.mHasOutputs.isTrue()) {
                DefaultResultChannel.this.waitOutputs(size, delay);
                if (DefaultResultChannel.this.mState != this) {
                    DefaultResultChannel.this.mOutputCount -= size;
                    return DefaultResultChannel.this.mState.pass(outputs);
                }
            }
            ArrayList list = new ArrayList(size);
            Collections.addAll(list, outputs);
            if (delay.isZero()) {
                DefaultResultChannel.this.mOutputQueue.addAll(list);
                return null;
            }
            ++DefaultResultChannel.this.mPendingOutputCount;
            return new DelayedListOutputExecution(DefaultResultChannel.this.mResultOrder != InvocationConfiguration.OrderType.BY_CHANCE ? DefaultResultChannel.this.mOutputQueue.addNested() : DefaultResultChannel.this.mOutputQueue, list);
        }

        @NotNull
        OutputChannelState toDoneState() {
            return new DoneChannelState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FlushChannelState
    extends ResultChannelState {
        private final Logger mSubLogger;

        private FlushChannelState() {
            this.mSubLogger = DefaultResultChannel.this.mLogger.subContextLogger(this);
        }

        @NotNull
        private IllegalStateException exception() {
            this.mSubLogger.err("consumer invalid call on closed channel");
            return new IllegalStateException("the channel is closed");
        }

        @Override
        @Nullable
        RoutineException abortInvocation(@Nullable Throwable reason, @NotNull TimeDuration delay) {
            this.mSubLogger.dbg(reason, "avoiding aborting since channel is closed");
            return null;
        }

        @Override
        @Nullable
        RoutineException abortOutputChannel(@Nullable Throwable reason) {
            this.mSubLogger.dbg("avoiding aborting output since result channel is closed");
            return null;
        }

        @Override
        boolean delayedOutput(@NotNull NestedQueue<Object> queue, @Nullable OUT output) {
            this.mSubLogger.dbg("avoiding delayed output execution since channel is closed: %s", output);
            return false;
        }

        @Override
        boolean delayedOutputs(@NotNull NestedQueue<Object> queue, List<OUT> outputs) {
            this.mSubLogger.dbg("avoiding delayed output execution since channel is closed: %s", (Object)outputs);
            return false;
        }

        @Override
        boolean onConsumerComplete(@NotNull NestedQueue<Object> queue) {
            throw this.exception();
        }

        @Override
        boolean onConsumerError(@Nullable RoutineException error) {
            this.mSubLogger.dbg("avoiding aborting output since result channel is closed");
            return false;
        }

        @Override
        @Nullable
        Execution onConsumerOutput(@NotNull NestedQueue<Object> queue, OUT output, @NotNull TimeDuration delay, InvocationConfiguration.OrderType orderType) {
            throw this.exception();
        }

        @Override
        boolean isReadyToComplete() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExceptionChannelState
    extends FlushChannelState {
        private final Logger mSubLogger;

        private ExceptionChannelState() {
            this.mSubLogger = DefaultResultChannel.this.mLogger.subContextLogger(this);
        }

        @Override
        @Nullable
        RoutineException abortConsumer(@NotNull Throwable reason) {
            return null;
        }

        @Override
        void after(@NotNull TimeDuration delay) {
            throw this.abortException();
        }

        @Override
        boolean onConsumerComplete(@NotNull NestedQueue<Object> queue) {
            throw this.abortException();
        }

        @Override
        @Nullable
        Execution onConsumerOutput(@NotNull NestedQueue<Object> queue, OUT output, @NotNull TimeDuration delay, InvocationConfiguration.OrderType orderType) {
            throw this.abortException();
        }

        @NotNull
        private RoutineException abortException() {
            RoutineException abortException = DefaultResultChannel.this.mAbortException;
            this.mSubLogger.dbg(abortException, "abort exception");
            return DefaultResultChannel.this.mAbortException;
        }

        @Override
        void orderBy(@NotNull InvocationConfiguration.OrderType orderType) {
            throw this.abortException();
        }

        @Override
        @Nullable
        RoutineException delayedAbortInvocation(@Nullable RoutineException reason) {
            this.mSubLogger.dbg(reason, "avoiding aborting since channel is closed");
            return null;
        }

        @Override
        boolean isReadyToComplete() {
            return false;
        }

        @Override
        @Nullable
        OutputConsumer<OUT> pass(@Nullable Channel.OutputChannel<? extends OUT> channel) {
            throw this.abortException();
        }

        @Override
        @Nullable
        Execution pass(@Nullable Iterable<? extends OUT> outputs) {
            throw this.abortException();
        }

        @Override
        @Nullable
        Execution pass(@Nullable OUT output) {
            throw this.abortException();
        }

        @Override
        @Nullable
        Execution pass(OUT ... outputs) {
            throw this.abortException();
        }

        @Override
        @NotNull
        OutputChannelState toDoneState() {
            return new AbortedChannelState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DoneChannelState
    extends FlushChannelState {
        private final Logger mSubLogger;

        private DoneChannelState() {
            this.mSubLogger = DefaultResultChannel.this.mLogger.subContextLogger(this);
        }

        @Override
        @Nullable
        RoutineException delayedAbortInvocation(@Nullable RoutineException reason) {
            if (DefaultResultChannel.this.mOutputQueue.isEmpty()) {
                this.mSubLogger.dbg(reason, "avoiding aborting since channel is closed");
                return null;
            }
            return super.delayedAbortInvocation(reason);
        }

        @Override
        boolean isDone() {
            return true;
        }

        @Override
        boolean isReadyToComplete() {
            return false;
        }

        @Override
        @NotNull
        OutputChannelState toDoneState() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DelayedOutputExecution
    extends TemplateExecution {
        private final OUT mOutput;
        private final NestedQueue<Object> mQueue;

        private DelayedOutputExecution(@Nullable NestedQueue<Object> queue, OUT output) {
            this.mQueue = queue;
            this.mOutput = output;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean needsFlush;
            Object object = DefaultResultChannel.this.mMutex;
            synchronized (object) {
                needsFlush = DefaultResultChannel.this.mState.delayedOutput(this.mQueue, this.mOutput);
            }
            if (needsFlush) {
                DefaultResultChannel.this.flushOutput(false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DelayedListOutputExecution
    extends TemplateExecution {
        private final ArrayList<OUT> mOutputs;
        private final NestedQueue<Object> mQueue;

        private DelayedListOutputExecution(NestedQueue<Object> queue, ArrayList<OUT> outputs) {
            this.mOutputs = outputs;
            this.mQueue = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean needsFlush;
            Object object = DefaultResultChannel.this.mMutex;
            synchronized (object) {
                needsFlush = DefaultResultChannel.this.mState.delayedOutputs(this.mQueue, this.mOutputs);
            }
            if (needsFlush) {
                DefaultResultChannel.this.flushOutput(false);
            }
        }
    }

    private class DelayedAbortExecution
    extends TemplateExecution {
        private final RoutineException mAbortException;

        private DelayedAbortExecution(RoutineException reason) {
            this.mAbortException = reason;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            RoutineException abortException;
            Object object = DefaultResultChannel.this.mMutex;
            synchronized (object) {
                abortException = DefaultResultChannel.this.mState.delayedAbortInvocation(this.mAbortException);
            }
            if (abortException != null) {
                DefaultResultChannel.this.mHandler.onAbort(abortException, 0L, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultOutputConsumer
    implements OutputConsumer<OUT> {
        private final TimeDuration mDelay;
        private final InvocationConfiguration.OrderType mOrderType;
        private final NestedQueue<Object> mQueue;
        private final Logger mSubLogger;

        private DefaultOutputConsumer() {
            this.mSubLogger = DefaultResultChannel.this.mLogger.subContextLogger(this);
            TimeDuration delay = this.mDelay = DefaultResultChannel.this.mResultDelay;
            InvocationConfiguration.OrderType order = this.mOrderType = DefaultResultChannel.this.mResultOrder;
            this.mQueue = order == InvocationConfiguration.OrderType.BY_CALL || order == InvocationConfiguration.OrderType.BY_DELAY && delay.isZero() ? DefaultResultChannel.this.mOutputQueue.addNested() : DefaultResultChannel.this.mOutputQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            boolean needsFlush;
            Object object = DefaultResultChannel.this.mMutex;
            synchronized (object) {
                needsFlush = DefaultResultChannel.this.mState.onConsumerComplete(this.mQueue);
                this.mSubLogger.dbg("closing output [%s]", (Object)needsFlush);
            }
            if (needsFlush) {
                DefaultResultChannel.this.flushOutput(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(@Nullable RoutineException error) {
            boolean needsAbort;
            Object object = DefaultResultChannel.this.mMutex;
            synchronized (object) {
                needsAbort = DefaultResultChannel.this.mState.onConsumerError(error);
            }
            if (needsAbort) {
                TimeDuration delay = this.mDelay;
                DefaultResultChannel.this.mHandler.onAbort(error, delay.time, delay.unit);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onOutput(OUT output) {
            Execution execution;
            TimeDuration delay = this.mDelay;
            Object object = DefaultResultChannel.this.mMutex;
            synchronized (object) {
                execution = DefaultResultChannel.this.mState.onConsumerOutput(this.mQueue, output, delay, this.mOrderType);
            }
            if (delay.isZero()) {
                DefaultResultChannel.this.flushOutput(false);
            } else if (execution != null) {
                DefaultResultChannel.this.mRunner.run(execution, delay.time, delay.unit);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultOutputChannel
    implements Channel.OutputChannel<OUT> {
        private final Logger mSubLogger;
        private TimeDuration mExecutionTimeout;
        private InvocationConfiguration.TimeoutActionType mTimeoutActionType;
        private Throwable mTimeoutException;

        private DefaultOutputChannel() {
            this.mSubLogger = DefaultResultChannel.this.mLogger.subContextLogger(this);
            this.mExecutionTimeout = TimeDuration.ZERO;
            this.mTimeoutActionType = InvocationConfiguration.TimeoutActionType.THROW;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Channel.OutputChannel<OUT> afterMax(@NotNull TimeDuration timeout) {
            Object object = DefaultResultChannel.this.mMutex;
            synchronized (object) {
                if (timeout == null) {
                    this.mSubLogger.err("invalid null timeout");
                    throw new NullPointerException("the output timeout must not be null");
                }
                this.mExecutionTimeout = timeout;
            }
            return this;
        }

        @Override
        @NotNull
        public Channel.OutputChannel<OUT> afterMax(long timeout, @NotNull TimeUnit timeUnit) {
            return this.afterMax(TimeDuration.fromUnit(timeout, timeUnit));
        }

        @Override
        @NotNull
        public List<OUT> all() {
            ArrayList results = new ArrayList();
            this.allInto(results);
            return results;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Channel.OutputChannel<OUT> allInto(@NotNull Collection<? super OUT> results) {
            Throwable timeoutException;
            boolean isAbort = false;
            Object object = DefaultResultChannel.this.mMutex;
            synchronized (object) {
                DefaultResultChannel.this.verifyBound();
                Logger logger = this.mSubLogger;
                if (results == null) {
                    logger.err("invalid null output list");
                    throw new NullPointerException("the result list must not be null");
                }
                TimeDuration executionTimeout = this.mExecutionTimeout;
                NestedQueue outputQueue = DefaultResultChannel.this.mOutputQueue;
                if (executionTimeout.isZero() || DefaultResultChannel.this.mState.isDone()) {
                    while (!outputQueue.isEmpty()) {
                        Object result = DefaultResultChannel.this.nextOutput(executionTimeout);
                        logger.dbg("adding output to list: %s [%s]", result, (Object)executionTimeout);
                        results.add(result);
                    }
                    if (!DefaultResultChannel.this.mState.isDone()) {
                        InvocationConfiguration.TimeoutActionType timeoutAction = this.mTimeoutActionType;
                        logger.wrn("list output timeout: [%s] => [%s]", (Object)executionTimeout, (Object)timeoutAction);
                        if (timeoutAction == InvocationConfiguration.TimeoutActionType.THROW) {
                            throw new ExecutionTimeoutException("timeout while waiting to collect all outputs");
                        }
                        isAbort = timeoutAction == InvocationConfiguration.TimeoutActionType.ABORT;
                    }
                } else {
                    boolean isTimeout;
                    long startTime = System.currentTimeMillis();
                    try {
                        while (true) {
                            if (!outputQueue.isEmpty()) {
                                Object result = DefaultResultChannel.this.nextOutput(executionTimeout);
                                logger.dbg("adding output to list: %s [%s]", result, (Object)executionTimeout);
                                results.add(result);
                                continue;
                            }
                            if (DefaultResultChannel.this.mState.isDone()) break;
                            if (DefaultResultChannel.this.mRunner.isExecutionThread()) {
                                throw new ExecutionDeadlockException(DefaultResultChannel.getExecutionDeadlockMessage());
                            }
                            if (DefaultResultChannel.this.mIsWaitingInvocation) {
                                throw new InvocationDeadlockException(DefaultResultChannel.getInvocationDeadlockMessage());
                            }
                            if (!executionTimeout.waitSinceMillis(DefaultResultChannel.this.mMutex, startTime)) break;
                        }
                        isTimeout = !DefaultResultChannel.this.mState.isDone();
                    }
                    catch (InterruptedException e) {
                        throw new InvocationInterruptedException(e);
                    }
                    if (isTimeout) {
                        InvocationConfiguration.TimeoutActionType action = this.mTimeoutActionType;
                        logger.wrn("list output timeout: [%s] => [%s]", (Object)executionTimeout, (Object)action);
                        if (action == InvocationConfiguration.TimeoutActionType.THROW) {
                            throw new ExecutionTimeoutException("timeout while waiting to collect all outputs");
                        }
                        isAbort = action == InvocationConfiguration.TimeoutActionType.ABORT;
                    }
                }
                timeoutException = this.mTimeoutException;
            }
            if (isAbort) {
                this.abort(timeoutException);
                throw AbortException.wrapIfNeeded(timeoutException);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean checkComplete() {
            Object object = DefaultResultChannel.this.mMutex;
            synchronized (object) {
                boolean isDone;
                if (DefaultResultChannel.this.mState.isDone()) {
                    return true;
                }
                TimeDuration executionTimeout = this.mExecutionTimeout;
                if (!executionTimeout.isZero()) {
                    if (DefaultResultChannel.this.mRunner.isExecutionThread()) {
                        throw new ExecutionDeadlockException(DefaultResultChannel.getExecutionDeadlockMessage());
                    }
                    if (DefaultResultChannel.this.mIsWaitingInvocation) {
                        throw new InvocationDeadlockException(DefaultResultChannel.getInvocationDeadlockMessage());
                    }
                }
                try {
                    isDone = executionTimeout.waitTrue(DefaultResultChannel.this.mMutex, new TimeDuration.Check(){

                        public boolean isTrue() {
                            return DefaultResultChannel.this.mState.isDone() || DefaultResultChannel.this.mIsWaitingInvocation;
                        }
                    });
                }
                catch (InterruptedException e) {
                    throw new InvocationInterruptedException(e);
                }
                if (DefaultResultChannel.this.mIsWaitingInvocation) {
                    throw new InvocationDeadlockException(DefaultResultChannel.getInvocationDeadlockMessage());
                }
                if (!isDone) {
                    this.mSubLogger.wrn("waiting complete timeout: [%s]", (Object)executionTimeout);
                }
                return isDone;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Channel.OutputChannel<OUT> eventuallyAbort() {
            Object object = DefaultResultChannel.this.mMutex;
            synchronized (object) {
                this.mTimeoutActionType = InvocationConfiguration.TimeoutActionType.ABORT;
                this.mTimeoutException = null;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Channel.OutputChannel<OUT> eventuallyAbort(@Nullable Throwable reason) {
            Object object = DefaultResultChannel.this.mMutex;
            synchronized (object) {
                this.mTimeoutActionType = InvocationConfiguration.TimeoutActionType.ABORT;
                this.mTimeoutException = reason;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Channel.OutputChannel<OUT> eventuallyExit() {
            Object object = DefaultResultChannel.this.mMutex;
            synchronized (object) {
                this.mTimeoutActionType = InvocationConfiguration.TimeoutActionType.EXIT;
                this.mTimeoutException = null;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Channel.OutputChannel<OUT> eventuallyThrow() {
            Object object = DefaultResultChannel.this.mMutex;
            synchronized (object) {
                this.mTimeoutActionType = InvocationConfiguration.TimeoutActionType.THROW;
                this.mTimeoutException = null;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            Throwable timeoutException;
            InvocationConfiguration.TimeoutActionType timeoutAction;
            TimeDuration timeout;
            Object object = DefaultResultChannel.this.mMutex;
            synchronized (object) {
                timeout = this.mExecutionTimeout;
                timeoutAction = this.mTimeoutActionType;
                timeoutException = this.mTimeoutException;
            }
            return DefaultResultChannel.this.isNextAvailable(timeout, timeoutAction, timeoutException);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OUT next() {
            Throwable timeoutException;
            InvocationConfiguration.TimeoutActionType timeoutAction;
            TimeDuration timeout;
            Object object = DefaultResultChannel.this.mMutex;
            synchronized (object) {
                timeout = this.mExecutionTimeout;
                timeoutAction = this.mTimeoutActionType;
                timeoutException = this.mTimeoutException;
            }
            return DefaultResultChannel.this.readNext(timeout, timeoutAction, timeoutException);
        }

        @Override
        @NotNull
        public Channel.OutputChannel<OUT> immediately() {
            return this.afterMax(TimeDuration.ZERO);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isBound() {
            Object object = DefaultResultChannel.this.mMutex;
            synchronized (object) {
                return DefaultResultChannel.this.mOutputConsumer != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public List<OUT> next(int count) {
            ArrayList<Object> results;
            block8: {
                Throwable timeoutException;
                InvocationConfiguration.TimeoutActionType timeoutAction;
                TimeDuration timeout;
                if (count <= 0) {
                    return Collections.emptyList();
                }
                Object object = DefaultResultChannel.this.mMutex;
                synchronized (object) {
                    timeout = this.mExecutionTimeout;
                    timeoutAction = this.mTimeoutActionType;
                    timeoutException = this.mTimeoutException;
                }
                results = new ArrayList<Object>(count);
                long endTime = Time.current().plus(timeout).toMillis();
                try {
                    for (int i = 0; i < count; ++i) {
                        results.add(DefaultResultChannel.this.readNext(TimeDuration.timeUntilMillis(endTime), timeoutAction, timeoutException));
                    }
                }
                catch (NoSuchElementException ignored) {
                    this.mSubLogger.wrn("reading output timeout: [%s] => [%s]", (Object)timeout, (Object)timeoutAction);
                    if (timeoutAction == InvocationConfiguration.TimeoutActionType.THROW) {
                        throw new ExecutionTimeoutException("timeout while waiting for outputs");
                    }
                    if (timeoutAction != InvocationConfiguration.TimeoutActionType.ABORT) break block8;
                    this.abort(timeoutException);
                    throw AbortException.wrapIfNeeded(timeoutException);
                }
            }
            return results;
        }

        @Override
        @NotNull
        public <IN extends Channel.InputChannel<? super OUT>> IN passTo(@NotNull IN channel) {
            channel.pass((DefaultOutputChannel)this);
            return (IN)channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Channel.OutputChannel<OUT> passTo(@NotNull OutputConsumer<? super OUT> consumer) {
            boolean forceClose;
            Object object = DefaultResultChannel.this.mMutex;
            synchronized (object) {
                DefaultResultChannel.this.verifyBound();
                if (consumer == null) {
                    this.mSubLogger.err("invalid null consumer");
                    throw new NullPointerException("the output consumer must not be null");
                }
                forceClose = DefaultResultChannel.this.mState.isDone();
                DefaultResultChannel.this.mOutputConsumer = consumer;
                DefaultResultChannel.this.mConsumerMutex = DefaultResultChannel.getMutex(consumer);
            }
            DefaultResultChannel.this.flushOutput(forceClose);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Channel.OutputChannel<OUT> skip(int count) {
            block8: {
                if (count > 0) {
                    Throwable timeoutException;
                    InvocationConfiguration.TimeoutActionType timeoutAction;
                    TimeDuration timeout;
                    Object object = DefaultResultChannel.this.mMutex;
                    synchronized (object) {
                        timeout = this.mExecutionTimeout;
                        timeoutAction = this.mTimeoutActionType;
                        timeoutException = this.mTimeoutException;
                    }
                    long endTime = Time.current().plus(timeout).toMillis();
                    try {
                        for (int i = 0; i < count; ++i) {
                            DefaultResultChannel.this.readNext(TimeDuration.timeUntilMillis(endTime), timeoutAction, timeoutException);
                        }
                    }
                    catch (NoSuchElementException ignored) {
                        this.mSubLogger.wrn("skipping output timeout: [%s] => [%s]", (Object)timeout, (Object)timeoutAction);
                        if (timeoutAction == InvocationConfiguration.TimeoutActionType.THROW) {
                            throw new ExecutionTimeoutException("timeout while waiting for outputs");
                        }
                        if (timeoutAction != InvocationConfiguration.TimeoutActionType.ABORT) break block8;
                        this.abort(timeoutException);
                        throw AbortException.wrapIfNeeded(timeoutException);
                    }
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Iterator<OUT> iterator() {
            Throwable timeoutException;
            InvocationConfiguration.TimeoutActionType timeoutAction;
            TimeDuration timeout;
            Object object = DefaultResultChannel.this.mMutex;
            synchronized (object) {
                DefaultResultChannel.this.verifyBound();
                timeout = this.mExecutionTimeout;
                timeoutAction = this.mTimeoutActionType;
                timeoutException = this.mTimeoutException;
            }
            return new DefaultIterator(timeout, timeoutAction, timeoutException);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean abort() {
            return this.abort(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean abort(@Nullable Throwable reason) {
            RoutineException abortException;
            Object object = DefaultResultChannel.this.mMutex;
            synchronized (object) {
                abortException = DefaultResultChannel.this.mState.abortOutputChannel(reason);
            }
            if (abortException != null) {
                DefaultResultChannel.this.mHandler.onAbort(abortException, 0L, TimeUnit.MILLISECONDS);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = DefaultResultChannel.this.mMutex;
            synchronized (object) {
                return DefaultResultChannel.this.mOutputQueue.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isOpen() {
            Object object = DefaultResultChannel.this.mMutex;
            synchronized (object) {
                return DefaultResultChannel.this.mState.isOpen();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultIterator
    implements Iterator<OUT> {
        private final InvocationConfiguration.TimeoutActionType mAction;
        private final Throwable mException;
        private final TimeDuration mTimeout;

        private DefaultIterator(@NotNull TimeDuration timeout, @Nullable InvocationConfiguration.TimeoutActionType action, Throwable exception) {
            this.mTimeout = timeout;
            this.mAction = action;
            this.mException = exception;
        }

        @Override
        public boolean hasNext() {
            return DefaultResultChannel.this.isNextAvailable(this.mTimeout, this.mAction, this.mException);
        }

        @Override
        public OUT next() {
            return DefaultResultChannel.this.readNext(this.mTimeout, this.mAction, this.mException);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AbortedChannelState
    extends AbortChannelState {
        private AbortedChannelState() {
        }

        @Override
        boolean isReadyToComplete() {
            return false;
        }

        @Override
        boolean isDone() {
            return true;
        }

        @Override
        @NotNull
        OutputChannelState toDoneState() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AbortChannelState
    extends ExceptionChannelState {
        private final Logger mSubLogger;

        private AbortChannelState() {
            this.mSubLogger = DefaultResultChannel.this.mLogger.subContextLogger(this);
        }

        @Override
        @Nullable
        RoutineException abortConsumer(@NotNull Throwable reason) {
            RoutineException abortException = InvocationException.wrapIfNeeded(reason);
            this.mSubLogger.wrn(reason, "aborting on consumer exception (%s)", (Object)DefaultResultChannel.this.mOutputConsumer);
            DefaultResultChannel.this.internalAbort(abortException);
            return abortException;
        }

        @Override
        boolean isReadyToComplete() {
            return true;
        }

        @Override
        void closeConsumer(@NotNull OutputConsumer<? super OUT> consumer) {
        }
    }

    static interface AbortHandler {
        public void onAbort(@Nullable RoutineException var1, long var2, @NotNull TimeUnit var4);
    }
}

