/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.core;

import com.github.dm.jrt.builder.InvocationConfiguration;
import com.github.dm.jrt.core.AbstractRoutine;
import com.github.dm.jrt.invocation.Invocation;
import com.github.dm.jrt.invocation.InvocationException;
import com.github.dm.jrt.invocation.InvocationFactory;
import com.github.dm.jrt.log.Logger;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultRoutine<IN, OUT>
extends AbstractRoutine<IN, OUT> {
    private final InvocationFactory<IN, OUT> mFactory;

    DefaultRoutine(@NotNull InvocationConfiguration configuration, @NotNull InvocationFactory<IN, OUT> factory) {
        super(configuration);
        if (factory == null) {
            throw new NullPointerException("the invocation factory must not be null");
        }
        this.mFactory = factory;
    }

    @Override
    @NotNull
    protected Invocation<IN, OUT> newInvocation(@NotNull AbstractRoutine.InvocationType type) {
        Logger logger = this.getLogger();
        try {
            InvocationFactory<IN, OUT> factory = this.mFactory;
            logger.dbg("creating a new invocation instance with factory: %s", (Object)factory);
            Invocation<IN, OUT> invocation = factory.newInvocation();
            logger.dbg("created a new instance of class: %s", (Object)invocation.getClass());
            return invocation;
        }
        catch (Throwable t) {
            logger.err(t, "error creating the invocation instance");
            throw InvocationException.wrapIfNeeded(t);
        }
    }
}

