/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.core;

import com.github.dm.jrt.channel.Channel;
import com.github.dm.jrt.channel.IOChannel;
import com.github.dm.jrt.channel.OutputConsumer;
import com.github.dm.jrt.channel.StreamingChannel;
import com.github.dm.jrt.util.TimeDuration;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultStreamingChannel<IN, OUT>
implements StreamingChannel<IN, OUT> {
    private final IOChannel<IN, ?> mInputChannel;
    private final Channel.OutputChannel<OUT> mOutputChannel;

    DefaultStreamingChannel(@NotNull IOChannel<IN, ?> inputChannel, @NotNull Channel.OutputChannel<OUT> outputChannel) {
        if (inputChannel == null) {
            throw new NullPointerException("the input channel must not be null");
        }
        if (outputChannel == null) {
            throw new NullPointerException("the output channel must not be null");
        }
        this.mInputChannel = inputChannel;
        this.mOutputChannel = outputChannel;
    }

    @Override
    public boolean abort() {
        return this.mInputChannel.abort() || this.mOutputChannel.abort();
    }

    @Override
    public boolean abort(@Nullable Throwable reason) {
        return this.mInputChannel.abort(reason) || this.mOutputChannel.abort(reason);
    }

    @Override
    public boolean isEmpty() {
        return this.mInputChannel.isEmpty() && this.mOutputChannel.isEmpty();
    }

    @Override
    public boolean isOpen() {
        return this.mInputChannel.isOpen();
    }

    @Override
    @NotNull
    public StreamingChannel<IN, OUT> after(@NotNull TimeDuration delay) {
        this.mInputChannel.after(delay);
        return this;
    }

    @Override
    @NotNull
    public StreamingChannel<IN, OUT> after(long delay, @NotNull TimeUnit timeUnit) {
        this.mInputChannel.after(delay, timeUnit);
        return this;
    }

    @Override
    @NotNull
    public StreamingChannel<IN, OUT> now() {
        this.mInputChannel.now();
        return this;
    }

    @Override
    @NotNull
    public StreamingChannel<IN, OUT> orderByCall() {
        this.mInputChannel.orderByCall();
        return this;
    }

    @Override
    @NotNull
    public StreamingChannel<IN, OUT> orderByChance() {
        this.mInputChannel.orderByChance();
        return this;
    }

    @Override
    @NotNull
    public StreamingChannel<IN, OUT> orderByDelay() {
        this.mInputChannel.orderByDelay();
        return this;
    }

    @Override
    @NotNull
    public StreamingChannel<IN, OUT> pass(@Nullable Channel.OutputChannel<? extends IN> channel) {
        this.mInputChannel.pass(channel);
        return this;
    }

    @Override
    @NotNull
    public StreamingChannel<IN, OUT> pass(@Nullable Iterable<? extends IN> inputs) {
        this.mInputChannel.pass(inputs);
        return this;
    }

    @Override
    @NotNull
    public StreamingChannel<IN, OUT> pass(@Nullable IN input) {
        this.mInputChannel.pass(input);
        return this;
    }

    @Override
    @NotNull
    public StreamingChannel<IN, OUT> pass(IN ... inputs) {
        this.mInputChannel.pass(inputs);
        return this;
    }

    @Override
    @NotNull
    public StreamingChannel<IN, OUT> afterMax(@NotNull TimeDuration timeout) {
        this.mOutputChannel.afterMax(timeout);
        return this;
    }

    @Override
    @NotNull
    public StreamingChannel<IN, OUT> afterMax(long timeout, @NotNull TimeUnit timeUnit) {
        this.mOutputChannel.afterMax(timeout, timeUnit);
        return this;
    }

    @Override
    @NotNull
    public StreamingChannel<IN, OUT> allInto(@NotNull Collection<? super OUT> results) {
        this.mOutputChannel.allInto(results);
        return this;
    }

    @Override
    @NotNull
    public StreamingChannel<IN, OUT> eventuallyAbort() {
        this.mOutputChannel.eventuallyAbort();
        return this;
    }

    @Override
    @NotNull
    public StreamingChannel<IN, OUT> eventuallyAbort(@Nullable Throwable reason) {
        this.mOutputChannel.eventuallyAbort(reason);
        return this;
    }

    @Override
    @NotNull
    public StreamingChannel<IN, OUT> eventuallyExit() {
        this.mOutputChannel.eventuallyExit();
        return this;
    }

    @Override
    @NotNull
    public StreamingChannel<IN, OUT> eventuallyThrow() {
        this.mOutputChannel.eventuallyThrow();
        return this;
    }

    @Override
    @NotNull
    public StreamingChannel<IN, OUT> immediately() {
        this.mOutputChannel.immediately();
        return this;
    }

    @Override
    @NotNull
    public StreamingChannel<IN, OUT> passTo(@NotNull OutputConsumer<? super OUT> consumer) {
        this.mOutputChannel.passTo(consumer);
        return this;
    }

    @Override
    @NotNull
    public StreamingChannel<IN, OUT> skip(int count) {
        this.mOutputChannel.skip(count);
        return this;
    }

    @Override
    @NotNull
    public StreamingChannel<IN, OUT> close() {
        this.mInputChannel.close();
        return this;
    }

    @Override
    @NotNull
    public <BEFORE> StreamingChannel<BEFORE, OUT> combine(@NotNull IOChannel<BEFORE, ? extends IN> channel) {
        this.mInputChannel.pass(channel).close();
        return new DefaultStreamingChannel<BEFORE, OUT>(channel, this.mOutputChannel);
    }

    @Override
    @NotNull
    public <AFTER> StreamingChannel<IN, AFTER> concat(@NotNull IOChannel<? super OUT, AFTER> channel) {
        this.mOutputChannel.passTo(channel);
        return new DefaultStreamingChannel<IN, OUT>(this.mInputChannel, channel.close());
    }

    @Override
    @NotNull
    public List<OUT> all() {
        return this.mOutputChannel.all();
    }

    @Override
    public boolean checkComplete() {
        return this.mOutputChannel.checkComplete();
    }

    @Override
    public boolean hasNext() {
        return this.mOutputChannel.hasNext();
    }

    @Override
    public OUT next() {
        return this.mOutputChannel.next();
    }

    @Override
    public boolean isBound() {
        return this.mOutputChannel.isBound();
    }

    @Override
    @NotNull
    public List<OUT> next(int count) {
        return this.mOutputChannel.next(count);
    }

    @Override
    @NotNull
    public <CHANNEL extends Channel.InputChannel<? super OUT>> CHANNEL passTo(@NotNull CHANNEL channel) {
        return this.mOutputChannel.passTo(channel);
    }

    @Override
    @NotNull
    public Channel.InputChannel<IN> asInput() {
        return this;
    }

    @Override
    @NotNull
    public Channel.OutputChannel<OUT> asOutput() {
        return this;
    }

    @Override
    public Iterator<OUT> iterator() {
        return this.mOutputChannel.iterator();
    }

    @Override
    public void remove() {
        this.mOutputChannel.remove();
    }
}

