/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.core;

import com.github.dm.jrt.channel.ResultChannel;
import com.github.dm.jrt.channel.RoutineException;
import com.github.dm.jrt.channel.StreamingChannel;
import com.github.dm.jrt.core.Channels;
import com.github.dm.jrt.invocation.Invocation;
import com.github.dm.jrt.invocation.InvocationFactory;
import com.github.dm.jrt.routine.Routine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingInvocation<IN, OUT>
implements Invocation<IN, OUT> {
    private final DelegationType mDelegationType;
    private final Routine<IN, OUT> mRoutine;
    private StreamingChannel<IN, OUT> mChannel;

    private DelegatingInvocation(@NotNull Routine<IN, OUT> routine, @NotNull DelegationType delegation) {
        this.mRoutine = routine;
        this.mDelegationType = delegation;
        this.mChannel = null;
    }

    @NotNull
    public static <IN, OUT> InvocationFactory<IN, OUT> factoryFrom(@NotNull Routine<IN, OUT> routine, @NotNull DelegationType delegation) {
        return new DelegatingInvocationFactory(routine, delegation);
    }

    @Override
    public void onAbort(@Nullable RoutineException reason) {
        this.mChannel.abort(reason);
    }

    @Override
    public void onDestroy() {
        this.mRoutine.purge();
    }

    @Override
    public void onInitialize() {
        DelegationType delegationType = this.mDelegationType;
        this.mChannel = delegationType == DelegationType.ASYNC ? Channels.asyncStream(this.mRoutine) : (delegationType == DelegationType.PARALLEL ? Channels.parallelStream(this.mRoutine) : Channels.syncStream(this.mRoutine));
    }

    @Override
    public void onInput(IN input, @NotNull ResultChannel<OUT> result) {
        StreamingChannel<IN, OUT> channel = this.mChannel;
        if (!channel.isBound()) {
            channel.passTo(result);
        }
        channel.pass(input);
    }

    @Override
    public void onResult(@NotNull ResultChannel<OUT> result) {
        StreamingChannel<IN, OUT> channel = this.mChannel;
        if (!channel.isBound()) {
            channel.passTo(result);
        }
        channel.close();
    }

    @Override
    public void onTerminate() {
        this.mChannel = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelegatingInvocationFactory<IN, OUT>
    extends InvocationFactory<IN, OUT> {
        private final DelegationType mDelegationType;
        private final Routine<IN, OUT> mRoutine;

        private DelegatingInvocationFactory(@NotNull Routine<IN, OUT> routine, @NotNull DelegationType delegationType) {
            if (routine == null) {
                throw new NullPointerException("the routine must not be null");
            }
            if (delegationType == null) {
                throw new NullPointerException("the invocation type must not be null");
            }
            this.mRoutine = routine;
            this.mDelegationType = delegationType;
        }

        @Override
        @NotNull
        public Invocation<IN, OUT> newInvocation() {
            return new DelegatingInvocation(this.mRoutine, this.mDelegationType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DelegationType {
        SYNC,
        ASYNC,
        PARALLEL;

    }
}

