/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.core;

import com.github.dm.jrt.channel.RoutineException;
import com.github.dm.jrt.core.DefaultResultChannel;
import com.github.dm.jrt.core.InvocationManager;
import com.github.dm.jrt.core.InvocationObserver;
import com.github.dm.jrt.invocation.Invocation;
import com.github.dm.jrt.log.Logger;
import com.github.dm.jrt.runner.Execution;
import com.github.dm.jrt.runner.TemplateExecution;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InvocationExecution<IN, OUT>
implements Execution,
InvocationObserver<IN, OUT> {
    private final Object mAbortMutex = new Object();
    private final InputIterator<IN> mInputIterator;
    private final InvocationManager<IN, OUT> mInvocationManager;
    private final Logger mLogger;
    private final Object mMutex = new Object();
    private final DefaultResultChannel<OUT> mResultChannel;
    private AbortExecution mAbortExecution;
    private int mExecutionCount = 1;
    private Invocation<IN, OUT> mInvocation;
    private boolean mIsWaitingAbortInvocation;
    private boolean mIsWaitingInvocation;

    InvocationExecution(@NotNull InvocationManager<IN, OUT> manager, @NotNull InputIterator<IN> inputs, @NotNull DefaultResultChannel<OUT> result, @NotNull Logger logger) {
        if (manager == null) {
            throw new NullPointerException("the invocation manager must not be null");
        }
        if (inputs == null) {
            throw new NullPointerException("the input iterator must not be null");
        }
        if (result == null) {
            throw new NullPointerException("the result channel must not be null");
        }
        this.mInvocationManager = manager;
        this.mInputIterator = inputs;
        this.mResultChannel = result;
        this.mLogger = logger.subContextLogger(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Execution abort() {
        Object object = this.mAbortMutex;
        synchronized (object) {
            if (this.mAbortExecution == null) {
                this.mAbortExecution = new AbortExecution();
            }
            return this.mAbortExecution;
        }
    }

    @Override
    public boolean mayBeCanceled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onCreate(@NotNull Invocation<IN, OUT> invocation) {
        Object object = this.mMutex;
        synchronized (object) {
            this.mIsWaitingInvocation = false;
            InputIterator<IN> inputIterator = this.mInputIterator;
            InvocationManager<IN, OUT> manager = this.mInvocationManager;
            DefaultResultChannel<OUT> resultChannel = this.mResultChannel;
            resultChannel.stopWaitingInvocation();
            int count = this.mExecutionCount;
            this.mExecutionCount = 1;
            try {
                int i = 0;
                while (i < count) {
                    block20: {
                        try {
                            boolean isComplete;
                            inputIterator.onConsumeStart();
                            this.mLogger.dbg("running execution");
                            try {
                                if (this.mInvocation == null) {
                                    this.mInvocation = invocation;
                                    this.mLogger.dbg("initializing invocation: %s", (Object)invocation);
                                    invocation.onInitialize();
                                }
                                while (inputIterator.hasInput()) {
                                    invocation.onInput(inputIterator.nextInput(), resultChannel);
                                }
                            }
                            finally {
                                isComplete = inputIterator.onConsumeComplete();
                            }
                            if (!isComplete) break block20;
                            invocation.onResult(resultChannel);
                            try {
                                invocation.onTerminate();
                                manager.recycle(invocation);
                            }
                            catch (Throwable ignored) {
                                manager.discard(invocation);
                            }
                            finally {
                                resultChannel.close();
                                inputIterator.onInvocationComplete();
                            }
                        }
                        catch (Throwable t) {
                            resultChannel.abortImmediately(t);
                        }
                    }
                    ++i;
                }
                return;
            }
            finally {
                AbortExecution abortExecution = this.mAbortExecution;
                if (this.mIsWaitingAbortInvocation && abortExecution != null) {
                    abortExecution.onCreate(invocation);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Invocation<IN, OUT> invocation;
        Object object = this.mMutex;
        synchronized (object) {
            if (this.mIsWaitingInvocation) {
                ++this.mExecutionCount;
                return;
            }
            invocation = this.mInvocation;
            boolean bl = this.mIsWaitingInvocation = invocation == null;
            if (this.mIsWaitingAbortInvocation) {
                return;
            }
        }
        if (invocation != null) {
            this.onCreate(invocation);
        } else {
            this.mInvocationManager.create(this);
            object = this.mMutex;
            synchronized (object) {
                if (this.mInvocation == null) {
                    this.mResultChannel.startWaitingInvocation();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(@NotNull Throwable error) {
        Object object = this.mMutex;
        synchronized (object) {
            this.mResultChannel.close(error);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AbortExecution
    extends TemplateExecution
    implements InvocationObserver<IN, OUT> {
        private int mAbortExecutionCount = 1;

        private AbortExecution() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCreate(@NotNull Invocation<IN, OUT> invocation) {
            Object object = InvocationExecution.this.mMutex;
            synchronized (object) {
                InvocationExecution.this.mIsWaitingAbortInvocation = false;
                InputIterator inputIterator = InvocationExecution.this.mInputIterator;
                InvocationManager manager = InvocationExecution.this.mInvocationManager;
                DefaultResultChannel resultChannel = InvocationExecution.this.mResultChannel;
                int count = this.mAbortExecutionCount;
                this.mAbortExecutionCount = 1;
                try {
                    for (int i = 0; i < count; ++i) {
                        if (!inputIterator.isAborting()) {
                            InvocationExecution.this.mLogger.wrn("avoiding aborting since input is already aborted");
                            return;
                        }
                        RoutineException exception = inputIterator.getAbortException();
                        InvocationExecution.this.mLogger.dbg(exception, "aborting invocation");
                        try {
                            if (InvocationExecution.this.mInvocation == null) {
                                InvocationExecution.this.mInvocation = invocation;
                                InvocationExecution.this.mLogger.dbg("initializing invocation: %s", (Object)invocation);
                                invocation.onInitialize();
                            }
                            invocation.onAbort(exception);
                            invocation.onTerminate();
                            manager.recycle(invocation);
                            resultChannel.close(exception);
                            continue;
                        }
                        catch (Throwable t) {
                            manager.discard(invocation);
                            resultChannel.close(t);
                        }
                    }
                }
                finally {
                    inputIterator.onAbortComplete();
                    if (InvocationExecution.this.mIsWaitingInvocation) {
                        InvocationExecution.this.onCreate(invocation);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(@NotNull Throwable error) {
            Object object = InvocationExecution.this.mMutex;
            synchronized (object) {
                InvocationExecution.this.mResultChannel.close(error);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Invocation invocation;
            Object object = InvocationExecution.this.mMutex;
            synchronized (object) {
                if (InvocationExecution.this.mIsWaitingAbortInvocation) {
                    ++this.mAbortExecutionCount;
                    return;
                }
                invocation = InvocationExecution.this.mInvocation;
                InvocationExecution.this.mIsWaitingAbortInvocation = invocation == null;
                if (InvocationExecution.this.mIsWaitingInvocation) {
                    return;
                }
            }
            if (invocation != null) {
                this.onCreate(invocation);
            } else {
                InvocationExecution.this.mInvocationManager.create(this);
                object = InvocationExecution.this.mMutex;
                synchronized (object) {
                    if (InvocationExecution.this.mInvocation == null) {
                        InvocationExecution.this.mResultChannel.startWaitingInvocation();
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface InputIterator<IN> {
        @Nullable
        public RoutineException getAbortException();

        public boolean hasInput();

        public boolean isAborting();

        @Nullable
        public IN nextInput();

        public void onAbortComplete();

        public boolean onConsumeComplete();

        public void onConsumeStart();

        public void onInvocationComplete();
    }
}

