/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.core;

import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InvocationTarget<TYPE> {
    private InvocationTarget() {
    }

    @NotNull
    public static <TYPE> ClassInvocationTarget<TYPE> classOfType(@NotNull Class<TYPE> targetClass) {
        return new ClassInvocationTarget(targetClass);
    }

    @NotNull
    public static <TYPE> InstanceInvocationTarget<TYPE> instance(@NotNull TYPE target) {
        return new InstanceInvocationTarget(target);
    }

    @Nullable
    public abstract Object getTarget();

    @NotNull
    public abstract Class<? extends TYPE> getTargetClass();

    public abstract boolean isAssignableTo(@NotNull Class<?> var1);

    public abstract boolean isSameTypeOf(@NotNull Class<?> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InstanceInvocationTarget<TYPE>
    extends InvocationTarget<TYPE> {
        private final WeakReference<TYPE> mTarget;
        private final Class<? extends TYPE> mTargetClass;

        private InstanceInvocationTarget(@NotNull TYPE target) {
            this.mTarget = new WeakReference<TYPE>(target);
            this.mTargetClass = target.getClass();
        }

        @Override
        public boolean isSameTypeOf(@NotNull Class<?> type) {
            return type.isInstance(this.mTarget.get());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof InstanceInvocationTarget)) {
                return false;
            }
            InstanceInvocationTarget that = (InstanceInvocationTarget)o;
            Object referent = this.mTarget.get();
            return referent != null && referent.equals(that.mTarget.get()) && this.mTargetClass.equals(that.mTargetClass);
        }

        public int hashCode() {
            Object referent = this.mTarget.get();
            int result = referent != null ? referent.hashCode() : 0;
            result = 31 * result + this.mTargetClass.hashCode();
            return result;
        }

        @Override
        @Nullable
        public Object getTarget() {
            return this.mTarget.get();
        }

        @Override
        @NotNull
        public Class<? extends TYPE> getTargetClass() {
            return this.mTargetClass;
        }

        @Override
        public boolean isAssignableTo(@NotNull Class<?> otherClass) {
            return otherClass.isInstance(this.mTarget.get());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassInvocationTarget<TYPE>
    extends InvocationTarget<TYPE> {
        private final Class<TYPE> mTargetClass;

        private ClassInvocationTarget(@NotNull Class<TYPE> targetClass) {
            if (targetClass == null) {
                throw new NullPointerException("the target class must not be null");
            }
            this.mTargetClass = targetClass;
        }

        @Override
        @Nullable
        public Object getTarget() {
            return this.mTargetClass;
        }

        public int hashCode() {
            return this.mTargetClass.hashCode();
        }

        @Override
        public boolean isSameTypeOf(@NotNull Class<?> type) {
            return this.mTargetClass == type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassInvocationTarget)) {
                return false;
            }
            ClassInvocationTarget that = (ClassInvocationTarget)o;
            return this.mTargetClass.equals(that.mTargetClass);
        }

        @Override
        @NotNull
        public Class<? extends TYPE> getTargetClass() {
            return this.mTargetClass;
        }

        @Override
        public boolean isAssignableTo(@NotNull Class<?> otherClass) {
            return otherClass.isAssignableFrom(this.mTargetClass);
        }
    }
}

