/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.core;

import com.github.dm.jrt.core.SimpleQueue;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NestedQueue<E> {
    private static final Object EMPTY_ELEMENT = new Object();
    private final SimpleQueue<Object> mQueue = new SimpleQueue();
    private boolean mClosed;

    NestedQueue() {
    }

    @Nullable
    private static Object prune(@NotNull NestedQueue<?> queue) {
        SimpleQueue<Object> simpleQueue = queue.mQueue;
        if (simpleQueue.isEmpty()) {
            return EMPTY_ELEMENT;
        }
        Object element = simpleQueue.peekFirst();
        while (element instanceof NestedQueue) {
            NestedQueue nested = (NestedQueue)element;
            if (!nested.mClosed || NestedQueue.prune(nested) != EMPTY_ELEMENT) {
                return nested;
            }
            simpleQueue.removeFirst();
            if (simpleQueue.isEmpty()) {
                return EMPTY_ELEMENT;
            }
            element = simpleQueue.peekFirst();
        }
        return element;
    }

    public void add(@Nullable E element) {
        this.checkOpen();
        this.mQueue.add(element);
    }

    public void addAll(@NotNull Iterable<? extends E> elements) {
        this.checkOpen();
        this.mQueue.addAll(elements);
    }

    @NotNull
    public NestedQueue<E> addNested() {
        this.checkOpen();
        NestedQueue<E> queue = new NestedQueue<E>();
        this.mQueue.add(queue);
        return queue;
    }

    public void clear() {
        this.mQueue.clear();
    }

    public void close() {
        this.mClosed = true;
    }

    public void drainTo(@NotNull Collection<? super E> collection) {
        if (NestedQueue.prune(this) == EMPTY_ELEMENT) {
            return;
        }
        SimpleQueue<Object> queue = this.mQueue;
        while (!queue.isEmpty()) {
            Object element = queue.peekFirst();
            if (element instanceof NestedQueue) {
                NestedQueue nested = (NestedQueue)element;
                nested.drainTo(collection);
                if (!nested.mClosed || !nested.mQueue.isEmpty()) {
                    return;
                }
                queue.removeFirst();
                continue;
            }
            collection.add(queue.removeFirst());
        }
    }

    public boolean isEmpty() {
        Object element = NestedQueue.prune(this);
        return element == EMPTY_ELEMENT || element instanceof NestedQueue && ((NestedQueue)element).isEmpty();
    }

    @Nullable
    public E removeFirst() {
        Object element = NestedQueue.prune(this);
        if (element instanceof NestedQueue) {
            return ((NestedQueue)element).removeFirst();
        }
        return (E)this.mQueue.removeFirst();
    }

    private void checkOpen() {
        if (this.mClosed) {
            throw new IllegalStateException("the queue is closed");
        }
    }
}

