/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.core;

import com.github.dm.jrt.annotation.Alias;
import com.github.dm.jrt.annotation.CoreInstances;
import com.github.dm.jrt.annotation.Input;
import com.github.dm.jrt.annotation.InputMaxSize;
import com.github.dm.jrt.annotation.InputOrder;
import com.github.dm.jrt.annotation.InputTimeout;
import com.github.dm.jrt.annotation.Inputs;
import com.github.dm.jrt.annotation.Invoke;
import com.github.dm.jrt.annotation.LogLevel;
import com.github.dm.jrt.annotation.MaxInstances;
import com.github.dm.jrt.annotation.Output;
import com.github.dm.jrt.annotation.OutputMaxSize;
import com.github.dm.jrt.annotation.OutputOrder;
import com.github.dm.jrt.annotation.OutputTimeout;
import com.github.dm.jrt.annotation.Priority;
import com.github.dm.jrt.annotation.ReadTimeout;
import com.github.dm.jrt.annotation.ReadTimeoutAction;
import com.github.dm.jrt.annotation.SharedFields;
import com.github.dm.jrt.builder.InvocationConfiguration;
import com.github.dm.jrt.builder.ProxyConfiguration;
import com.github.dm.jrt.channel.Channel;
import com.github.dm.jrt.channel.InvocationChannel;
import com.github.dm.jrt.channel.ResultChannel;
import com.github.dm.jrt.channel.RoutineException;
import com.github.dm.jrt.invocation.InvocationException;
import com.github.dm.jrt.invocation.InvocationInterruptedException;
import com.github.dm.jrt.routine.Routine;
import com.github.dm.jrt.util.Mutex;
import com.github.dm.jrt.util.Reflection;
import com.github.dm.jrt.util.WeakIdentityHashMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoutineBuilders {
    private static final WeakIdentityHashMap<Class<?>, Map<String, Method>> sAliasMethods = new WeakIdentityHashMap();
    private static final WeakIdentityHashMap<Object, Map<String, ReentrantLock>> sLocks = new WeakIdentityHashMap();
    private static final WeakIdentityHashMap<Class<?>, Map<Method, MethodInfo>> sMethods = new WeakIdentityHashMap();
    private static final WeakIdentityHashMap<Object, ExchangeMutex> sMutexes = new WeakIdentityHashMap();

    protected RoutineBuilders() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void callFromInvocation(@NotNull Mutex mutex, @NotNull Object target, @NotNull Method targetMethod, @NotNull List<?> objects, @NotNull ResultChannel<Object> result, @Nullable Input.InputMode inputMode, @Nullable Output.OutputMode outputMode) {
        Reflection.makeAccessible(targetMethod);
        try {
            Object methodResult;
            mutex.acquire();
            try {
                Object[] args;
                if (inputMode == Input.InputMode.COLLECTION) {
                    Class<?> paramClass = targetMethod.getParameterTypes()[0];
                    if (paramClass.isArray()) {
                        int size = objects.size();
                        Object array = Array.newInstance(paramClass.getComponentType(), size);
                        for (int i = 0; i < size; ++i) {
                            Array.set(array, i, objects.get(i));
                        }
                        args = Reflection.asArgs(array);
                    } else {
                        args = Reflection.asArgs(objects);
                    }
                } else {
                    args = objects.toArray(new Object[objects.size()]);
                }
                methodResult = targetMethod.invoke(target, args);
            }
            finally {
                mutex.release();
            }
            Class<?> returnType = targetMethod.getReturnType();
            if (!Void.class.equals(Reflection.boxingClass(returnType))) {
                if (outputMode == Output.OutputMode.ELEMENT) {
                    if (returnType.isArray()) {
                        if (methodResult != null) {
                            result.orderByCall();
                            int length = Array.getLength(methodResult);
                            for (int i = 0; i < length; ++i) {
                                result.pass(Array.get(methodResult, i));
                            }
                        }
                    } else {
                        result.pass((Object)((Iterable)methodResult));
                    }
                } else {
                    result.pass(methodResult);
                }
            }
        }
        catch (RoutineException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new InvocationException(e.getCause());
        }
        catch (Throwable t) {
            throw new InvocationException(t);
        }
    }

    @NotNull
    public static InvocationConfiguration configurationWithAnnotations(@Nullable InvocationConfiguration configuration, @NotNull Method method) {
        ReadTimeoutAction actionAnnotation;
        ReadTimeout readTimeoutAnnotation;
        Priority priorityAnnotation;
        OutputTimeout outputTimeoutAnnotation;
        OutputOrder outputOrderAnnotation;
        OutputMaxSize outputSizeAnnotation;
        MaxInstances maxInstancesAnnotation;
        LogLevel logLevelAnnotation;
        InputTimeout inputTimeoutAnnotation;
        InputOrder inputOrderAnnotation;
        InputMaxSize inputSizeAnnotation;
        InvocationConfiguration.Builder<InvocationConfiguration> builder = InvocationConfiguration.builderFrom(configuration);
        CoreInstances coreInstancesAnnotation = method.getAnnotation(CoreInstances.class);
        if (coreInstancesAnnotation != null) {
            builder.withCoreInstances(coreInstancesAnnotation.value());
        }
        if ((inputSizeAnnotation = method.getAnnotation(InputMaxSize.class)) != null) {
            builder.withInputMaxSize(inputSizeAnnotation.value());
        }
        if ((inputOrderAnnotation = method.getAnnotation(InputOrder.class)) != null) {
            builder.withInputOrder(inputOrderAnnotation.value());
        }
        if ((inputTimeoutAnnotation = method.getAnnotation(InputTimeout.class)) != null) {
            builder.withInputTimeout(inputTimeoutAnnotation.value(), inputTimeoutAnnotation.unit());
        }
        if ((logLevelAnnotation = method.getAnnotation(LogLevel.class)) != null) {
            builder.withLogLevel(logLevelAnnotation.value());
        }
        if ((maxInstancesAnnotation = method.getAnnotation(MaxInstances.class)) != null) {
            builder.withMaxInstances(maxInstancesAnnotation.value());
        }
        if ((outputSizeAnnotation = method.getAnnotation(OutputMaxSize.class)) != null) {
            builder.withOutputMaxSize(outputSizeAnnotation.value());
        }
        if ((outputOrderAnnotation = method.getAnnotation(OutputOrder.class)) != null) {
            builder.withOutputOrder(outputOrderAnnotation.value());
        }
        if ((outputTimeoutAnnotation = method.getAnnotation(OutputTimeout.class)) != null) {
            builder.withOutputTimeout(outputTimeoutAnnotation.value(), outputTimeoutAnnotation.unit());
        }
        if ((priorityAnnotation = method.getAnnotation(Priority.class)) != null) {
            builder.withPriority(priorityAnnotation.value());
        }
        if ((readTimeoutAnnotation = method.getAnnotation(ReadTimeout.class)) != null) {
            builder.withReadTimeout(readTimeoutAnnotation.value(), readTimeoutAnnotation.unit());
        }
        if ((actionAnnotation = method.getAnnotation(ReadTimeoutAction.class)) != null) {
            builder.withReadTimeoutAction(actionAnnotation.value());
        }
        return builder.set();
    }

    @NotNull
    public static ProxyConfiguration configurationWithAnnotations(@Nullable ProxyConfiguration configuration, @NotNull Method method) {
        ProxyConfiguration.Builder<ProxyConfiguration> builder = ProxyConfiguration.builderFrom(configuration);
        SharedFields sharedFieldsAnnotation = method.getAnnotation(SharedFields.class);
        if (sharedFieldsAnnotation != null) {
            builder.withSharedFields(sharedFieldsAnnotation.value());
        }
        return builder.set();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Method getAnnotatedMethod(@NotNull Class<?> targetClass, @NotNull String name) {
        WeakIdentityHashMap<Class<?>, Map<String, Method>> weakIdentityHashMap = sAliasMethods;
        synchronized (weakIdentityHashMap) {
            WeakIdentityHashMap<Class<?>, Map<String, Method>> aliasMethods = sAliasMethods;
            Map<String, Method> methodMap = aliasMethods.get(targetClass);
            if (methodMap == null) {
                methodMap = new HashMap<String, Method>();
                RoutineBuilders.fillMap(methodMap, targetClass.getMethods());
                HashMap<String, Method> declaredMethodMap = new HashMap<String, Method>();
                RoutineBuilders.fillMap(declaredMethodMap, targetClass.getDeclaredMethods());
                for (Map.Entry<String, Method> methodEntry : declaredMethodMap.entrySet()) {
                    String methodName = methodEntry.getKey();
                    if (methodMap.containsKey(methodName)) continue;
                    methodMap.put(methodName, methodEntry.getValue());
                }
                aliasMethods.put(targetClass, methodMap);
            }
            return methodMap.get(name);
        }
    }

    @Nullable
    public static Input.InputMode getInputMode(@NotNull Method method, int index) {
        Input inputAnnotation = null;
        Annotation[][] annotations = method.getParameterAnnotations();
        for (Annotation annotation : annotations[index]) {
            if (annotation.annotationType() != Input.class) continue;
            inputAnnotation = (Input)annotation;
            break;
        }
        if (inputAnnotation == null) {
            return null;
        }
        Input.InputMode inputMode = inputAnnotation.mode();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<?> parameterType = parameterTypes[index];
        if (inputMode == Input.InputMode.CHANNEL) {
            if (!Channel.OutputChannel.class.isAssignableFrom(parameterType)) {
                throw new IllegalArgumentException("[" + method + "] an async input with mode " + (Object)((Object)Input.InputMode.CHANNEL) + " must extends an " + Channel.OutputChannel.class.getCanonicalName());
            }
        } else if (inputMode == Input.InputMode.COLLECTION) {
            if (!Channel.OutputChannel.class.isAssignableFrom(parameterType)) {
                throw new IllegalArgumentException("[" + method + "] an async input with mode " + (Object)((Object)Input.InputMode.COLLECTION) + " must extends an " + Channel.OutputChannel.class.getCanonicalName());
            }
            Class<List> paramClass = inputAnnotation.value();
            if (!paramClass.isArray() && !paramClass.isAssignableFrom(List.class)) {
                throw new IllegalArgumentException("[" + method + "] an async input with mode " + (Object)((Object)Input.InputMode.COLLECTION) + " must be bound to an array or a superclass of " + List.class.getCanonicalName());
            }
            int length = parameterTypes.length;
            if (length > 1) {
                throw new IllegalArgumentException("[" + method + "] an async input with mode " + (Object)((Object)Input.InputMode.COLLECTION) + " cannot be applied to a method taking " + length + " input parameters");
            }
        } else {
            boolean isArray = parameterType.isArray();
            if (!isArray && !Iterable.class.isAssignableFrom(parameterType)) {
                throw new IllegalArgumentException("[" + method + "] an async input with mode " + (Object)((Object)Input.InputMode.ELEMENT) + " must be an array or implement an " + Iterable.class.getCanonicalName());
            }
            Class<?> paramClass = inputAnnotation.value();
            if (isArray && !Reflection.boxingClass(paramClass).isAssignableFrom(Reflection.boxingClass(parameterType.getComponentType()))) {
                throw new IllegalArgumentException("[" + method + "] the async input array with mode " + (Object)((Object)Input.InputMode.ELEMENT) + " does not match the bound type: " + paramClass.getCanonicalName());
            }
            int length = parameterTypes.length;
            if (length > 1) {
                throw new IllegalArgumentException("[" + method + "] an async input with mode " + (Object)((Object)Input.InputMode.ELEMENT) + " cannot be applied to a method taking " + length + " input parameters");
            }
        }
        return inputMode;
    }

    @Nullable
    public static Invoke.InvocationMode getInvocationMode(@NotNull Method method) {
        Invoke methodAnnotation = method.getAnnotation(Invoke.class);
        if (methodAnnotation == null) {
            return null;
        }
        Invoke.InvocationMode invocationMode = methodAnnotation.value();
        if (invocationMode == Invoke.InvocationMode.PARALLEL && method.getParameterTypes().length > 1) {
            throw new IllegalArgumentException("methods annotated with invocation mode " + (Object)((Object)Invoke.InvocationMode.PARALLEL) + " must have at maximum one input parameter: " + method);
        }
        return invocationMode;
    }

    @Nullable
    public static Output.OutputMode getOutputMode(@NotNull Method method, @NotNull Class<?> targetReturnType) {
        Output outputAnnotation = method.getAnnotation(Output.class);
        if (outputAnnotation == null) {
            return null;
        }
        Class returnType = method.getReturnType();
        Output.OutputMode outputMode = outputAnnotation.value();
        if (outputMode == Output.OutputMode.CHANNEL) {
            if (!returnType.isAssignableFrom(Channel.OutputChannel.class)) {
                String channelClassName = Channel.OutputChannel.class.getCanonicalName();
                throw new IllegalArgumentException("[" + method + "] an async output with mode " + (Object)((Object)Output.OutputMode.CHANNEL) + " must be a superclass of " + channelClassName);
            }
        } else if (outputMode == Output.OutputMode.ELEMENT) {
            if (!returnType.isAssignableFrom(Channel.OutputChannel.class)) {
                String channelClassName = Channel.OutputChannel.class.getCanonicalName();
                throw new IllegalArgumentException("[" + method + "] an async output with mode " + (Object)((Object)Output.OutputMode.CHANNEL) + " must be a superclass of " + channelClassName);
            }
            if (!targetReturnType.isArray() && !Iterable.class.isAssignableFrom(targetReturnType)) {
                throw new IllegalArgumentException("[" + method + "] an async output with mode " + (Object)((Object)Output.OutputMode.ELEMENT) + " must be bound to an array or a type implementing an " + Iterable.class.getCanonicalName());
            }
        } else {
            if (!returnType.isArray() && !returnType.isAssignableFrom(List.class)) {
                throw new IllegalArgumentException("[" + method + "] an async output with mode " + (Object)((Object)Output.OutputMode.COLLECTION) + " must be an array or a superclass of " + List.class.getCanonicalName());
            }
            if (returnType.isArray() && !Reflection.boxingClass(returnType.getComponentType()).isAssignableFrom(Reflection.boxingClass(targetReturnType))) {
                throw new IllegalArgumentException("[" + method + "] the async output array with mode " + (Object)((Object)Output.OutputMode.COLLECTION) + " does not match the bound type: " + targetReturnType.getCanonicalName());
            }
        }
        return outputMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Mutex getSharedMutex(@Nullable Object target, @Nullable List<String> sharedFields) {
        ExchangeMutex exchangeMutex;
        if (target == null || sharedFields != null && sharedFields.isEmpty()) {
            return Mutex.NO_MUTEX;
        }
        WeakIdentityHashMap<Object, Object> weakIdentityHashMap = sMutexes;
        synchronized (weakIdentityHashMap) {
            WeakIdentityHashMap<Object, ExchangeMutex> mutexes = sMutexes;
            exchangeMutex = mutexes.get(target);
            if (exchangeMutex == null) {
                exchangeMutex = new ExchangeMutex();
                mutexes.put(target, exchangeMutex);
            }
        }
        if (sharedFields == null) {
            return exchangeMutex;
        }
        weakIdentityHashMap = sLocks;
        synchronized (weakIdentityHashMap) {
            WeakIdentityHashMap<Object, Map<String, ReentrantLock>> locksCache = sLocks;
            Map<String, ReentrantLock> lockMap = locksCache.get(target);
            if (lockMap == null) {
                lockMap = new HashMap<String, ReentrantLock>();
                locksCache.put(target, lockMap);
            }
            TreeSet<String> nameSet = new TreeSet<String>(sharedFields);
            int size = nameSet.size();
            ReentrantLock[] locks = new ReentrantLock[size];
            int i = 0;
            for (String name : nameSet) {
                ReentrantLock lock = lockMap.get(name);
                if (lock == null) {
                    lock = new ReentrantLock();
                    lockMap.put(name, lock);
                }
                locks[i++] = lock;
            }
            return new BuilderMutex(exchangeMutex, locks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static MethodInfo getTargetMethodInfo(@NotNull Class<?> targetClass, @NotNull Method proxyMethod) {
        MethodInfo methodInfo;
        WeakIdentityHashMap<Class<?>, Map<Method, MethodInfo>> weakIdentityHashMap = sMethods;
        synchronized (weakIdentityHashMap) {
            WeakIdentityHashMap<Class<?>, Map<Method, MethodInfo>> methodCache = sMethods;
            Map<Method, MethodInfo> methodMap = methodCache.get(targetClass);
            if (methodMap == null) {
                methodMap = new HashMap<Method, MethodInfo>();
                methodCache.put(targetClass, methodMap);
            }
            if ((methodInfo = methodMap.get(proxyMethod)) == null) {
                Class<?>[] targetParameterTypes;
                Invoke.InvocationMode invocationMode = RoutineBuilders.getInvocationMode(proxyMethod);
                Input.InputMode inputMode = null;
                Output.OutputMode outputMode = null;
                Inputs inputsAnnotation = proxyMethod.getAnnotation(Inputs.class);
                if (inputsAnnotation != null) {
                    if (proxyMethod.getParameterTypes().length > 0) {
                        throw new IllegalArgumentException("methods annotated with " + Inputs.class.getSimpleName() + " must have no input parameters: " + proxyMethod);
                    }
                    Class<Object> returnType = proxyMethod.getReturnType();
                    if (!returnType.isAssignableFrom(InvocationChannel.class) && !returnType.isAssignableFrom(Routine.class)) {
                        throw new IllegalArgumentException("the proxy method has incompatible return type: " + proxyMethod);
                    }
                    targetParameterTypes = inputsAnnotation.value();
                    inputMode = Input.InputMode.CHANNEL;
                    outputMode = Output.OutputMode.CHANNEL;
                } else {
                    targetParameterTypes = proxyMethod.getParameterTypes();
                    Annotation[][] annotations = proxyMethod.getParameterAnnotations();
                    int length = annotations.length;
                    block3: for (int i = 0; i < length; ++i) {
                        Input.InputMode paramMode = RoutineBuilders.getInputMode(proxyMethod, i);
                        if (paramMode == null) continue;
                        inputMode = paramMode;
                        for (Annotation paramAnnotation : annotations[i]) {
                            if (paramAnnotation.annotationType() != Input.class) continue;
                            targetParameterTypes[i] = ((Input)paramAnnotation).value();
                            continue block3;
                        }
                    }
                }
                if (invocationMode == Invoke.InvocationMode.PARALLEL && targetParameterTypes.length > 1) {
                    throw new IllegalArgumentException("methods annotated with invocation mode " + (Object)((Object)Invoke.InvocationMode.PARALLEL) + " must have no input parameters: " + proxyMethod);
                }
                Method targetMethod = RoutineBuilders.getTargetMethod(proxyMethod, targetClass, targetParameterTypes);
                Class<?> returnType = proxyMethod.getReturnType();
                Class<?> targetReturnType = targetMethod.getReturnType();
                Output outputAnnotation = proxyMethod.getAnnotation(Output.class);
                boolean isError = false;
                if (outputAnnotation != null) {
                    outputMode = RoutineBuilders.getOutputMode(proxyMethod, targetReturnType);
                    if (outputMode == Output.OutputMode.COLLECTION && returnType.isArray()) {
                        isError = !Reflection.boxingClass(returnType.getComponentType()).isAssignableFrom(Reflection.boxingClass(targetReturnType));
                    }
                } else if (inputsAnnotation == null) {
                    boolean bl = isError = !returnType.isAssignableFrom(targetReturnType);
                }
                if (isError) {
                    throw new IllegalArgumentException("the proxy method has incompatible return type: " + proxyMethod);
                }
                methodInfo = new MethodInfo(targetMethod, invocationMode, inputMode, outputMode);
                methodMap.put(proxyMethod, methodInfo);
            }
        }
        return methodInfo;
    }

    @Nullable
    public static Object invokeRoutine(@NotNull Routine<Object, Object> routine, @NotNull Method method, @NotNull Object[] args, @Nullable Invoke.InvocationMode invocationMode, @Nullable Input.InputMode inputMode, @Nullable Output.OutputMode outputMode) {
        Channel.OutputChannel<Object> outputChannel;
        int i;
        InvocationChannel<Object, Object> invocationChannel;
        Class<Object> returnType = method.getReturnType();
        if (method.isAnnotationPresent(Inputs.class)) {
            if (returnType.isAssignableFrom(InvocationChannel.class)) {
                return invocationMode == Invoke.InvocationMode.SYNC ? routine.syncInvoke() : (invocationMode == Invoke.InvocationMode.PARALLEL ? routine.parallelInvoke() : routine.asyncInvoke());
            }
            return routine;
        }
        InvocationChannel<Object, Object> invocationChannel2 = invocationMode == Invoke.InvocationMode.SYNC ? routine.syncInvoke() : (invocationChannel = invocationMode == Invoke.InvocationMode.PARALLEL ? routine.parallelInvoke() : routine.asyncInvoke());
        if (inputMode == Input.InputMode.ELEMENT) {
            Class<?> parameterType = method.getParameterTypes()[0];
            Object arg = args[0];
            if (arg == null) {
                invocationChannel.pass((Object)null);
            } else if (Channel.OutputChannel.class.isAssignableFrom(parameterType)) {
                invocationChannel.pass((Object)((Channel.OutputChannel)arg));
            } else if (parameterType.isArray()) {
                int length = Array.getLength(arg);
                for (i = 0; i < length; ++i) {
                    invocationChannel.pass(Array.get(arg, i));
                }
            } else {
                Iterable iterable = (Iterable)arg;
                for (Object input : iterable) {
                    invocationChannel.pass(input);
                }
            }
            outputChannel = invocationChannel.result();
        } else if (inputMode == Input.InputMode.CHANNEL) {
            invocationChannel.orderByCall();
            Class<?>[] parameterTypes = method.getParameterTypes();
            int length = args.length;
            for (int i2 = 0; i2 < length; ++i2) {
                Object arg = args[i2];
                if (Channel.OutputChannel.class.isAssignableFrom(parameterTypes[i2])) {
                    invocationChannel.pass((Object)((Channel.OutputChannel)arg));
                    continue;
                }
                invocationChannel.pass(arg);
            }
            outputChannel = invocationChannel.result();
        } else {
            outputChannel = inputMode == Input.InputMode.COLLECTION ? routine.asyncInvoke().orderByCall().pass((Object)((Channel.OutputChannel)args[0])).result() : routine.asyncCall((Object[])args);
        }
        if (!Void.class.equals(Reflection.boxingClass(returnType))) {
            if (outputMode != null) {
                if (Channel.OutputChannel.class.isAssignableFrom(returnType)) {
                    return outputChannel;
                }
                if (returnType.isAssignableFrom(List.class)) {
                    return outputChannel.all();
                }
                if (returnType.isArray()) {
                    List<Object> results = outputChannel.all();
                    int size = results.size();
                    Object array = Array.newInstance(returnType.getComponentType(), size);
                    for (i = 0; i < size; ++i) {
                        Array.set(array, i, results.get(i));
                    }
                    return array;
                }
            }
            return outputChannel.all().iterator().next();
        }
        outputChannel.checkComplete();
        return null;
    }

    private static void fillMap(@NotNull Map<String, Method> map, @NotNull Method[] methods) {
        for (Method method : methods) {
            Alias annotation = method.getAnnotation(Alias.class);
            if (annotation == null) continue;
            String name = annotation.value();
            if (map.containsKey(name)) {
                throw new IllegalArgumentException("the name '" + name + "' has already been used to identify a different" + " method");
            }
            map.put(name, method);
        }
    }

    @NotNull
    private static Method getTargetMethod(@NotNull Method method, @NotNull Class<?> targetClass, @NotNull Class<?>[] targetParameterTypes) {
        String name = null;
        Method targetMethod = null;
        Alias annotation = method.getAnnotation(Alias.class);
        if (annotation != null) {
            name = annotation.value();
            targetMethod = RoutineBuilders.getAnnotatedMethod(targetClass, name);
        }
        if (targetMethod == null) {
            if (name == null) {
                name = method.getName();
            }
            targetMethod = Reflection.findMethod(targetClass, name, targetParameterTypes);
        } else {
            Reflection.findMethod(targetClass, targetMethod.getName(), targetParameterTypes);
        }
        return targetMethod;
    }

    private static class ExchangeMutex
    implements Mutex {
        private final ReentrantLock mLock = new ReentrantLock();
        private final Object mMutex = new Object();
        private int mFullMutexCount;
        private int mPartialMutexCount;

        private ExchangeMutex() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquirePartialMutex() {
            try {
                Object object = this.mMutex;
                synchronized (object) {
                    while (this.mFullMutexCount > 0) {
                        this.mMutex.wait();
                    }
                    ++this.mPartialMutexCount;
                }
            }
            catch (InterruptedException e) {
                InvocationInterruptedException.throwIfInterrupt(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releasePartialMutex() {
            Object object = this.mMutex;
            synchronized (object) {
                --this.mPartialMutexCount;
                this.mMutex.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() {
            try {
                Object object = this.mMutex;
                synchronized (object) {
                    while (this.mPartialMutexCount > 0) {
                        this.mMutex.wait();
                    }
                    ++this.mFullMutexCount;
                }
                this.mLock.lock();
            }
            catch (InterruptedException e) {
                InvocationInterruptedException.throwIfInterrupt(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            this.mLock.unlock();
            Object object = this.mMutex;
            synchronized (object) {
                --this.mFullMutexCount;
                this.mMutex.notifyAll();
            }
        }
    }

    private static class BuilderMutex
    implements Mutex {
        private final ReentrantLock[] mLocks;
        private final ExchangeMutex mMutex;

        private BuilderMutex(@NotNull ExchangeMutex mutex, @NotNull ReentrantLock[] locks) {
            this.mMutex = mutex;
            this.mLocks = locks;
        }

        public void acquire() {
            this.mMutex.acquirePartialMutex();
            for (ReentrantLock lock : this.mLocks) {
                lock.lock();
            }
        }

        public void release() {
            ReentrantLock[] locks = this.mLocks;
            int length = locks.length;
            for (int i = length - 1; i >= 0; --i) {
                locks[i].unlock();
            }
            this.mMutex.releasePartialMutex();
        }
    }

    public static class MethodInfo {
        public final Input.InputMode inputMode;
        public final Invoke.InvocationMode invocationMode;
        public final Method method;
        public final Output.OutputMode outputMode;

        private MethodInfo(@NotNull Method method, @Nullable Invoke.InvocationMode invocationMode, @Nullable Input.InputMode inputMode, @Nullable Output.OutputMode outputMode) {
            this.method = method;
            this.invocationMode = invocationMode;
            this.inputMode = inputMode;
            this.outputMode = outputMode;
        }
    }
}

