/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleQueue<E> {
    private int mFirst;
    private int mLast;
    private Object[] mQueue = new Object[8];

    SimpleQueue() {
    }

    private static void resizeArray(@NotNull Object[] src, @NotNull Object[] dst, int first) {
        int remainder = src.length - first;
        System.arraycopy(src, 0, dst, 0, first);
        System.arraycopy(src, first, dst, dst.length - remainder, remainder);
    }

    public void add(@Nullable E element) {
        int i = this.mLast;
        int newLast = i + 1 & this.mQueue.length - 1;
        this.mQueue[i] = element;
        if (this.mFirst == newLast) {
            this.doubleCapacity();
        }
        this.mLast = newLast;
    }

    public void addAll(@NotNull Iterable<? extends E> elements) {
        for (E element : elements) {
            this.add(element);
        }
    }

    public void clear() {
        this.mFirst = 0;
        this.mLast = 0;
        Arrays.fill(this.mQueue, null);
    }

    public void drainTo(@NotNull Collection<? super E> collection) {
        while (!this.isEmpty()) {
            collection.add(this.removeFirst());
        }
    }

    public boolean isEmpty() {
        return this.mFirst == this.mLast;
    }

    @Nullable
    public E peekFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (E)this.mQueue[this.mFirst];
    }

    @Nullable
    public E removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object[] queue = this.mQueue;
        int i = this.mFirst;
        this.mFirst = i + 1 & queue.length - 1;
        Object output = queue[i];
        queue[i] = null;
        return (E)output;
    }

    public int size() {
        int last = this.mLast;
        int first = this.mFirst;
        return last >= first ? last - first : this.mQueue.length + last - first;
    }

    private void doubleCapacity() {
        int size = this.mQueue.length;
        int newSize = size << 1;
        if (newSize < size) {
            throw new OutOfMemoryError();
        }
        int first = this.mFirst;
        int last = this.mLast;
        Object[] newQueue = new Object[newSize];
        SimpleQueue.resizeArray(this.mQueue, newQueue, first);
        this.mQueue = newQueue;
        int shift = newSize - size;
        this.mFirst = first + shift;
        this.mLast = last < first ? last : last + shift;
    }
}

