/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.function;

import com.github.dm.jrt.channel.ResultChannel;
import com.github.dm.jrt.function.BiFunction;
import com.github.dm.jrt.function.BiFunctionWrapper;
import com.github.dm.jrt.function.Functions;
import com.github.dm.jrt.invocation.Invocation;
import com.github.dm.jrt.invocation.InvocationFactory;
import com.github.dm.jrt.invocation.TemplateInvocation;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AccumulateInvocation<IN>
extends TemplateInvocation<IN, IN> {
    private final BiFunction<? super IN, ? super IN, ? extends IN> mFunction;
    private IN mAccumulated;
    private boolean mIsFirst;

    private AccumulateInvocation(@NotNull BiFunction<? super IN, ? super IN, ? extends IN> function) {
        this.mFunction = function;
    }

    @NotNull
    public static <IN> InvocationFactory<IN, IN> functionFactory(@NotNull BiFunction<? super IN, ? super IN, ? extends IN> function) {
        return new AccumulateInvocationFactory(Functions.wrapBiFunction(function));
    }

    @Override
    public void onInitialize() {
        this.mIsFirst = true;
    }

    @Override
    public void onInput(IN input, @NotNull ResultChannel<IN> result) {
        if (this.mIsFirst) {
            this.mIsFirst = false;
            this.mAccumulated = input;
        } else {
            this.mAccumulated = this.mFunction.apply(this.mAccumulated, input);
        }
    }

    @Override
    public void onResult(@NotNull ResultChannel<IN> result) {
        result.pass(this.mAccumulated);
    }

    @Override
    public void onTerminate() {
        this.mAccumulated = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AccumulateInvocationFactory<IN>
    extends InvocationFactory<IN, IN> {
        private final BiFunction<? super IN, ? super IN, ? extends IN> mFunction;

        private AccumulateInvocationFactory(@NotNull BiFunctionWrapper<? super IN, ? super IN, ? extends IN> function) {
            if (!function.hasStaticContext()) {
                throw new IllegalArgumentException("the bi-function class must have a static context: " + function.getClass());
            }
            this.mFunction = function;
        }

        public int hashCode() {
            return this.mFunction.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AccumulateInvocationFactory)) {
                return false;
            }
            AccumulateInvocationFactory that = (AccumulateInvocationFactory)o;
            return this.mFunction.equals(that.mFunction);
        }

        @Override
        @NotNull
        public Invocation<IN, IN> newInvocation() {
            return new AccumulateInvocation(this.mFunction);
        }
    }
}

